/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.reportitems;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tctsa.common.util.BigDecimalUtil;
import kd.taxc.tctsa.common.util.DateUtils;
import kd.taxc.tctsa.common.util.PermissionUtils;
import org.apache.commons.lang.StringUtils;

public class StayReportTaskItemPlugin
extends AbstractFormPlugin {
    private static final String TCTSA_REPORT_DTASK_BILL = "tctsa_report_dtask_bill";
    private static final String ENTRYENTITY1 = "entryentity1";
    private static final String ENTRYENTITY = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object pkId = customParams.get("numberid");
        Object isstay = customParams.get("isstay");
        if (pkId == null) {
            return;
        }
        if (isstay == null) {
            return;
        }
        long resultId = (Long)pkId;
        this.handlerEvent(resultId, (String)isstay);
        this.getPageCache().put("pkId", String.valueOf(resultId));
        this.getPageCache().put("isstay", String.valueOf(isstay));
    }

    public void afterBindData(EventObject e) {
        boolean hasSpecificPerm = PermissionUtils.hasSpecificPerm((IFormView)this.getView(), (String)"4715a0df000000ac");
        if (!hasSpecificPerm) {
            this.getView().setStatus(OperationStatus.VIEW);
        }
    }

    private void handlerEvent(long resultId, String isstay) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)resultId, (String)TCTSA_REPORT_DTASK_BILL);
        if (dynamicObject != null) {
            this.getModel().setValue("orgfield", dynamicObject.get("orgfield.id"));
            this.getModel().setValue("name", (Object)dynamicObject.getString("name"));
            this.getModel().setValue("billno", (Object)dynamicObject.getString("billno"));
            this.getModel().setValue("start", (Object)DateUtils.format((Date)((Date)dynamicObject.get("start"))));
            this.getModel().setValue("end", (Object)DateUtils.format((Date)((Date)dynamicObject.get("end"))));
            this.getModel().setValue("des", (Object)dynamicObject.getString("des"));
            DynamicObjectCollection labelsCollection = dynamicObject.getDynamicObjectCollection(ENTRYENTITY1);
            this.getModel().deleteEntryData(ENTRYENTITY);
            for (DynamicObject dynamic : labelsCollection) {
                int row = this.getModel().createNewEntryRow(ENTRYENTITY);
                this.getModel().setValue("labelfield", dynamic.get("labelid"), row);
            }
            DynamicObjectCollection reportCollection = dynamicObject.getDynamicObjectCollection(ENTRYENTITY);
            this.getModel().deleteEntryData(ENTRYENTITY1);
            for (DynamicObject dynamic : reportCollection) {
                int row = this.getModel().createNewEntryRow(ENTRYENTITY1);
                this.getModel().setValue("id", dynamic.get("id"), row);
                this.getModel().setValue("xuhao", (Object)(row + 1), row);
                this.getModel().setValue("entryname", dynamic.get("entryname"), row);
                this.getModel().setValue("amountfield", (Object)dynamic.getString("amountfield"), row);
                if ("1".equals(isstay)) {
                    this.getView().setEnable(Boolean.FALSE, row, new String[]{"amountfield"});
                }
                this.getModel().setValue("note", (Object)dynamic.getString("note"), row);
            }
            this.showAndHideButton(isstay);
        }
    }

    private void showAndHideButton(String isstay) {
        if ("1".equals(isstay)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"save"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"submit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"refill"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"save"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"submit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"refill"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            String pkId = this.getPageCache().get("pkId");
            if ("donothingsave".equals(args.getOperateKey())) {
                Boolean isSubmit = this.checkSubmitstatus(pkId);
                if (isSubmit.booleanValue()) {
                    return;
                }
                this.updateCombofieldStatus();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"StayReportTaskItemPlugin_0", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            } else if ("donothingsumbit".equals(args.getOperateKey())) {
                Boolean isSubmit = this.checkSubmitstatus(pkId);
                if (isSubmit.booleanValue()) {
                    return;
                }
                this.updateCombofieldStatus();
                Boolean isPass = this.submitStatus(pkId, false);
                if (isPass.booleanValue()) {
                    return;
                }
                this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"StayReportTaskItemPlugin_1", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
                this.getModel().setDataChanged(false);
                this.getView().close();
                this.getView().getParentView().updateView("billlistap");
                this.getView().sendFormAction(this.getView().getParentView());
            } else if ("donothingrefill".equals(args.getOperateKey())) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("refill", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u91cd\u65b0\u586b\u62a5\u5c06\u8986\u76d6\u5386\u53f2\u6570\u636e\uff0c \u786e\u5b9a\u9700\u8981\u91cd\u65b0\u586b\u62a5\uff1f", (String)"StayReportTaskItemPlugin_2", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
            } else if (args.getOperateKey().equals("save2") && args.getOperationResult().isSuccess()) {
                this.getView().close();
            }
        }
    }

    private Boolean checkSubmitstatus(String pkId) {
        DynamicObject[] summaries;
        Object[] pkIdLong = new Long[5];
        pkIdLong[0] = Long.parseLong(pkId);
        for (DynamicObject summary : summaries = BusinessDataServiceHelper.load((Object[])pkIdLong, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TCTSA_REPORT_DTASK_BILL))) {
            if (!"1".equals(summary.getString("submitstatus"))) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6682\u5b58\u72b6\u6001\u7684\u6570\u636e\u624d\u80fd\u63d0\u4ea4\u3002", (String)"StayReportTaskItemPlugin_5", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((String)"refill", (String)messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"save"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"submit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"refill"});
            this.showAmountfieldColum("amountfield");
            this.submitStatus(this.getPageCache().get("pkId"), true);
        }
    }

    private void showAmountfieldColum(String columKey) {
        int rowCount = this.getModel().getEntryRowCount(ENTRYENTITY1);
        for (int row = 0; row < rowCount; ++row) {
            this.getView().setEnable(Boolean.TRUE, row, new String[]{columKey});
        }
    }

    private Boolean submitStatus(String pkId, Boolean isFill) {
        DynamicObject[] summaries;
        Object[] pkIdLong = new Long[5];
        pkIdLong[0] = Long.parseLong(pkId);
        String combofield = "";
        for (DynamicObject summary : summaries = BusinessDataServiceHelper.load((Object[])pkIdLong, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TCTSA_REPORT_DTASK_BILL))) {
            combofield = summary.getString("combofield");
        }
        if (!"2".equals(combofield)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6709\u4e8b\u9879\u672a\u8fdb\u884c\u91d1\u989d\u586b\u62a5\uff0c\u8bf7\u5b8c\u6210\u586b\u62a5\u518d\u63d0\u4ea4\u3002", (String)"StayReportTaskItemPlugin_3", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            return true;
        }
        for (DynamicObject summary : summaries) {
            summary.set("submitstatus", (Object)(isFill != false ? "2" : "1"));
        }
        SaveServiceHelper.save((DynamicObject[])summaries);
        return false;
    }

    private void updateCombofieldStatus() {
        DynamicObject[] summaries;
        int rowCount = this.getModel().getEntryRowCount(ENTRYENTITY1);
        int record = 0;
        String status = "";
        for (int row = 0; row < rowCount; ++row) {
            if (this.getModel().getValue("amountfield", row) == null) continue;
            ++record;
        }
        if (rowCount > 0) {
            if (record == 0) {
                status = "0";
            } else if (record > 0 && rowCount != record) {
                status = "1";
            } else if (record > 0 && rowCount == record) {
                status = "2";
            }
        }
        String pkId = this.getPageCache().get("pkId");
        Object[] pkIdLong = new Long[5];
        pkIdLong[0] = Long.parseLong(pkId);
        for (DynamicObject summary : summaries = BusinessDataServiceHelper.load((Object[])pkIdLong, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TCTSA_REPORT_DTASK_BILL))) {
            summary.set("combofield", (Object)status);
            summary.set("modifier", (Object)RequestContext.get().getUserId());
            summary.set("modifydate", (Object)new Date());
        }
        SaveServiceHelper.save((DynamicObject[])summaries);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        String pkId = this.getPageCache().get("pkId");
        Object[] pkIdLong = new Long[5];
        pkIdLong[0] = Long.parseLong(pkId);
        if ("amountfield".equals(name)) {
            DynamicObject[] summaries;
            int rowCount = this.getModel().getEntryRowCount(ENTRYENTITY1);
            LinkedHashMap<Long, Map> map = new LinkedHashMap<Long, Map>();
            for (int row = 0; row < rowCount; ++row) {
                Long id = (Long)this.getModel().getValue("id", row);
                Map decimalMap = map.computeIfAbsent(id, k -> new HashMap());
                decimalMap.put("amountfield", (BigDecimal)this.getModel().getValue("amountfield", row));
            }
            for (DynamicObject summary : summaries = BusinessDataServiceHelper.load((Object[])pkIdLong, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TCTSA_REPORT_DTASK_BILL))) {
                DynamicObjectCollection reportCollection = summary.getDynamicObjectCollection(ENTRYENTITY);
                for (DynamicObject dynamic : reportCollection) {
                    Long id = dynamic.getLong("id");
                    if (map.get(id) == null) continue;
                    BigDecimal amountfield = ((Map)map.get(id)).get("amountfield") == null ? null : BigDecimalUtil.toBigDecimal(((Map)map.get(id)).get("amountfield"));
                    dynamic.set("amountfield", amountfield);
                }
            }
            SaveServiceHelper.save((DynamicObject[])summaries);
        }
    }
}

