/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.reportitems;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.taxc.tctsa.common.util.DateUtils;
import kd.taxc.tctsa.common.util.TctsaUtils;
import kd.taxc.tctsa.formplugin.helper.TaxDetailChartHelper;
import org.apache.commons.collections.CollectionUtils;

public class TaxDetailChartFormPlugin
extends AbstractFormPlugin
implements SelectRowsEventListener {
    private static final String ENTRYENTITY1 = "entryentity1";

    public void initialize() {
        CardEntry orgcardList = (CardEntry)this.getView().getControl(ENTRYENTITY1);
        orgcardList.addSelectRowsListener((SelectRowsEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshChart(null);
    }

    private void refreshChart(List<String> list) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String taxName = (String)customParams.get("taxName");
        Date clickStartDate = DateUtils.stringToDate((String)((String)customParams.get("clickStartDate")));
        Date clickEndDate = DateUtils.stringToDate((String)((String)customParams.get("clickEndDate")));
        this.getView().getModel().setValue("daterange_startdate", (Object)clickStartDate);
        this.getView().getModel().setValue("daterange_enddate", (Object)clickEndDate);
        String flag = (String)customParams.get("flag");
        String combofield = (String)customParams.get("combofield");
        List orgs = new ArrayList();
        if (null != customParams.get("orgfield")) {
            orgs = (List)SerializationUtils.fromJsonString((String)customParams.get("orgfield").toString(), List.class);
        }
        List queryOrgList = orgs.stream().map(Object::toString).collect(Collectors.toList());
        List<Long> newQueryOrgList = queryOrgList.stream().map(Long::parseLong).collect(Collectors.toList());
        this.getPageCache().put("combofield", combofield);
        String showName = taxName;
        if ("2".equals(combofield)) {
            Map map = TctsaUtils.getInfoByOrgIdFromErp((String)String.valueOf(taxName), (String[])new String[]{"number", "name", "uniformsocialcreditcode", "frepresentative", "registeredcapital", "establishmentdate", "bankaccount", "depositbank"});
            showName = (String)map.get("name");
        }
        Label totalName = (Label)this.getControl("labelap");
        totalName.setText(String.format(ResManager.loadKDString((String)"[%s]\u660e\u7ec6\u67f1\u72b6\u56fe", (String)"TaxDetailChartFormPlugin_0", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), showName));
        Label cardName = (Label)this.getControl("labelap1");
        cardName.setText("2".equals(combofield) ? ResManager.loadKDString((String)"\u4e8b\u9879\u9009\u62e9", (String)"TaxDetailChartFormPlugin_1", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7ec4\u7ec7\u9009\u62e9", (String)"TaxDetailChartFormPlugin_2", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
        HistogramChart histogramChart = (HistogramChart)this.getControl("histogramchartap");
        TaxDetailChartHelper taxDetailChartHelper = new TaxDetailChartHelper();
        Map<String, List> longList = taxDetailChartHelper.drawChart(histogramChart, taxName, clickStartDate, clickEndDate, flag, list, combofield, newQueryOrgList);
        HashMap textStyle = Maps.newHashMap();
        textStyle.put("fontSize", 16);
        textStyle.put("fontWeight", 500);
        histogramChart.setTitlePropValue("textStyle", (Object)textStyle);
        histogramChart.setTitleAlign(XAlign.left, YAlign.top);
        histogramChart.setShowTooltip(true);
        histogramChart.refresh();
        if (list == null) {
            this.loadSxName(longList, combofield);
        }
    }

    public void selectRowsChange(SelectRowsEvent evt) {
        List rows = evt.getNewRows();
        ArrayList<String> selectSxNameList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)rows)) {
            for (Integer row : rows) {
                String sxname = "1".equals(this.getPageCache().get("combofield")) ? ((DynamicObject)this.getView().getModel().getValue("org", row.intValue())).getString("id") : (String)this.getModel().getValue("sxname", row.intValue());
                selectSxNameList.add(sxname);
            }
        }
        this.refreshChart(selectSxNameList.size() > 0 ? selectSxNameList : null);
    }

    private void loadSxName(Map<String, List> orgList, String combofield) {
        List list = "1".equals(combofield) ? orgList.get("org") : orgList.get("sxname");
        this.getModel().deleteEntryData(ENTRYENTITY1);
        CardEntry cardEntry = (CardEntry)this.getControl(ENTRYENTITY1);
        int total = 0;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (Object obj : list) {
                if (total > 9) break;
                int row = this.getModel().createNewEntryRow(ENTRYENTITY1);
                if ("1".equals(combofield)) {
                    this.getModel().setValue("org", obj, row);
                    cardEntry.setChildVisible(false, row, new String[]{"sxname"});
                    cardEntry.setChildVisible(true, row, new String[]{"org"});
                } else {
                    this.getModel().setValue("sxname", obj, row);
                    cardEntry.setChildVisible(true, row, new String[]{"sxname"});
                    cardEntry.setChildVisible(false, row, new String[]{"org"});
                }
                ++total;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("daterange_startdate".equals(name) || "daterange_enddate".equals(name)) {
            Date endDate;
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Date clickStartDate = DateUtils.stringToDate((String)((String)customParams.get("clickStartDate")));
            Date clickEndDate = DateUtils.stringToDate((String)((String)customParams.get("clickEndDate")));
            Date startDate = (Date)this.getView().getModel().getValue("daterange_startdate");
            Boolean isPass = this.validateDate(startDate, endDate = (Date)this.getView().getModel().getValue("daterange_enddate"));
            if (!isPass.booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u6790\u533a\u95f4\u8d77\u4e0d\u80fd\u5927\u4e8e\u5206\u6790\u533a\u95f4\u6b62\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TaxDetailChartFormPlugin_3", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
                return;
            }
            Boolean isPass1 = this.validateDate(clickStartDate, startDate);
            if (!isPass1.booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e5\u671f\u8d85\u51fa\u5206\u6790\u533a\u95f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TaxDetailChartFormPlugin_5", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
                return;
            }
            Boolean isPass2 = this.validateDate(endDate, clickEndDate);
            if (!isPass2.booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e5\u671f\u8d85\u51fa\u5206\u6790\u533a\u95f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TaxDetailChartFormPlugin_5", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    private boolean validateDate(Date start, Date end) {
        return null == start || null == end || !start.after(end);
    }
}

