/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.reportitems;

import com.google.common.collect.Maps;
import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tctsa.common.entity.PresetData;
import kd.taxc.tctsa.common.enums.DatePeriodMappingEnum;
import kd.taxc.tctsa.common.enums.PeriodEnum;
import kd.taxc.tctsa.common.helper.OrgServiceHelper;
import kd.taxc.tctsa.common.util.BigDecimalUtil;
import kd.taxc.tctsa.common.util.DateUtils;
import kd.taxc.tctsa.common.util.StringUtil;
import kd.taxc.tctsa.common.util.TctsaUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TaxKanbanPlugin
extends AbstractFormPlugin
implements SelectRowsEventListener,
RowClickEventListener {
    private static Log logger = LogFactory.getLog(TaxKanbanPlugin.class);
    private static String CUSTOM_CONTROL = "customcontrolap";
    private static final String ENTRYENTITY = "entryentity";
    private static final String HISTOGRAMCHARTAP = "histogramchartap";
    private static final String QUERYDETAILS = "querydetails";
    private static final String ORGFIELD = "orgfield";
    private static final String TCTSA_KANBAN_DETAILS = "tctsa_kanban_details";

    public void afterCreateNewData(EventObject e) {
        this.setFillPeriod(DateUtils.getFirstDateOfMonth((Date)new Date()), DateUtils.getLastDateOfMonth2((Date)new Date()));
        this.refreshBar(null, null, true);
    }

    public void itemClick(ItemClickEvent evt) {
        if ("refresh".equals(evt.getItemKey())) {
            this.getPageCache().put("refresh", "1");
            this.setOtherDimension();
            this.setFillPeriod(DateUtils.getFirstDateOfMonth((Date)new Date()), DateUtils.getLastDateOfMonth2((Date)new Date()));
            this.getPageCache().put("refresh", "0");
            this.refreshBar(null, null, true);
        }
    }

    private void setOtherDimension() {
        this.getView().getModel().setValue("period", (Object)"1");
        this.getView().getModel().setValue("combofield", (Object)"1");
        this.getView().getModel().setValue("names", null);
        this.getView().getModel().setValue(ORGFIELD, null);
    }

    public void initialize() {
        CardEntry nszecardList = (CardEntry)this.getView().getControl(ENTRYENTITY);
        nszecardList.addSelectRowsListener((SelectRowsEventListener)this);
    }

    public void registerListener(EventObject e) {
        HistogramChart histogramChart = (HistogramChart)this.getView().getControl(HISTOGRAMCHARTAP);
        histogramChart.addClickListener((ClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"checkboxname", QUERYDETAILS});
        MulBasedataEdit org = (MulBasedataEdit)this.getView().getControl(ORGFIELD);
        org.addBeforeF7SelectListener(this::orgAddBeforeF7SelectListener);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        Boolean isPass = this.getPassStatus();
        if (!isPass.booleanValue()) {
            return;
        }
        if (QUERYDETAILS.equals(key)) {
            this.showForm("tctsa_fixed_filling_query");
        } else if (HISTOGRAMCHARTAP.equals(key)) {
            String barName = ((ChartClickEvent)evt).getName();
            if (StringUtil.isEmpty((CharSequence)barName)) {
                return;
            }
            if ("1".equals(this.getPageCache().get("notData"))) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u6761\u4ef6\u4e0b\u6682\u65e0\u7edf\u8ba1\u6570\u636e\uff0c\u4e0d\u652f\u6301\u4e0b\u94bb\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u7b5b\u9009\u6761\u4ef6\u3002", (String)"TaxKanbanPlugin_0", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
                return;
            }
            String combofield = (String)this.getView().getModel().getValue("combofield");
            if ("2".equals(combofield)) {
                barName = this.getPageCache().get(barName);
            }
            this.showDetailTable(barName, null, (Date)this.getView().getModel().getValue("skssqq"), (Date)this.getView().getModel().getValue("skssqz"), (String)this.getView().getModel().getValue("period"), combofield);
        }
    }

    private Boolean getPassStatus() {
        String period = (String)this.getView().getModel().getValue("period");
        Date startdate = (Date)this.getView().getModel().getValue("skssqq");
        Date enddate = (Date)this.getView().getModel().getValue("skssqz");
        if (startdate == null || enddate == null) {
            return false;
        }
        return this.checkIsLegitimate(period, startdate, enddate);
    }

    private void showForm(String page) {
        ArrayList orgList;
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId(page);
        listShowParameter.setCustomParam("period", this.getView().getModel().getValue("period"));
        DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)this.getModel().getValue(ORGFIELD);
        ArrayList finalOrgList = orgList = new ArrayList(16);
        dynamicObjects.stream().forEach(o -> {
            DynamicObject dynamicObject = o.getDynamicObject("fbasedataid");
            finalOrgList.add(dynamicObject.getString("id"));
        });
        listShowParameter.setCustomParam("orgid", finalOrgList);
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.getOpenStyle().setTargetKey("flexcontent");
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void customEvent(CustomEventArgs e) {
        String args = e.getEventArgs();
        String eventName = e.getEventName();
        Map argsMap = (Map)SerializationUtils.fromJsonString((String)args, Map.class);
        if ("detail".equals(eventName)) {
            Boolean isPass = this.getPassStatus();
            if (!isPass.booleanValue()) {
                return;
            }
            if ("1".equals(this.getPageCache().get("notData"))) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u6761\u4ef6\u4e0b\u6682\u65e0\u7edf\u8ba1\u6570\u636e\uff0c\u4e0d\u652f\u6301\u4e0b\u94bb\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u7b5b\u9009\u6761\u4ef6\u3002", (String)"TaxKanbanPlugin_0", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
                return;
            }
            String taxName = (String)argsMap.get("taxName");
            String taxDate = (String)argsMap.get("taxDate");
            String valueTotal = (String)argsMap.get("valueTotal");
            String status = (String)argsMap.get("status");
            if (new BigDecimal("0.00").compareTo(new BigDecimal(valueTotal)) == 0) {
                this.getView().showMessage("1".equals(status) ? ResManager.loadKDString((String)"\u5f53\u524d\u6240\u5c5e\u671f\u586b\u62a5\u91d1\u989d\u8fc7\u5c0f\uff0c\u6682\u4e0d\u652f\u6301\u67e5\u770b\u660e\u7ec6\u3002", (String)"TaxKanbanPlugin_1", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5f53\u524d\u5206\u6790\u533a\u95f4\u4e0b\u6682\u65e0\u7edf\u8ba1\u6570\u636e\u3002", (String)"TaxKanbanPlugin_2", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
                return;
            }
            this.showDetailTable(taxName, taxDate, null, null, (String)this.getView().getModel().getValue("period"), (String)this.getView().getModel().getValue("combofield"));
        }
    }

    private void showDetailTable(String taxName, String taxDate, Date fenStart, Date fenEnd, String period, String combofield) {
        Date clickStartDate = null;
        Date clickEndDate = null;
        if (taxDate != null) {
            if (taxDate.length() == 7 && !taxDate.contains("Q") && !taxDate.contains("H")) {
                clickStartDate = DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)taxDate, (String)"yyyy-MM"));
                clickEndDate = DateUtils.getLastDateOfMonth((Date)clickStartDate);
            } else if (taxDate.contains("Q")) {
                String jidu = taxDate.substring(taxDate.length() - 1, taxDate.length());
                clickStartDate = DateUtils.getDateBySeasonal((Date)DateUtils.stringToDate((String)taxDate, (String)"yyyy"), (String)jidu);
                clickEndDate = DateUtils.getLastDateOfSeason((Date)clickStartDate);
            } else if (taxDate.contains("H")) {
                String year = taxDate.substring(0, 4);
                String banNian = taxDate.substring(taxDate.length() - 1, taxDate.length());
                clickStartDate = DateUtils.stringToDate((String)year, (String)"yyyy");
                if ("1".equals(banNian)) {
                    clickStartDate = DateUtils.getFirstDateOfYear((Date)clickStartDate);
                    clickEndDate = DateUtils.getLastDateOfHalfYear((Date)clickStartDate);
                } else if ("2".equals(banNian)) {
                    clickEndDate = DateUtils.getLastDateOfYear((Date)clickStartDate);
                    clickStartDate = DateUtils.getFirstDateOfHalfYear((Date)clickEndDate);
                }
            } else if (taxDate.length() == 4) {
                String year = taxDate.substring(0, 4);
                clickStartDate = DateUtils.stringToDate((String)year, (String)"yyyy");
                clickStartDate = DateUtils.getFirstDateOfYear((Date)clickStartDate);
                clickEndDate = DateUtils.getLastDateOfYear((Date)clickStartDate);
            }
        } else {
            clickStartDate = fenStart;
            clickEndDate = fenEnd;
        }
        this.openForm(taxName, clickStartDate, clickEndDate, period, combofield);
    }

    private void openForm(String taxName, Date clickStartDate, Date clickEndDate, String flag, String combofield) {
        List orgList;
        FormShowParameter showParameter = new FormShowParameter();
        StyleCss sc = new StyleCss();
        sc.setHeight("660px");
        sc.setWidth("1200px");
        DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)this.getModel().getValue(ORGFIELD);
        ArrayList finalOrgList = orgList = new ArrayList(16);
        dynamicObjects.stream().forEach(o -> {
            DynamicObject dynamicObject = o.getDynamicObject("fbasedataid");
            finalOrgList.add(dynamicObject.getLong("id"));
        });
        if (orgList.size() == 0) {
            orgList = OrgServiceHelper.getOrgListHasPermission((IFormView)this.getView());
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("taxName", taxName);
        customParams.put("clickStartDate", clickStartDate);
        customParams.put("clickEndDate", clickEndDate);
        customParams.put("flag", flag);
        customParams.put("combofield", combofield);
        customParams.put(ORGFIELD, orgList);
        showParameter.setCustomParams(customParams);
        showParameter.getOpenStyle().setInlineStyleCss(sc);
        showParameter.setCaption(ResManager.loadKDString((String)"\u8be6\u60c5\u56fe\u8868", (String)"TaxKanbanPlugin_3", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
        showParameter.setFormId(TCTSA_KANBAN_DETAILS);
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void setFillPeriod(Date firstDateOfMonth, Date lastDateOfMonth) {
        this.getView().getModel().setValue("skssqq", (Object)firstDateOfMonth);
        this.getView().getModel().setValue("skssqz", (Object)lastDateOfMonth);
    }

    private void refreshBar(List<String> sxnameList, String key, Boolean isFirst) {
        String period = (String)this.getView().getModel().getValue("period");
        Date startdate = (Date)this.getView().getModel().getValue("skssqq");
        Date enddate = (Date)this.getView().getModel().getValue("skssqz");
        if (startdate == null || enddate == null) {
            return;
        }
        Boolean isPass = this.checkIsLegitimate(period, startdate, enddate);
        if (!isPass.booleanValue()) {
            return;
        }
        Boolean isSingeDate = this.decideIsSingeDate(period, startdate, enddate);
        String combofield = (String)this.getView().getModel().getValue("combofield");
        DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)this.getModel().getValue("names");
        ArrayList<String> nameList = new ArrayList<String>(16);
        dynamicObjectCollection.stream().forEach(o -> {
            DynamicObject dynamicObject = o.getDynamicObject("fbasedataid");
            nameList.add((String)dynamicObject.get("number"));
        });
        DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)this.getModel().getValue(ORGFIELD);
        ArrayList<Long> orgList = new ArrayList(16);
        ArrayList finalOrgList = orgList;
        dynamicObjects.stream().forEach(o -> {
            DynamicObject dynamicObject = o.getDynamicObject("fbasedataid");
            finalOrgList.add(dynamicObject.getLong("id"));
        });
        if (orgList.size() == 0) {
            orgList = OrgServiceHelper.getOrgListHasPermission((IFormView)this.getView());
        }
        this.handlerTaxShow(period, startdate, enddate, combofield, sxnameList, nameList, orgList, isSingeDate);
    }

    private Boolean checkIsLegitimate(String period, Date startdate, Date enddate) {
        Boolean isPass = this.validateDate(startdate, enddate);
        if (!isPass.booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u6790\u533a\u95f4\u8d77\u4e0d\u80fd\u5927\u4e8e\u5206\u6790\u533a\u95f4\u6b62\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TaxKanbanPlugin_4", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            return false;
        }
        int day = DateUtils.getDayOfDate((Date)startdate);
        logger.info("\u65e5\u65e5\u65e5: " + day);
        logger.info("\u65f6\u95f4: " + startdate);
        logger.info("\u65f6\u95f4\u683c\u5f0f\u5316: " + DateUtils.format((Date)startdate));
        logger.info("\u65f6\u533a: " + System.getProperty("user.timezone"));
        Date endday = DateUtils.getLastDateOfMonth((Date)enddate);
        int day1 = DateUtils.getDayOfDate((Date)enddate);
        int day2 = DateUtils.getDayOfDate((Date)endday);
        if (day != 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u6790\u533a\u95f4\u8d77\u53ea\u80fd\u4e3a\u9009\u62e9\u5f53\u524d\u6708\u7684\u6708\u521d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TaxKanbanPlugin_5", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (day1 != day2) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u6790\u533a\u95f4\u6b62\u53ea\u80fd\u4e3a\u9009\u62e9\u5f53\u524d\u6708\u7684\u6708\u672b\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TaxKanbanPlugin_6", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            return false;
        }
        List periodList = TctsaUtils.getCalDate((String)period, (Date)startdate, (Date)enddate);
        if (periodList.size() <= 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5206\u6790\u533a\u95f4\u5185\u6ca1\u6709\u5b8c\u6574\u7684\u586b\u62a5\u6240\u5c5e\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TaxKanbanPlugin_7", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private Boolean decideIsSingeDate(String period, Date startdate, Date enddate) {
        List periodList = TctsaUtils.getCalDate((String)period, (Date)startdate, (Date)enddate);
        if (periodList.size() == 1) {
            return true;
        }
        return false;
    }

    private Boolean handlerTaxShow(String period, Date startdate, Date enddate, String combofield, List<String> sxnameList, List<String> nameList, List<Long> orgList, Boolean isSingeDate) {
        ArrayList<HashMap> objList = new ArrayList<HashMap>();
        QFilter qfilter = new QFilter("fillperiod", "=", (Object)period);
        qfilter.and(new QFilter("skssqq", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)startdate)));
        qfilter.and(new QFilter("skssqz", "<=", (Object)DateUtils.getLastDateOfMonth2((Date)enddate)));
        if (nameList.size() > 0) {
            qfilter.and(new QFilter("number", "in", nameList));
        }
        if (orgList.size() <= 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5728\u5f53\u524d\u7684\u7b5b\u9009\u6761\u4ef6\u4e0b\uff0c\u7cfb\u7edf\u6682\u65e0\u7edf\u8ba1\u6570\u636e\uff0c\u8bf7\u8fd4\u56de\u754c\u9762\u91cd\u65b0\u7b5b\u9009\u3002", (String)"TaxKanbanPlugin_8", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            return false;
        }
        qfilter.and(new QFilter("org", "in", orgList));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"tctsa_fixed_filling_query", (String)"fillperiod,number,name,amount,skssqq,skssqz,org,org.id", (QFilter[])new QFilter[]{qfilter});
        if (dynamicObjects != null && dynamicObjects.length == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5728\u5f53\u524d\u7684\u7b5b\u9009\u6761\u4ef6\u4e0b\uff0c\u7cfb\u7edf\u6682\u65e0\u7edf\u8ba1\u6570\u636e\uff0c\u8bf7\u8fd4\u56de\u754c\u9762\u91cd\u65b0\u7b5b\u9009\u3002", (String)"TaxKanbanPlugin_8", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            this.getPageCache().put("notData", "1");
            return false;
        }
        this.getPageCache().put("notData", "0");
        Map<Object, Object> typeGroups = new HashMap();
        if (dynamicObjects != null) {
            if ("1".equals(combofield)) {
                for (DynamicObject dynamicObject : dynamicObjects) {
                    try {
                        String str = dynamicObject.getLocaleString("name").getLocaleValue();
                        if (StringUtils.isEmpty((CharSequence)str)) continue;
                        if (typeGroups.containsKey(str)) {
                            List oldlist = (List)typeGroups.get(str);
                            oldlist.add(dynamicObject);
                            typeGroups.put(str, oldlist);
                            continue;
                        }
                        ArrayList<DynamicObject> dynlist = new ArrayList<DynamicObject>();
                        dynlist.add(dynamicObject);
                        typeGroups.put(str, dynlist);
                    }
                    catch (Exception e) {
                        logger.info("TaxKanbanPlugin-error=" + dynamicObject);
                    }
                }
            } else {
                typeGroups = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(s -> s.getString("org.id")));
            }
        }
        logger.info("TaxKanbanPlugin.combofield={};typeGroups={}", (Object)combofield, (Object)typeGroups.size());
        ArrayList<String> sxNames = new ArrayList<String>(16);
        ArrayList<String> oldNames = new ArrayList<String>(16);
        ArrayList<BigDecimal> jeList = new ArrayList<BigDecimal>(16);
        if (null != typeGroups) {
            for (Map.Entry<Object, Object> entry : typeGroups.entrySet()) {
                objList.add(this.setDatatoCustom((List)entry.getValue(), sxnameList != null && sxnameList.contains(entry.getKey()) ? "rgba(255,169,64,1)" : "rgba(64,169,255,0.4)", (String)entry.getKey(), combofield, period, startdate, enddate));
                sxNames.add("1".equals(combofield) ? (String)entry.getKey() : (String)TctsaUtils.getInfoByOrgIdFromErp((String)((String)entry.getKey()), (String[])new String[]{"number", "name", "uniformsocialcreditcode", "frepresentative", "registeredcapital", "establishmentdate", "bankaccount", "depositbank"}).get("name"));
                oldNames.add((String)entry.getKey());
                jeList.add(this.getTotal((List)entry.getValue()));
            }
        }
        HistogramChart customchart = this.getMainChart();
        if (isSingeDate.booleanValue()) {
            customchart.clearData();
            this.getView().setVisible(Boolean.TRUE, new String[]{HISTOGRAMCHARTAP, "flexpanelap5"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"customcontrolap", "flexpanelap2"});
            if ("2".equals(combofield)) {
                int i = 0;
                for (String orgid : oldNames) {
                    this.getPageCache().put((String)sxNames.get(i), orgid);
                    ++i;
                }
            }
            this.showCustomChart(customchart, sxNames, oldNames, jeList, "#40A9FF", sxnameList, combofield);
        } else {
            customchart.clearData();
            this.getView().setVisible(Boolean.FALSE, new String[]{HISTOGRAMCHARTAP, "flexpanelap5"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"customcontrolap", "flexpanelap2"});
            CustomControl control = (CustomControl)this.getControl(CUSTOM_CONTROL);
            control.release();
            HashMap<String, ArrayList<HashMap>> map = new HashMap<String, ArrayList<HashMap>>(16);
            map.put("data", objList);
            control.setData(map);
        }
        if (sxnameList == null) {
            Label name = (Label)this.getControl("labelap1");
            name.setText("1".equals(combofield) ? ResManager.loadKDString((String)"\u4e8b\u9879\u9009\u62e9", (String)"TaxKanbanPlugin_9", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7ec4\u7ec7\u9009\u62e9", (String)"TaxKanbanPlugin_10", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            if (typeGroups != null) {
                this.loadSxName(typeGroups.keySet(), combofield);
            }
        }
        return true;
    }

    private BigDecimal getTotal(List<DynamicObject> dynamicObjects) {
        BigDecimal total = BigDecimal.ZERO;
        for (DynamicObject dynamicObject : dynamicObjects) {
            total = BigDecimalUtil.addObject((Object)total, (Object)dynamicObject.getBigDecimal("amount"));
        }
        return total.divide(new BigDecimal(10000)).setScale(2, 4);
    }

    private HistogramChart getMainChart() {
        HistogramChart barChart = (HistogramChart)this.getView().getControl(HISTOGRAMCHARTAP);
        return barChart;
    }

    private void showCustomChart(HistogramChart customchart, List<String> keys, List<String> oldNames, List<BigDecimal> values, String color, List<String> sxnameList, String combofield) {
        Axis xAxis = this.createValueAxis(customchart, "", false);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        xAxis.setPropValue("splitLine", splitLine);
        this.createCategoryAxis(customchart, "", keys, true);
        this.createHistogramSeries(customchart, ResManager.loadKDString((String)"\u91d1\u989d (\u4e07\u5143)", (String)"TaxKanbanPlugin_14", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), values.toArray(new Number[0]), color, oldNames, sxnameList);
        customchart.setMargin(Position.right, "50px");
        customchart.setLegendAlign(XAlign.right, YAlign.top);
        customchart.setLegendVertical(true);
        customchart.setLegendPropValue("padding", (Object)new Integer[]{0, 30, 0, 23});
        customchart.setMargin(Position.top, "30px");
        customchart.setName(new LocaleString(ResManager.loadKDString((String)"\u91d1\u989d (\u4e07\u5143)", (String)"TaxKanbanPlugin_14", (String)"taxc-tctsa-formplugin", (Object[])new Object[0])));
        HashMap textStyle = Maps.newHashMap();
        textStyle.put("fontSize", 12);
        textStyle.put("fontWeight", 450);
        customchart.setTitlePropValue("textStyle", (Object)textStyle);
        customchart.refresh();
    }

    private void createHistogramSeries(HistogramChart histogramChart, String name, Number[] values, String color, List<String> oldsxnameList, List<String> sxnameList) {
        BarSeries histogramSeries = histogramChart.createSeries(name);
        histogramSeries.setStack("stack");
        histogramSeries.setBarWidth("25px");
        HashMap dataLabels = Maps.newHashMap();
        dataLabels.put("format", "{point.y:.1f}");
        histogramSeries.setPropValue("dataLabels", (Object)dataLabels);
        histogramSeries.setAnimationDuration(2000);
        kd.bos.form.chart.Label label = new kd.bos.form.chart.Label();
        label.setPosition(Position.insideRight);
        label.setShow(false);
        histogramSeries.setLabel(label);
        int i = 0;
        for (String sxname : oldsxnameList) {
            if (sxnameList != null && sxnameList.contains(sxname)) {
                histogramSeries.addData("", values[i], "#FFA940");
            } else {
                histogramSeries.addData("", values[i], "#40A9FF");
            }
            ++i;
        }
    }

    private Axis createCategoryAxis(HistogramChart histogramChart, String name, List<String> demensions, boolean isX) {
        Axis axis = null;
        axis = isX ? histogramChart.createXAxis(name, AxisType.category) : histogramChart.createYAxis(name, AxisType.category);
        axis.setCategorys(demensions);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        HashMap<String, Comparable<Boolean>> axisLabel = new HashMap<String, Comparable<Boolean>>();
        axisLabel.put("show", Boolean.TRUE);
        axisLabel.put("interval", Integer.valueOf(0));
        axisLabel.put("rotate", Integer.valueOf(20));
        axis.setPropValue("axisTick", axisTick);
        axis.setPropValue("axisLabel", axisLabel);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", splitLine);
        histogramChart.setShowTooltip(true);
        return axis;
    }

    private Axis createValueAxis(HistogramChart histogramChart, String name, boolean isX) {
        Axis axis = null;
        axis = isX ? histogramChart.createXAxis(name, AxisType.value) : histogramChart.createYAxis(name, AxisType.value);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        return axis;
    }

    private void loadSxName(Set<String> nameSet, String combofield) {
        this.getModel().deleteEntryData(ENTRYENTITY);
        CardEntry cardEntry = (CardEntry)this.getControl(ENTRYENTITY);
        if (CollectionUtils.isNotEmpty(nameSet)) {
            for (String name : nameSet) {
                int row = this.getModel().createNewEntryRow(ENTRYENTITY);
                if ("1".equals(combofield)) {
                    this.getModel().setValue("sxname", (Object)name, row);
                    cardEntry.setChildVisible(true, row, new String[]{"sxname"});
                    cardEntry.setChildVisible(false, row, new String[]{"orgid"});
                    continue;
                }
                this.getModel().setValue("orgid", (Object)name, row);
                cardEntry.setChildVisible(false, row, new String[]{"sxname"});
                cardEntry.setChildVisible(true, row, new String[]{"orgid"});
            }
        }
    }

    private HashMap setDatatoCustom(List<DynamicObject> sxDynamicObjects, String color, String sxname, String combofield, String period, Date startdate, Date enddate) {
        HashMap<String, Object> sbData = new HashMap<String, Object>();
        HashMap<String, String> colorData = new HashMap<String, String>();
        colorData.put("color", color);
        ArrayList<String> skssqqList = new ArrayList<String>(16);
        BigDecimal totalAmount = BigDecimal.ZERO;
        ArrayList<BigDecimal> bigDecimalList = new ArrayList<BigDecimal>(16);
        Map<String, List<DynamicObject>> groups = sxDynamicObjects.stream().collect(Collectors.groupingBy(s -> s.getString("skssqq")));
        ArrayList<String> list = new ArrayList<String>(16);
        Iterator<String> it = groups.keySet().iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        for (String skssqq : list) {
            skssqqList.add(skssqq.substring(0, 4) + ("4".equals(period) ? "" : DatePeriodMappingEnum.getShowYueByYue((String)period, (String)skssqq.substring(5, 7))));
            totalAmount = groups.get(skssqq).stream().map(s -> s.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            bigDecimalList.add(totalAmount.divide(new BigDecimal(10000)).setScale(2, 4));
            totalAmount = BigDecimal.ZERO;
        }
        ArrayList<PresetData> oldpresetDataSqList = new ArrayList<PresetData>(16);
        ArrayList<String> newSqList = new ArrayList<String>(16);
        ArrayList<BigDecimal> presetDecimalList = new ArrayList<BigDecimal>(16);
        ArrayList<String> statusList = new ArrayList<String>(16);
        BigDecimal morenValue = new BigDecimal("0.00");
        List list1 = TctsaUtils.getCalDate((String)period, (Date)startdate, (Date)enddate);
        logger.info("TaxKanbanPlugin.startdate={};enddate={};period={}", new Object[]{startdate, enddate, period});
        for (Iterator map : list1) {
            oldpresetDataSqList.add(new PresetData(period, (DateUtils.formatMonth((Date)((Date)map.get("startdate"))) + "").substring(0, 4) + ("4".equals(period) ? "" : DatePeriodMappingEnum.getShowYueByYue((String)period, (String)(DateUtils.formatMonth((Date)((Date)map.get("startdate"))) + "").substring(5, 7)) + ""), morenValue, "0"));
        }
        int j = 0;
        for (String skssqq : skssqqList) {
            for (PresetData presetDataSq : oldpresetDataSqList) {
                if (!presetDataSq.getRangeSq().equals(skssqq)) continue;
                presetDataSq.setAmount((BigDecimal)bigDecimalList.get(j));
                if (((BigDecimal)bigDecimalList.get(j)).compareTo(new BigDecimal("0.01")) >= 0) continue;
                presetDataSq.setIsExist("1");
            }
            ++j;
        }
        for (PresetData oldpresetData : oldpresetDataSqList) {
            newSqList.add(oldpresetData.getRangeSq());
            presetDecimalList.add(oldpresetData.getAmount());
            statusList.add(oldpresetData.getIsExist());
        }
        String orgid = null;
        if ("2".equals(combofield)) {
            orgid = sxname;
            Map map = TctsaUtils.getInfoByOrgIdFromErp((String)sxname, (String[])new String[]{"number", "name", "uniformsocialcreditcode", "frepresentative", "registeredcapital", "establishmentdate", "bankaccount", "depositbank"});
            sxname = (String)map.get("name");
        }
        sbData.put("name", sxname);
        sbData.put("nameId", "1".equals(combofield) ? sxname : orgid);
        sbData.put("nameX", PeriodEnum.getShowNameByPeriod((String)period));
        sbData.put("nameY", ResManager.loadKDString((String)"\u91d1\u989d (\u4e07\u5143)", (String)"TaxKanbanPlugin_14", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
        sbData.put("type", "line");
        sbData.put("xAxis", newSqList);
        sbData.put("data", presetDecimalList);
        sbData.put("status", statusList);
        sbData.put("itemStyle", colorData);
        return sbData;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (this.getPageCache().get("refresh") != null && "1".equals(this.getPageCache().get("refresh"))) {
            return;
        }
        if (this.getView().getModel().getValue("skssqq") == null || this.getView().getModel().getValue("skssqz") == null) {
            return;
        }
        String name = e.getProperty().getName();
        if ("1".equals(this.getView().getModel().getValue("period")) && ("skssqq".equals(name) || "skssqz".equals(name) || "period".equals(name))) {
            Date twoYearLater;
            boolean result;
            Date startDate = (Date)this.getView().getModel().getValue("skssqq");
            Date endDate = (Date)this.getView().getModel().getValue("skssqz");
            if (null != startDate && !(result = this.validateDate(endDate, twoYearLater = DateUtils.addYear((Date)startDate, (int)2)))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5468\u671f\u53ea\u652f\u6301\u67e5\u8be2\u4e24\u5e74\u5185\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TaxKanbanPlugin_15", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        if ("period".equals(name) || "skssqq".equals(name) || "skssqz".equals(name) || "combofield".equals(name) || ORGFIELD.equals(name) || "names".equals(name)) {
            this.refreshBar(null, null, true);
        }
    }

    public void selectRowsChange(SelectRowsEvent evt) {
        Boolean isPass = this.getPassStatus();
        if (!isPass.booleanValue()) {
            return;
        }
        List rows = evt.getNewRows();
        ArrayList<String> selectSxNameList = new ArrayList<String>();
        String combofield = (String)this.getView().getModel().getValue("combofield");
        if (CollectionUtils.isNotEmpty((Collection)rows)) {
            for (Integer row : rows) {
                String sxname = "1".equals(combofield) ? (String)this.getModel().getValue("sxname", row.intValue()) : ((DynamicObject)this.getView().getModel().getValue("orgid", row.intValue())).getString("id");
                selectSxNameList.add(sxname);
            }
        }
        this.refreshBar(selectSxNameList.size() > 0 ? selectSxNameList : null, null, true);
    }

    private boolean validateDate(Date start, Date end) {
        return null == start || null == end || !start.after(end);
    }

    public void orgAddBeforeF7SelectListener(BeforeF7SelectEvent event) {
        ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
        List orgIds = OrgServiceHelper.getOrgListHasPermissionAll();
        QFilter orgIdsFilter = new QFilter("id", "in", (Object)orgIds);
        formShowParameter.getListFilterParameter().getQFilters().add(orgIdsFilter);
    }
}

