/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.reportitems;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.list.column.DynamicTextColumnDesc;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tctsa.common.showpage.PageShowCommon;
import kd.taxc.tctsa.common.util.PermissionUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class TempReportItemListPlugin
extends AbstractListPlugin {
    private static final String TCTSA_REPORT_DTASK_BILL = "tctsa_report_dtask_bill";
    private static final String TCTSA_TEMP_REPORT_ITEM = "tctsa_temp_report_item";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List labelIdList;
        super.filterContainerInit(args);
        CommonFilterColumn commonFilterColumn = new CommonFilterColumn("labelid.number");
        commonFilterColumn.setMulti(true);
        args.addFilterColumn((FilterColumn)commonFilterColumn);
        commonFilterColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6807\u7b7e", (String)"TempReportItemListPlugin_0", (String)"taxc-tctsa-formplugin", (Object[])new Object[0])));
        if (!ObjectUtils.isEmpty((Object)this.getPageCache().get("labelId")) && CollectionUtils.isNotEmpty((Collection)(labelIdList = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("labelId"), String.class))) && null != labelIdList.get(0) && ((String)labelIdList.get(0)).trim().length() > 0) {
            commonFilterColumn.setDefaultValues(new Object[]{labelIdList});
        }
    }

    public void packageData(PackageDataEvent event) {
        Object source = event.getSource();
        if (source instanceof DynamicTextColumnDesc) {
            String key = ((DynamicTextColumnDesc)source).getKey();
            if ("label".equals(key)) {
                this.packageLabel(event);
            }
        } else if (this.isNullEnd(event)) {
            event.setFormatValue((Object)"\u2014");
        }
    }

    private boolean isNullEnd(PackageDataEvent event) {
        Object source = event.getSource();
        return source instanceof ColumnDesc && "end".equals(((ColumnDesc)source).getKey()) && null == ((Object[])event.getFormatValue())[0];
    }

    private void packageLabel(PackageDataEvent e) {
        DynamicObject rowData = e.getRowData();
        Object primaryKeyValue = rowData.get("id");
        QFilter qFilter = new QFilter("id", "=", primaryKeyValue);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)TCTSA_TEMP_REPORT_ITEM, (String)"labelentity.labelid", (QFilter[])new QFilter[]{qFilter});
        ArrayList<String> list = new ArrayList<String>();
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            Object id = dynamicObject.get("labelentity.labelid");
            QFilter q = new QFilter("id", "=", id);
            DynamicObject object = QueryServiceHelper.queryOne((String)"t_tctb_label_info", (String)"name", (QFilter[])new QFilter[]{q});
            if (object == null) continue;
            String name = object.getString("name");
            list.add(name);
        }
        e.setFormatValue((Object)String.join((CharSequence)",", list));
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        boolean hasSpecificPerm = PermissionUtils.hasSpecificPerm((IFormView)this.getView(), (String)"4715a0df000000ac");
        if (!hasSpecificPerm) {
            HyperLinkClickEvent hyperEvt = args.getHyperLinkClickEvent();
            BillList list = (BillList)hyperEvt.getSource();
            ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
            PageShowCommon.showBill((ShowType)ShowType.MainNewTabPage, (String)TCTSA_TEMP_REPORT_ITEM, (Object)currentSelectedRowInfo.getPrimaryKeyValue(), (IFormView)this.getView(), null, (BillOperationStatus)BillOperationStatus.VIEW);
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            BillList billlist = (BillList)this.getControl("billlistap");
            if (billlist == null) {
                return;
            }
            ListSelectedRowCollection selectedRowCollection = billlist.getSelectedRows();
            if (selectedRowCollection == null || selectedRowCollection.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"TempReportItemListPlugin_4", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
                return;
            }
            if ("donothingtbdel".equals(args.getOperateKey())) {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("delete", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684\u4efb\u52a1\u540e\u5c06\u65e0\u6cd5\u6062\u590d\u786e\u5b9a\u8981\u5220\u9664\u8be5\u4efb\u52a1\u5417\uff1f", (String)"TempReportItemListPlugin_6", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBackListener);
            } else if ("donothingtbldisable".equals(args.getOperateKey())) {
                List pks = selectedRowCollection.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
                Boolean istotalPass = true;
                Boolean isTotalHasdisable = false;
                HashSet<String> billnoSet = new HashSet<String>(16);
                for (Object pkId : pks) {
                    DynamicObject[] dynamicObjectCollection;
                    QFilter qFilter = new QFilter("sbbid", "=", pkId);
                    ArrayList<DynamicObject> summaryGroupDataList = new ArrayList<DynamicObject>(16);
                    ArrayList<DynamicObject> itemGroupDataList = new ArrayList<DynamicObject>(16);
                    Boolean isPass = true;
                    Boolean isHasdisable = false;
                    for (DynamicObject dynamicObject : dynamicObjectCollection = BusinessDataServiceHelper.load((String)TCTSA_REPORT_DTASK_BILL, (String)"billno,combofield,submitstatus,billstatus", (QFilter[])new QFilter[]{qFilter})) {
                        if (dynamicObject != null && "1".equals(dynamicObject.get("submitstatus"))) {
                            billnoSet.add(dynamicObject.getString("billno"));
                            isPass = false;
                            break;
                        }
                        if (dynamicObject == null) continue;
                        if ("0".equals(dynamicObject.get("billstatus"))) {
                            isHasdisable = true;
                            continue;
                        }
                        dynamicObject.set("billstatus", (Object)"0");
                        summaryGroupDataList.add(dynamicObject);
                    }
                    if (isPass.booleanValue()) {
                        DynamicObject recordObj;
                        if (isHasdisable.booleanValue()) {
                            isTotalHasdisable = true;
                        }
                        if ((recordObj = BusinessDataServiceHelper.loadSingle(pkId, (String)TCTSA_TEMP_REPORT_ITEM)) != null) {
                            recordObj.set("billstatus", (Object)"0");
                            itemGroupDataList.add(recordObj);
                        }
                        SaveServiceHelper.update((DynamicObject[])summaryGroupDataList.toArray(new DynamicObject[0]));
                        SaveServiceHelper.save((DynamicObject[])itemGroupDataList.toArray(new DynamicObject[0]));
                        continue;
                    }
                    istotalPass = false;
                }
                billlist.refreshData();
                if (istotalPass.booleanValue()) {
                    if (isTotalHasdisable.booleanValue()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e3a\u7981\u7528\u72b6\u6001\u3002", (String)"TempReportItemListPlugin_12", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
                    } else {
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"TempReportItemListPlugin_3", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
                    }
                } else {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\u3010%s\u3011\u5b58\u5728\u5df2\u63d0\u4ea4\u7684\u4e34\u65f6\u586b\u62a5\u4efb\u52a1\uff0c\u4e0d\u80fd\u7981\u7528\u3002", (String)"TempReportItemListPlugin_9", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", billnoSet)));
                }
            } else if ("donothingtblenable".equals(args.getOperateKey())) {
                List pks = selectedRowCollection.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
                HashSet<String> billnoSet = new HashSet<String>(16);
                Boolean istotalPass = true;
                for (Object pkId : pks) {
                    DynamicObject[] dynamicObjectCollection;
                    QFilter qFilter = new QFilter("sbbid", "=", pkId);
                    Boolean isPass = true;
                    ArrayList<DynamicObject> summaryGroupDataList = new ArrayList<DynamicObject>(16);
                    ArrayList<DynamicObject> itemGroupDataList = new ArrayList<DynamicObject>(16);
                    for (DynamicObject dynamicObject : dynamicObjectCollection = BusinessDataServiceHelper.load((String)TCTSA_REPORT_DTASK_BILL, (String)"combofield,submitstatus,billstatus,billno", (QFilter[])new QFilter[]{qFilter})) {
                        if (dynamicObject != null && "1".equals(dynamicObject.get("billstatus"))) {
                            billnoSet.add(dynamicObject.getString("billno"));
                            isPass = false;
                            break;
                        }
                        if (dynamicObject == null) continue;
                        dynamicObject.set("billstatus", (Object)"1");
                        summaryGroupDataList.add(dynamicObject);
                    }
                    if (isPass.booleanValue()) {
                        DynamicObject recordObj = BusinessDataServiceHelper.loadSingle(pkId, (String)TCTSA_TEMP_REPORT_ITEM);
                        if (recordObj != null) {
                            recordObj.set("billstatus", (Object)"1");
                            itemGroupDataList.add(recordObj);
                        }
                        SaveServiceHelper.update((DynamicObject[])summaryGroupDataList.toArray(new DynamicObject[0]));
                        SaveServiceHelper.save((DynamicObject[])itemGroupDataList.toArray(new DynamicObject[0]));
                        continue;
                    }
                    istotalPass = false;
                }
                billlist.refreshData();
                if (istotalPass.booleanValue()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"TempReportItemListPlugin_5", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\u3010%s\u3011\u6570\u636e\u5df2\u4e3a\u53ef\u7528\u72b6\u6001\uff0c\u4e0d\u80fd\u542f\u7528\u3002", (String)"TempReportItemListPlugin_10", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", billnoSet)));
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((String)"delete", (String)messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.deleteData();
            BillList billlist = (BillList)this.getControl("billlistap");
            billlist.clearSelection();
            billlist.refreshData();
        }
    }

    private void deleteData() {
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRowCollection = billlist.getSelectedRows();
        List pks = selectedRowCollection.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        ArrayList<Long> ids = new ArrayList<Long>(16);
        for (Object pkId : pks) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle(pkId, (String)TCTSA_TEMP_REPORT_ITEM);
            if (dynamicObject != null && "1".equals(dynamicObject.get("billstatus"))) continue;
            ids.add((Long)pkId);
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)TCTSA_REPORT_DTASK_BILL, (String)"id", (QFilter[])new QFilter[]{new QFilter("sbbid", "in", ids)});
        Set<Long> groups = dynamicObjects.stream().collect(Collectors.groupingBy(s -> s.getLong("id"))).keySet();
        DeleteServiceHelper.delete((String)TCTSA_TEMP_REPORT_ITEM, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        DeleteServiceHelper.delete((String)TCTSA_REPORT_DTASK_BILL, (QFilter[])new QFilter[]{new QFilter("id", "in", groups)});
        if (pks.size() == ids.size() && ids.size() != 0) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"TempReportItemListPlugin_8", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u6709\u7981\u7528\u7684\u53ef\u4ee5\u5220\u9664\u3002", (String)"TempReportItemListPlugin_7", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
        }
    }
}

