/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.reportitems;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.operate.Save;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tctsa.common.helper.OrgServiceHelper;
import kd.taxc.tctsa.common.util.DateUtils;
import kd.taxc.tctsa.common.util.OrgUtils;
import kd.taxc.tctsa.common.util.StringUtil;

public class TempReportItemPlugin
extends AbstractFormPlugin {
    private static final String RISK_ASSIGN_ORG = "tctrc_risk_assign_org";
    private static final String LABEL_ADDLABEL = "label_addlabel";
    private static final String TCTSA_REPORT_DTASK_BILL = "tctsa_report_dtask_bill";
    private static final String ORGENTITY = "orgentity";
    private static final String TEMPITEMS = "tempitems";
    private static final String ENTRYENTITY1 = "entryentity1";
    private static final String LABELENTITY = "labelentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{LABEL_ADDLABEL, "flex_addorg", "vector_addorg", "label_addorg", "flex_vieworg", "vector_vieworg", "label_vieworg", "vectorap3"});
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("start", (Object)DateUtils.getFirstDateOfYear((Date)new Date()));
    }

    public void click(EventObject evt) {
        boolean isViewOrg;
        Object source = evt.getSource();
        if (source instanceof Control && LABEL_ADDLABEL.equalsIgnoreCase(((Control)evt.getSource()).getKey())) {
            this.showLabelSelect();
        }
        boolean isAddOrg = source instanceof Vector && "vector_addorg".equals(((Vector)source).getKey()) || source instanceof Container && "flex_addorg".equals(((Container)source).getKey()) || source instanceof Label && "label_addorg".equals(((Label)source).getKey());
        boolean bl = isViewOrg = source instanceof Vector && "vector_vieworg".equals(((Vector)source).getKey()) || source instanceof Container && "flex_vieworg".equals(((Container)source).getKey()) || source instanceof Label && "label_vieworg".equals(((Label)source).getKey());
        if (isAddOrg || isViewOrg) {
            this.showOrgTreeList(isAddOrg);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        if (e.getEntryProp().getName().equals(ORGENTITY)) {
            int[] selectRowIndexs;
            for (int selectRowIndex : selectRowIndexs = e.getRowIndexs()) {
                DynamicObject[] selectRow = this.getModel().getEntryEntity(ORGENTITY, selectRowIndex, selectRowIndex + 1);
                String id = selectRow[0].getString("orgid.id");
                String billno = (String)this.getModel().getValue("billno");
                if (!StringUtil.isNotEmpty((CharSequence)id)) continue;
                QFilter filter = new QFilter("orgfield", "=", (Object)Long.parseLong(id));
                filter.and(new QFilter("billno", "=", (Object)billno));
                DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)TCTSA_REPORT_DTASK_BILL, (String)"submitstatus", (QFilter[])new QFilter[]{filter});
                for (DynamicObject dynamicObject : dynamicObjectCollection) {
                    if (!"1".equals(dynamicObject.get("submitstatus"))) continue;
                    e.setCancel(true);
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u79fb\u9664\u5931\u8d25\uff1a\u8be5\u7ec4\u7ec7\u5df2\u63d0\u4ea4\u4e86\u4e34\u65f6\u586b\u62a5\u4efb\u52a1\u3002", (String)"TempReportItemPlugin_7", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), new Object[0]));
                }
            }
        }
    }

    private void showLabelSelect() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("tctb_label_window");
        showParameter.setBillFormId("tctb_label_group");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setMultiSelect(true);
        showParameter.setShowTitle(false);
        showParameter.setLookUp(true);
        showParameter.getListFilterParameter().setFilter(new QFilter("enable", "=", (Object)"1"));
        DynamicObjectCollection labelentity = this.getModel().getEntryEntity(LABELENTITY);
        ListSelectedRowCollection listSelectedRowCollection = new ListSelectedRowCollection();
        for (DynamicObject entity : labelentity) {
            ListSelectedRow row = new ListSelectedRow();
            DynamicObject org = entity.getDynamicObject("labelid");
            if (null == org) continue;
            row.setName(org.getString("name"));
            row.setNumber(org.getString("number"));
            row.setPrimaryKeyValue(org.get("id"));
            listSelectedRowCollection.add((Object)row);
        }
        StyleCss sc = new StyleCss();
        sc.setHeight("610px");
        sc.setWidth("960px");
        showParameter.getOpenStyle().setInlineStyleCss(sc);
        showParameter.setListSelectedRowCollection(listSelectedRowCollection);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "tctb_label_window");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        block8: {
            ListSelectedRowCollection labels;
            block7: {
                Object returnData = evt.getReturnData();
                if (!"selectorg".equals(evt.getActionId())) break block7;
                ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)returnData;
                if (listSelectedRows == null) break block8;
                ArrayList<String> orgList = new ArrayList<String>();
                for (ListSelectedRow listSelectedRow : listSelectedRows) {
                    orgList.add(String.valueOf(listSelectedRow.getPrimaryKeyValue()));
                }
                List orgs = OrgUtils.getOrgIdByStructurePkids(orgList);
                DynamicObjectCollection orgCollection = this.getModel().getEntryEntity(ORGENTITY);
                List orgnowList = orgCollection.stream().map(a -> a.getString("orgid.id")).collect(Collectors.toList());
                ArrayList resultDelete = new ArrayList();
                ArrayList<String> notdeleteList = new ArrayList<String>();
                resultDelete.addAll(orgnowList);
                resultDelete.removeAll(orgs);
                String billno = (String)this.getModel().getValue("billno");
                for (String org : resultDelete) {
                    QFilter filter = new QFilter("orgfield", "=", (Object)Long.parseLong(org));
                    filter.and(new QFilter("billno", "=", (Object)billno));
                    DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)TCTSA_REPORT_DTASK_BILL, (String)"submitstatus,orgfield.name as name", (QFilter[])new QFilter[]{filter});
                    for (DynamicObject dynamicObject : dynamicObjectCollection) {
                        if (!"1".equals(dynamicObject.get("submitstatus"))) continue;
                        notdeleteList.add(dynamicObject.getString("name"));
                    }
                }
                if (notdeleteList.size() > 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u79fb\u9664\u5931\u8d25\uff1a\u3010%s\u3011\u5df2\u63d0\u4ea4\u4e86\u4e34\u65f6\u586b\u62a5\u4efb\u52a1\u3002", (String)"TempReportItemPlugin_6", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", notdeleteList)));
                }
                this.getModel().deleteEntryData(ORGENTITY);
                for (String org : orgs) {
                    int index = this.getModel().createNewEntryRow(ORGENTITY);
                    this.getModel().setValue("orgid", (Object)org, index);
                }
                break block8;
            }
            if ("tctb_label_window".equals(evt.getActionId()) && (labels = (ListSelectedRowCollection)evt.getReturnData()) != null) {
                this.getModel().deleteEntryData(LABELENTITY);
                for (ListSelectedRow selectedRow : labels) {
                    int index = this.getModel().createNewEntryRow(LABELENTITY);
                    this.getModel().setValue("labelid", selectedRow.getPrimaryKeyValue(), index);
                }
            }
        }
    }

    public void showOrgTreeList(boolean isAddOrg) {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)RISK_ASSIGN_ORG, (boolean)true, (int)2);
        parameter.setFormId(RISK_ASSIGN_ORG);
        parameter.setParentPageId(this.getView().getPageId());
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss sc = new StyleCss();
        sc.setHeight("80%");
        sc.setWidth("80%");
        parameter.getOpenStyle().setInlineStyleCss(sc);
        DynamicObjectCollection orgEntity = this.getModel().getEntryEntity(ORGENTITY);
        ListSelectedRowCollection listSelectedRowCollection = new ListSelectedRowCollection();
        ArrayList<Long> selectedOrgs = new ArrayList<Long>();
        if (null != orgEntity && orgEntity.size() != 0) {
            List<String> orgList = new ArrayList();
            for (DynamicObject dynamicObject : orgEntity) {
                orgList.add(dynamicObject.getDynamicObject("orgid").getString("id"));
            }
            orgList = OrgUtils.getStructurePkidsByOrgId(orgList);
            for (String orgid : orgList) {
                ListSelectedRow row = new ListSelectedRow();
                row.setPrimaryKeyValue((Object)orgid);
                listSelectedRowCollection.add((Object)row);
                selectedOrgs.add(Long.parseLong(orgid));
            }
        }
        parameter.setListSelectedRowCollection(listSelectedRowCollection);
        List filters = parameter.getListFilterParameter().getQFilters();
        if (isAddOrg) {
            parameter.setCustomParam("title", (Object)ResManager.loadKDString((String)"\u9009\u62e9\u7ec4\u7ec7", (String)"TempReportItemPlugin_1", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            List list = OrgServiceHelper.queryMainOrgListByCondition();
            filters.add(new QFilter("org.id", "in", (Object)list));
        } else {
            parameter.setCustomParam("title", (Object)ResManager.loadKDString((String)"\u5df2\u9009\u7ec4\u7ec7", (String)"TempReportItemPlugin_2", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            filters.add(new QFilter("id", "in", selectedOrgs));
            parameter.setStatus(OperationStatus.VIEW);
        }
        filters.add(new QFilter("enable", "=", (Object)"1"));
        filters.add(OrgUtils.getDefaultTaxOrgStructureViewQfilter());
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectorg"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            String errMsg;
            if (null != this.getModel().getValue("end")) {
                Date start = (Date)this.getModel().getValue("start");
                Date end = (Date)this.getModel().getValue("end");
                if (end.before(start)) {
                    args.setCancel(true);
                    String errMsg2 = ResManager.loadKDString((String)"\u586b\u62a5\u65f6\u95f4\u6b62\u4e0d\u80fd\u5c0f\u4e8e\u586b\u62a5\u65f6\u95f4\u8d77\u3002", (String)"TempReportItemPlugin_3", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(errMsg2);
                    return;
                }
            }
            if (0 == this.getModel().getEntryRowCount(ORGENTITY)) {
                args.setCancel(true);
                errMsg = ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u7ec4\u7ec7\u88ab\u5171\u4eab\u8303\u56f4\u3002", (String)"TempReportItemPlugin_4", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(errMsg);
                return;
            }
            if (0 == this.getModel().getEntryRowCount(TEMPITEMS)) {
                args.setCancel(true);
                errMsg = ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u586b\u62a5\u4e8b\u9879\u3002", (String)"TempReportItemPlugin_5", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(errMsg);
                return;
            }
        }
        this.getModel().setValue("count", (Object)this.getModel().getEntryRowCount(TEMPITEMS));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getOperateKey().equals("save2") && args.getOperationResult().isSuccess()) {
            ArrayList<DynamicObject> summaryGroupDataList = new ArrayList<DynamicObject>();
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)TCTSA_REPORT_DTASK_BILL);
            DynamicObjectCollection labelsCollection = this.getModel().getEntryEntity(LABELENTITY);
            DynamicObjectCollection tempitemsCollection = this.getModel().getEntryEntity(TEMPITEMS);
            DynamicObjectCollection orgsCollection = this.getModel().getEntryEntity(ORGENTITY);
            HashSet<Long> orgids = new HashSet<Long>();
            for (DynamicObject orgs : orgsCollection) {
                orgids.add(((DynamicObject)orgs.get("orgid")).getLong("id"));
            }
            QFilter qFilter = new QFilter("sbbid", "=", this.getModel().getValue("id"));
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)TCTSA_REPORT_DTASK_BILL, (String)"id,sbbid,orgfield,billno,modifydate,modifier", (QFilter[])new QFilter[]{qFilter});
            if (dynamicObjects.size() > 0) {
                Set<Long> orgfields = dynamicObjects.stream().collect(Collectors.groupingBy(s -> s.getLong("orgfield"))).keySet();
                HashSet<Long> resultDelete = new HashSet<Long>();
                HashSet<Long> resultAdd = new HashSet<Long>();
                resultDelete.addAll(orgfields);
                resultDelete.removeAll(orgids);
                resultAdd.addAll(orgids);
                resultAdd.removeAll(orgfields);
                for (Long deleteL : resultDelete) {
                    List<DynamicObject> dynamicList = dynamicObjects.stream().collect(Collectors.groupingBy(s -> s.getLong("orgfield"))).get(deleteL);
                    Set ids = dynamicList.stream().map(s -> s.getLong("id")).collect(Collectors.toSet());
                    DeleteServiceHelper.delete((String)TCTSA_REPORT_DTASK_BILL, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                }
                this.saveSummaryGroupData(summaryGroupDataList, entityType, tempitemsCollection, labelsCollection, resultAdd);
            } else {
                this.saveSummaryGroupData(summaryGroupDataList, entityType, tempitemsCollection, labelsCollection, orgids);
            }
            this.getView().close();
        }
    }

    private void saveSummaryGroupData(List<DynamicObject> summaryGroupDataList, MainEntityType entityType, DynamicObjectCollection tempitemsCollection, DynamicObjectCollection labelsCollection, Set<Long> orgids) {
        for (Long orgid : orgids) {
            DynamicObject summary = new DynamicObject((DynamicObjectType)entityType);
            summary.set("sbbid", this.getModel().getValue("id"));
            summary.set("orgfield", (Object)orgid);
            summary.set("billno", this.getModel().getValue("billno"));
            summary.set("name", this.getModel().getValue("name"));
            summary.set("start", this.getModel().getValue("start"));
            summary.set("end", this.getModel().getValue("end"));
            summary.set("des", this.getModel().getValue("des"));
            summary.set("combofield", (Object)"0");
            summary.set("submitstatus", (Object)"0");
            summary.set("billstatus", (Object)"1");
            summary.set("modifydate", (Object)new Date());
            summary.set("modifier", (Object)RequestContext.get().getUserId());
            DynamicObjectCollection reportCollection = summary.getDynamicObjectCollection("entryentity");
            for (DynamicObject tempitems : tempitemsCollection) {
                DynamicObject dynamic = reportCollection.addNew();
                dynamic.set("entryname", tempitems.get("entryname"));
                dynamic.set("taxtype", tempitems.get("taxtype"));
                dynamic.set("note", tempitems.get("note"));
            }
            DynamicObjectCollection labelCollection = summary.getDynamicObjectCollection(ENTRYENTITY1);
            for (DynamicObject labelDynamicObject : labelsCollection) {
                DynamicObject dynamic = labelCollection.addNew();
                dynamic.set("labelid", labelDynamicObject.get("labelid"));
            }
            summaryGroupDataList.add(summary);
        }
        SaveServiceHelper.save((DynamicObject[])summaryGroupDataList.toArray(new DynamicObject[0]));
    }
}

