/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.reportitems;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang.StringUtils;

public class TempReportQueryItemListPlugin
extends AbstractListPlugin {
    private static final String TCTSA_REPORT_DTASK_BILL = "tctsa_report_dtask_bill";
    public static final String TCTSA_STAY_REPORT_DTASK = "tctsa_stay_report_dtask";

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        qFilters.add(new QFilter("billstatus", "=", (Object)"1"));
        qFilters.add(new QFilter("submitstatus", "=", (Object)"1"));
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        if ("billno".equals(args.getHyperLinkClickEvent().getFieldName())) {
            this.openBill(currentSelectedRowInfo.getPrimaryKeyValue(), TCTSA_STAY_REPORT_DTASK);
        }
    }

    private void openBill(Object pkValue, String entity) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(entity);
        parameter.setPageId(this.getView().getPageId() + entity + pkValue);
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        customParams.put("numberid", pkValue);
        customParams.put("isstay", "1");
        parameter.setCustomParams(customParams);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(parameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        BillList billlist;
        if (args.getOperationResult() != null && "donothing".equals(args.getOperateKey()) && args.getOperationResult().isSuccess() && (billlist = (BillList)this.getControl("billlistap")) != null) {
            ListSelectedRowCollection selectedRowCollection = billlist.getSelectedRows();
            if (selectedRowCollection != null && selectedRowCollection.size() > 0) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("refill", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u91cd\u65b0\u586b\u62a5\u5c06\u8986\u76d6\u5386\u53f2\u6570\u636e\uff0c \u786e\u5b9a\u9700\u8981\u91cd\u65b0\u586b\u62a5\uff1f", (String)"TempReportQueryItemListPlugin_0", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"TempReportQueryItemListPlugin_1", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((String)"refill", (String)messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            BillList billlist = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRowCollection = billlist.getSelectedRows();
            List pks = selectedRowCollection.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            ArrayList<DynamicObject> summaryGroupDataList = new ArrayList<DynamicObject>(16);
            for (Object pkId : pks) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle(pkId, (String)TCTSA_REPORT_DTASK_BILL);
                dynamicObject.set("submitstatus", (Object)"2");
                dynamicObject.set("combofield", (Object)"2");
                summaryGroupDataList.add(dynamicObject);
            }
            SaveServiceHelper.save((DynamicObject[])summaryGroupDataList.toArray(new DynamicObject[0]));
            billlist.refresh();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u65b0\u586b\u62a5\u6210\u529f\u3002", (String)"TempReportQueryItemListPlugin_2", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
        }
    }
}

