/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.singleorg;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.taxc.tctsa.business.singleorg.SingleOrgTrendOrTBHelper;
import kd.taxc.tctsa.common.enums.TctsaSysTaxTypeEnum;
import kd.taxc.tctsa.common.util.DateUtils;
import kd.taxc.tctsa.common.util.EmptyCheckUtils;
import kd.taxc.tctsa.common.util.StringUtil;

public class SingleOrgTrendOrTBPlugin
extends AbstractFormPlugin {
    private static final String TREND = "tctsa_single_trend";
    private static final String POINTLINECHARTAP = "pointlinechartap";
    private static final String HISTOGRAMCHARTAP = "histogramchartap";
    private static final String QUERYDETAILS = "querydetails";

    public void registerListener(EventObject e) {
        if (TREND.equalsIgnoreCase(this.getView().getEntityId())) {
            PointLineChart pointLineChart = (PointLineChart)this.getView().getControl(POINTLINECHARTAP);
            pointLineChart.addClickListener((ClickListener)this);
        } else {
            HistogramChart histogramChart = (HistogramChart)this.getView().getControl(HISTOGRAMCHARTAP);
            histogramChart.addClickListener((ClickListener)this);
        }
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{QUERYDETAILS});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String jumpValue = (String)customParams.get("jump");
        String mainjump = (String)customParams.get("mainjump");
        Date startdate = null;
        Date enddate = null;
        List finalTypeList = null;
        List orgids = null;
        Boolean jumpFlag = false;
        if (!"1".equals(jumpValue)) {
            startdate = SingleOrgTrendOrTBHelper.getStartDate((IFormView)this.getView());
            enddate = SingleOrgTrendOrTBHelper.getEndDate((IFormView)this.getView());
            finalTypeList = this.getFinalTypeList();
            orgids = SingleOrgTrendOrTBHelper.getOrgIds((IFormView)this.getView());
            if (orgids == null) {
                return;
            }
            mainjump = "tctsa_single_analysis";
        } else {
            jumpFlag = true;
            startdate = DateUtils.stringToDate((String)((String)customParams.get("startdate")));
            enddate = DateUtils.stringToDate((String)((String)customParams.get("enddate")));
            finalTypeList = new ArrayList<Long>(32);
            if (null != customParams.get("typeList")) {
                finalTypeList = (List)SerializationUtils.fromJsonString((String)customParams.get("typeList").toString(), List.class);
            }
            if (null != customParams.get("orgList")) {
                orgids = (List)SerializationUtils.fromJsonString((String)customParams.get("orgList").toString(), List.class);
            }
        }
        SingleOrgTrendOrTBHelper.initTrendOrTBControl((Date)startdate, (Date)enddate, finalTypeList, (Boolean)jumpFlag, (List)orgids, (String)mainjump, (IFormView)this.getView(), (IPageCache)this.getPageCache());
    }

    private List<Long> getFinalTypeList() {
        DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)this.getView().getParentView().getModel().getValue("taxtype");
        List finalTypeList = dynamicObjects.stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).distinct().collect(Collectors.toList());
        if (finalTypeList.size() == 0) {
            finalTypeList = TctsaSysTaxTypeEnum.getTypeIdList();
        }
        return finalTypeList;
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (QUERYDETAILS.equals(key)) {
            SingleOrgTrendOrTBHelper.showForm((String)this.getView().getEntityId(), (IFormView)this.getView());
        } else if (HISTOGRAMCHARTAP.equals(key) || POINTLINECHARTAP.equals(key)) {
            String name = ((ChartClickEvent)evt).getName();
            String seriesName = ((ChartClickEvent)evt).getSeriesName();
            if (POINTLINECHARTAP.equals(key)) {
                Map pkidsMap;
                String currentpagecache = this.getPageCache().get("trendAllpagecache");
                if (EmptyCheckUtils.isNotEmpty((Object)currentpagecache) && EmptyCheckUtils.isNotEmpty((Object)(pkidsMap = (Map)SerializationUtils.fromJsonString((String)currentpagecache, Map.class)))) {
                    SingleOrgTrendOrTBHelper.openTjsjReport((List)((List)pkidsMap.get(name)), (IFormView)this.getView());
                }
            } else {
                Map pkidsMap;
                String pagecache;
                String datastr = "";
                Boolean isCurrentYear = false;
                if (EmptyCheckUtils.isNotEmpty((Object)seriesName)) {
                    datastr = seriesName.substring(0, 4);
                }
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                String jumpValue = (String)customParams.get("jump");
                Date enddate = null;
                enddate = "1".equals(jumpValue) ? DateUtils.stringToDate((String)((String)customParams.get("enddate"))) : SingleOrgTrendOrTBHelper.getEndDate((IFormView)this.getView());
                if (String.valueOf(DateUtils.getYearOfDate((Date)enddate)).equals(datastr)) {
                    isCurrentYear = true;
                }
                if (EmptyCheckUtils.isNotEmpty((Object)name)) {
                    String month = name.substring(0, name.length() - 2);
                    String month1 = StringUtil.fillCharAtLeft((Object)month, (int)2, (char)'0');
                    datastr = datastr + "-" + month1;
                }
                String string = pagecache = isCurrentYear != false ? this.getPageCache().get("currentpagecache") : this.getPageCache().get("previouspagecache");
                if (EmptyCheckUtils.isNotEmpty((Object)pagecache) && EmptyCheckUtils.isNotEmpty((Object)(pkidsMap = (Map)SerializationUtils.fromJsonString((String)pagecache, Map.class)))) {
                    SingleOrgTrendOrTBHelper.openTjsjReport((List)((List)pkidsMap.get(datastr)), (IFormView)this.getView());
                }
            }
        }
    }
}

