/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.statistics;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.tree.TreeFilterParameter;
import kd.taxc.tctsa.business.statistics.TaxStatisticsRptHelper;
import kd.taxc.tctsa.common.enums.TaxStatisticColEnum;
import kd.taxc.tctsa.common.enums.TaxStatisticDimensionEnum;
import kd.taxc.tctsa.common.helper.OpenAllDeclareHelper;
import kd.taxc.tctsa.common.helper.OrgServiceHelper;
import kd.taxc.tctsa.common.json.JsonUtil;
import kd.taxc.tctsa.common.util.DateUtils;
import org.apache.commons.lang.StringUtils;

public class TaxStatisticsRptPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static boolean isChangeDimension = false;
    private static final String REPORTFILTERAP = "reportfilterap";

    public void registerListener(EventObject e) {
        BasedataEdit org = (BasedataEdit)this.getView().getControl("org");
        org.addBeforeF7SelectListener(this::orgAddBeforeF7SelectListener);
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit manageareasBaseData = (BasedataEdit)this.getControl("manageareas");
        manageareasBaseData.addBeforeF7SelectListener(this::beforeManageareasSelect);
        MulBasedataEdit bizsegment = (MulBasedataEdit)this.getControl("bizsegment");
        bizsegment.addBeforeF7SelectListener(this::beforeBizSegmentSelect);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("reset".equals(afterDoOperationEventArgs.getOperateKey())) {
            this.getModel().setValue("startdate", (Object)DateUtils.getFirstDateOfYear((Date)new Date()));
            this.getModel().setValue("enddate", (Object)new Date());
        }
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.containsKey("ids")) {
            this.getPageCache().put("initsearch", "true");
            ReportFilter reportFilter = (ReportFilter)this.getView().getControl(REPORTFILTERAP);
            reportFilter.search();
        }
        Long orgId = null;
        if (customParams.get("org") != null) {
            orgId = Long.parseLong(customParams.get("org").toString());
        }
        String skssqq = (String)customParams.get("skssqq");
        String skssqz = (String)customParams.get("skssqz");
        List infos = queryParam.getFilter().getFilterItems();
        FilterItemInfo timeStart = new FilterItemInfo();
        timeStart.setPropName("startdate");
        timeStart.setValue((Object)(skssqq != null ? DateUtils.stringToDate((String)skssqq) : DateUtils.getFirstDateOfYear((Date)new Date())));
        infos.add(timeStart);
        FilterItemInfo timeEnd = new FilterItemInfo();
        timeEnd.setPropName("enddate");
        timeEnd.setValue((Object)(skssqz != null ? DateUtils.stringToDate((String)skssqz) : DateUtils.getLastDateOfMonth2((Date)new Date())));
        infos.add(timeEnd);
        List typeList = new ArrayList();
        if (null != customParams.get("taxtype")) {
            typeList = (List)SerializationUtils.fromJsonString((String)customParams.get("taxtype").toString(), List.class);
        }
        if (typeList.size() != 0) {
            FilterItemInfo taxtype = new FilterItemInfo();
            taxtype.setPropName("taxtype");
            taxtype.setValue(typeList);
            infos.add(taxtype);
        }
        if (orgId != null) {
            FilterItemInfo org = new FilterItemInfo();
            org.setPropName("org");
            org.setValue((Object)orgId);
            infos.add(org);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String id = hyperLinkClickEvent.getRowData().getString("sbbid");
        String sbbnocol = hyperLinkClickEvent.getRowData().getString("sbbno");
        OpenAllDeclareHelper.openTjsjb((IFormView)this.getView(), (String)id, (String)sbbnocol);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("dimension".equals(name)) {
            isChangeDimension = true;
            this.getView().refresh();
        }
    }

    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        super.formatDisplayFilterField(evt);
        IDataModel iDataModel = this.getView().getModel();
        ReportFilter reportFilter = (ReportFilter)this.getView().getControl(REPORTFILTERAP);
        String showFields = reportFilter.getShowFilterFields();
        if (StringUtils.isNotBlank((String)showFields)) {
            List showFieldList = (List)JsonUtil.fromJson((String)showFields, List.class);
            String msg = TaxStatisticsRptHelper.formatShowFilterString((List)showFieldList, (IDataModel)iDataModel, (IReportView)this.getView());
            evt.setFormatedFilterString(msg);
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        this.clearUserSetting();
        this.createDynamicCol();
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap"});
        this.createTrueQFilterList(queryParam);
        super.beforeQuery(queryParam);
    }

    private void createTrueQFilterList(ReportQueryParam queryParam) {
        List itemInfos = queryParam.getFilter().getFilterItems();
        itemInfos.removeIf(item -> item.getPropName().equals("dimension") || item.getPropName().equals("isChangeDimension"));
        FilterItemInfo dimensionInfo = new FilterItemInfo();
        dimensionInfo.setPropName("dimension");
        dimensionInfo.setValue(this.getModel().getValue("dimension"));
        queryParam.getFilter().getFilterItems().add(dimensionInfo);
        List orgIds = OrgServiceHelper.getOrgListHasPermission((IFormView)this.getView());
        if (this.getPageCache().get("initsearch") != null && "true".equals(this.getPageCache().get("initsearch"))) {
            this.setInitQueryFilter(queryParam, orgIds);
        }
        for (FilterItemInfo items : itemInfos) {
            if (!"org".equals(items.getPropName()) || items.getValue() != null) continue;
            items.setValue((Object)orgIds);
        }
        if (isChangeDimension) {
            FilterItemInfo info = new FilterItemInfo();
            info.setPropName("isChangeDimension");
            info.setValue((Object)"true");
            queryParam.getFilter().getFilterItems().add(info);
            isChangeDimension = false;
        }
    }

    private void createDynamicCol() {
        Object val = this.getView().getModel().getValue("dimension");
        if (ObjectUtils.isEmpty((Object)val)) {
            return;
        }
        ReportList listTable = (ReportList)this.getView().getControl("reportlistap");
        List reportColumnList = listTable.getColumns();
        TaxStatisticColEnum firstColEnum = TaxStatisticDimensionEnum.getEnumByCode((String)String.valueOf(val)).getFirstColEnum();
        ReportColumn firstReportColumn = null;
        int index = 0;
        for (int i = 0; i < reportColumnList.size(); ++i) {
            ReportColumn temp = (ReportColumn)reportColumnList.get(i);
            if (i == 0 && temp.getFieldKey().equalsIgnoreCase(firstColEnum.getRowMetaMsgInfo().getFieldId())) break;
            if (!temp.getFieldKey().equalsIgnoreCase(firstColEnum.getRowMetaMsgInfo().getFieldId())) continue;
            firstReportColumn = temp;
            index = i;
            break;
        }
        if (null != firstReportColumn && 0 != index) {
            reportColumnList.remove(index);
            reportColumnList.add(0, firstReportColumn);
        }
    }

    private void clearUserSetting() {
        String formId = (String)this.getView().getFormShowParameter().getCustomParams().get("formId");
        String configKey = formId + "_reportlistap_gridConfig";
        UserConfigServiceHelper.clearSetting((long)Long.parseLong(RequestContext.get().getUserId()), (String)configKey);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        Date startdate = filterInfo.getDate("startdate");
        Date enddate = filterInfo.getDate("enddate");
        List itemInfos = filterInfo.getFilterItems();
        List dimensions = itemInfos.stream().filter(r -> "dimension".equals(r.getPropName())).collect(Collectors.toList());
        if ((this.getPageCache().get("initsearch") == null || "false".equals(this.getPageCache().get("initsearch")) && dimensions.size() == 0) && (startdate == null || enddate == null)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaxStatisticsRptPlugin_1", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void setInitQueryFilter(ReportQueryParam queryParam, List<Long> orgIds) {
        this.getPageCache().put("initsearch", "false");
        FilterItemInfo orgfilter = new FilterItemInfo();
        orgfilter.setPropName("org");
        orgfilter.setValue(orgIds);
        queryParam.getFilter().getFilterItems().add(orgfilter);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List ids = (List)customParams.get("ids");
        FilterItemInfo idfilter = new FilterItemInfo();
        idfilter.setPropName("ids");
        idfilter.setValue((Object)ids);
        queryParam.getFilter().getFilterItems().add(idfilter);
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        Set unVisbleField = TaxStatisticsRptHelper.getUnVisibleFields();
        List list = event.getColumns();
        for (AbstractReportColumn abstractReportColumn : list) {
            ReportColumn reportColumn;
            String field;
            if (!(abstractReportColumn instanceof ReportColumn) || !unVisbleField.remove(field = (reportColumn = (ReportColumn)abstractReportColumn).getFieldKey())) continue;
            reportColumn.setHide(true);
        }
    }

    public void orgAddBeforeF7SelectListener(BeforeF7SelectEvent beforeF7SelectEvent) {
        OrgServiceHelper.fseven((BeforeF7SelectEvent)beforeF7SelectEvent, null, (String)"1");
    }

    private void beforeManageareasSelect(BeforeF7SelectEvent event) {
        this.setListParams(event, "org-attribute001.regulated_areas");
    }

    private void beforeBizSegmentSelect(BeforeF7SelectEvent event) {
        this.setListParams(event, "org-attribute001.biz-segment001");
    }

    private void setListParams(BeforeF7SelectEvent event, String longNumber) {
        ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
        TreeFilterParameter treeFilterParameter = new TreeFilterParameter();
        treeFilterParameter.getQFilters().add(new QFilter("longnumber", "=", (Object)longNumber));
        formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("group.longnumber", "=", (Object)longNumber));
        formShowParameter.setTreeFilterParameter(treeFilterParameter);
    }
}

