/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.statistics;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.taxc.tctsa.business.taxmain.TctsaTaxMainBusiness;
import kd.taxc.tctsa.business.taxmain.TctsaTaxOrgBusiness;
import kd.taxc.tctsa.business.tjsjb.TjsjbBusiness;
import kd.taxc.tctsa.common.constant.TctsaConstant;
import kd.taxc.tctsa.common.entity.RowMetaMsgInfo;
import kd.taxc.tctsa.common.enums.FilterItemEnum;
import kd.taxc.tctsa.common.enums.TaxStatisticColEnum;
import kd.taxc.tctsa.common.enums.TaxStatisticDimensionEnum;
import kd.taxc.tctsa.common.util.BizCommomUtil;
import kd.taxc.tctsa.common.util.DateUtils;
import kd.taxc.tctsa.common.util.EmptyCheckUtils;
import org.apache.commons.collections4.MapUtils;

public class TaxStatisticsRptQueryPlugin
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        List<RowMetaMsgInfo> rowMetaMsgInfoList = this.getRowMetaMsgInfoList(filterInfo);
        List<QFilter> filters = this.filterInfoTransToQFilter(filterInfo);
        DynamicObjectCollection taxMainCollection = this.getTaxMainCollection(filters);
        Map<Long, List<DynamicObject>> orgIdTaxMainMap = taxMainCollection.stream().collect(Collectors.groupingBy(p -> p.getLong("orgid")));
        DynamicObjectCollection statisticTaxTableData = this.getStatisticTaxTableData(filters, orgIdTaxMainMap.keySet().stream().collect(Collectors.toList()));
        return this.getDataResult(rowMetaMsgInfoList, orgIdTaxMainMap, statisticTaxTableData);
    }

    public List<RowMetaMsgInfo> getRowMetaMsgInfoList(FilterInfo filterInfo) {
        FilterItemInfo staticDimensionFilterItem = this.getStaticDimensionFilterItemInfo(filterInfo);
        if (staticDimensionFilterItem == null) {
            return new ArrayList<RowMetaMsgInfo>(0);
        }
        TaxStatisticDimensionEnum taxStatisticDimensionEnum = TaxStatisticDimensionEnum.getEnumByCode((String)String.valueOf(staticDimensionFilterItem.getValue()));
        if (taxStatisticDimensionEnum == null) {
            return new ArrayList<RowMetaMsgInfo>(0);
        }
        TaxStatisticColEnum taxStatisticColEnum = taxStatisticDimensionEnum.getFirstColEnum();
        if (taxStatisticColEnum == null) {
            return new ArrayList<RowMetaMsgInfo>(0);
        }
        return TaxStatisticColEnum.createDynamicCol((String)taxStatisticColEnum.getRowMetaMsgInfo().getFieldId());
    }

    private FilterItemInfo getStaticDimensionFilterItemInfo(FilterInfo filterInfo) {
        List filterItems = filterInfo.getFilterItems();
        if (CollectionUtils.isEmpty((Collection)filterItems)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (String)"TaxStatisticsRptQueryPlugin_0", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
        }
        return filterItems.stream().filter(p -> "dimension".equalsIgnoreCase(p.getPropName())).findFirst().orElse(null);
    }

    public List<QFilter> filterInfoTransToQFilter(FilterInfo filterInfo) {
        List filterItems = filterInfo.getFilterItems();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(filterItems.size());
        for (FilterItemInfo filterItem : filterItems) {
            QFilter qFilter;
            FilterItemEnum filterItemEnum;
            if (null == filterItem || null == filterItem.getValue() || (filterItemEnum = FilterItemEnum.getEnumByFilterItemPropName((String)filterItem.getPropName())) == null || (qFilter = filterItemEnum.getFilterConvert().getQFilter(filterItem)) == null) continue;
            filters.add(qFilter);
        }
        return filters;
    }

    public DynamicObjectCollection getTaxMainCollection(List<QFilter> filters) {
        ArrayList<QFilter> taxMainFilters = new ArrayList<QFilter>(3);
        List orgIds = new ArrayList(0);
        for (QFilter filter : filters) {
            if (filter.getProperty().equalsIgnoreCase("org")) {
                orgIds = (List)filter.getValue();
                continue;
            }
            if (!Stream.of("orgattr.fbasedataid.id", "codeandname.id").anyMatch(p -> p.equalsIgnoreCase(filter.getProperty()))) continue;
            taxMainFilters.add(filter);
        }
        return TctsaTaxMainBusiness.getTaxMainCollection(orgIds, taxMainFilters);
    }

    public DynamicObjectCollection getStatisticTaxTableData(List<QFilter> filters, List<Long> orgIds) {
        List statisticTaxTableFilters = filters.stream().filter(p -> Stream.of("org", "orgattr.fbasedataid.id", "codeandname.id").noneMatch(t -> t.equals(p.getProperty()))).collect(Collectors.toList());
        statisticTaxTableFilters.add(new QFilter("org", "in", orgIds));
        return TjsjbBusiness.getTaxesAndFeesDetails(statisticTaxTableFilters);
    }

    public DataSet getDataResult(List<RowMetaMsgInfo> rowMetaMsgInfoList, Map<Long, List<DynamicObject>> orgIdTaxMainMap, DynamicObjectCollection statisticTaxTableData) {
        if (statisticTaxTableData == null || statisticTaxTableData.size() == 0) {
            return this.getDataSet(rowMetaMsgInfoList, new ArrayList<Object[]>(0));
        }
        List<Map<String, Object>> dataSetRowMaps = this.getDataSetRowMapData(statisticTaxTableData, orgIdTaxMainMap);
        String groupField = rowMetaMsgInfoList.get(0).getQueryFiled();
        Map<Object, List<Map<String, Object>>> groupRowMap = dataSetRowMaps.stream().collect(Collectors.groupingBy(k -> k.get(groupField)));
        List<Object[]> allRowData = this.getDataSetAllRowData(rowMetaMsgInfoList, groupRowMap);
        return this.getDataSet(rowMetaMsgInfoList, allRowData);
    }

    private DataSet getDataSet(List<RowMetaMsgInfo> rowMetaMsgInfoList, Collection<Object[]> rowValues) {
        RowMeta rowMeta = BizCommomUtil.createRowMeta(rowMetaMsgInfoList);
        CollectionInput inputs = new CollectionInput(rowMeta, rowValues);
        return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
    }

    private Map<Long, String[]> getOrgAttrMap(Map<Long, List<DynamicObject>> orgIdTaxMainMap) {
        if (MapUtils.isEmpty(orgIdTaxMainMap)) {
            return new HashMap<Long, String[]>(0);
        }
        HashMap<Long, String[]> result = new HashMap<Long, String[]>(orgIdTaxMainMap.size());
        for (Map.Entry<Long, List<DynamicObject>> orgIdTaxMainEntry : orgIdTaxMainMap.entrySet()) {
            String[] value = new String[]{"", ""};
            result.put(orgIdTaxMainEntry.getKey(), value);
            for (DynamicObject object : orgIdTaxMainEntry.getValue()) {
                if ("regulated_areas".equalsIgnoreCase(object.getString("number"))) {
                    value[0] = object.getString("name");
                    continue;
                }
                if (!"biz-segment001".equalsIgnoreCase(object.getString("number"))) continue;
                value[1] = object.getString("name");
            }
        }
        return result;
    }

    private List<Map<String, Object>> getDataSetRowMapData(DynamicObjectCollection statisticTaxTableData, Map<Long, List<DynamicObject>> orgIdTaxMainMap) {
        Map<Long, String[]> orgAttrMap = this.getOrgAttrMap(orgIdTaxMainMap);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(statisticTaxTableData.size());
        Map<Long, List<DynamicObject>> orgidsMap = statisticTaxTableData.stream().collect(Collectors.groupingBy(m -> m.getLong("taxationsys")));
        HashMap taxpayerMap = new HashMap();
        for (Map.Entry<Long, List<DynamicObject>> mapentry : orgidsMap.entrySet()) {
            List orgids = mapentry.getValue().stream().map(v -> v.getLong("org")).collect(Collectors.toList());
            taxpayerMap.putAll(TctsaTaxOrgBusiness.getTaxOrgTaxpayer(orgids, (Long)mapentry.getKey()));
        }
        for (DynamicObject statisticTaxTableDatum : statisticTaxTableData) {
            if (EmptyCheckUtils.isEmpty((Object)statisticTaxTableDatum.getLong("orgmasterid"))) continue;
            HashMap<String, Object> rowMap = new HashMap<String, Object>(17);
            rowMap.put("orgid", statisticTaxTableDatum.getString("orgname"));
            if (taxpayerMap.containsKey(TctsaTaxOrgBusiness.getKey((DynamicObject)statisticTaxTableDatum))) {
                rowMap.put("taxpayer", taxpayerMap.get(TctsaTaxOrgBusiness.getKey((DynamicObject)statisticTaxTableDatum)));
            }
            rowMap.put("taxtype", statisticTaxTableDatum.getString("taxtypename"));
            rowMap.put("skssqz", DateUtils.format((Date)statisticTaxTableDatum.getDate("skssqq"), (String)TctsaConstant.FORMAT).concat("~").concat(DateUtils.format((Date)statisticTaxTableDatum.getDate("skssqz"), (String)TctsaConstant.FORMAT)));
            rowMap.put("tabletype", statisticTaxTableDatum.getString("type"));
            rowMap.put("levytypecol", statisticTaxTableDatum.getString("levytype"));
            rowMap.put("apanage", statisticTaxTableDatum.getString("apanage"));
            rowMap.put("yssr", statisticTaxTableDatum.getBigDecimal("yssr").setScale(2, 4));
            rowMap.put("bqybtse", statisticTaxTableDatum.getBigDecimal("bqybtse").setScale(2, 4));
            rowMap.put("ynse", statisticTaxTableDatum.getBigDecimal("ynse").setScale(2, 4));
            rowMap.put("jmse", statisticTaxTableDatum.getBigDecimal("jmse").setScale(2, 4));
            rowMap.put("fsl", statisticTaxTableDatum.getBigDecimal("fsl").multiply(BigDecimal.valueOf(100L)).setScale(2, 4) + "%");
            rowMap.put("datasouce", statisticTaxTableDatum.getString("datatype"));
            rowMap.put("sbbid", statisticTaxTableDatum.getString("sbbid"));
            rowMap.put("sbbno", statisticTaxTableDatum.getString("formno"));
            long orgMasterId = statisticTaxTableDatum.getLong("orgmasterid");
            String[] values = orgAttrMap.get(orgMasterId);
            if (values != null && values.length >= 2) {
                rowMap.put("managareas", values[0]);
                rowMap.put("bizsegmentname", values[1]);
            } else {
                rowMap.put("managareas", "");
                rowMap.put("bizsegmentname", "");
            }
            List<DynamicObject> objects = orgIdTaxMainMap.get(orgMasterId);
            if (!CollectionUtils.isEmpty(objects)) {
                DynamicObject taxMainObject = objects.get(0);
                rowMap.put("industryname", taxMainObject.get("codename"));
                rowMap.put("area", taxMainObject.get("registeraddress"));
            }
            result.add(rowMap);
        }
        return result;
    }

    private List<Object[]> getDataSetAllRowData(List<RowMetaMsgInfo> rowMetaMsgInfoList, Map<Object, List<Map<String, Object>>> groupRowMap) {
        ArrayList<Object[]> result = new ArrayList<Object[]>(16);
        Object[] totalRowData = new Object[rowMetaMsgInfoList.size()];
        totalRowData[0] = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"TaxStatisticsRptQueryPlugin_1", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]);
        for (Map.Entry<Object, List<Map<String, Object>>> groupRowEntry : groupRowMap.entrySet()) {
            Object[] subTotalRowData = new Object[totalRowData.length];
            subTotalRowData[0] = groupRowEntry.getKey();
            if (subTotalRowData[0] == null || StringUtils.isEmpty((String)subTotalRowData[0].toString())) {
                subTotalRowData[0] = ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"TaxStatisticsRptQueryPlugin_2", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]);
            }
            for (Map<String, Object> dataSetRowMap : groupRowEntry.getValue()) {
                Object[] rowData = TaxStatisticsRptQueryPlugin.getDataSetRowValue(dataSetRowMap, rowMetaMsgInfoList, totalRowData, subTotalRowData);
                result.add(rowData);
            }
            result.add(subTotalRowData);
        }
        result.add(totalRowData);
        return result;
    }

    private static Object[] getDataSetRowValue(Map<String, Object> dataSetRowDataMap, List<RowMetaMsgInfo> rowMetaMsgInfoList, Object[] totalRowData, Object[] subTotalRowData) {
        Object[] row = new Object[rowMetaMsgInfoList.size()];
        int index = 0;
        for (RowMetaMsgInfo rowMetaMsg : rowMetaMsgInfoList) {
            row[index] = dataSetRowDataMap.get(rowMetaMsg.getQueryFiled());
            if (TaxStatisticColEnum.SBBID.getRowMetaMsgInfo().getFieldId().equals(rowMetaMsg.getFieldId())) {
                totalRowData[index] = -1;
                subTotalRowData[index] = 0;
            }
            if (Stream.of(TaxStatisticColEnum.CURRENTPAY.getRowMetaMsgInfo().getFieldId(), TaxStatisticColEnum.TAXABLEINCOME.getRowMetaMsgInfo().getFieldId(), TaxStatisticColEnum.JMSE.getRowMetaMsgInfo().getFieldId(), TaxStatisticColEnum.YNSE.getRowMetaMsgInfo().getFieldId()).anyMatch(p -> p.equals(rowMetaMsg.getFieldId()))) {
                BigDecimal value = row[index] == null ? BigDecimal.ZERO : new BigDecimal(row[index].toString());
                totalRowData[index] = totalRowData[index] == null ? row[index] : new BigDecimal(totalRowData[index].toString()).add(value);
                subTotalRowData[index] = subTotalRowData[index] == null ? row[index] : new BigDecimal(subTotalRowData[index].toString()).add(value);
            }
            ++index;
        }
        return row;
    }
}

