/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.tjsjconfig;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tctsa.common.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class TjsjbConfigRuleEditPlugin
extends AbstractFormPlugin
implements CellClickListener {
    private static Log logger = LogFactory.getLog(TjsjbConfigRuleEditPlugin.class);
    private static final String ENTRYENTITY = "entryentity";
    private static final String OPERATIONCOLUMNAP = "operationcolumnap";
    private static final String TCTSA_TJSJB_DATAS_CONFIG = "tctsa_tjsjb_config_new";
    private static final String FCSTAXITEMS = "fcstaxitems";
    private static final String YHSTAXITEMS = "yhstaxitems";
    private static final String TPO_TCRET_TAXRATE = "tpo_tcret_taxrate";
    private static final String TPO_TCSD_TAXRATE = "tpo_tcsd_taxrate";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        EntryGrid entry = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        if (null != entry) {
            entry.addCellClickListener((CellClickListener)this);
        }
        this.addClickListeners(new String[]{"advconbaritemap"});
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        if (e.getEntryProp().getName().equals(ENTRYENTITY)) {
            this.setComboEdit("tctb_tjsjb");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Save) {
            long taxgroup = ((DynamicObject)this.getModel().getValue("group")).getLong("id");
            String businesssource = this.getModel().getValue("businesssource").toString();
            String type = null;
            if (this.getModel().getValue("type") != null) {
                type = ((DynamicObject)this.getModel().getValue("type")).getString("id");
            }
            String taxitemsname = "";
            if (this.getModel().getValue("taxitemsname") != null) {
                taxitemsname = this.getModel().getValue("taxitemsname").toString();
            }
            QFilter taxareagroupQ = new QFilter("taxareagroup", "=", (Object)this.getModel().getDataEntity().getLong("id"));
            QFilter groupQ = new QFilter("group", "=", (Object)taxgroup);
            QFilter businesssourceQ = new QFilter("businesssource", "=", (Object)businesssource);
            QFilter typeQ = new QFilter("type", "=", (Object)type);
            QFilter taxitemsnameQ = new QFilter("taxitemsname", "=", (Object)taxitemsname);
            Long idObj = (Long)this.getView().getModel().getValue("id");
            QFilter idObjQ = new QFilter("id", "!=", (Object)idObj);
            Date startdate = (Date)this.getModel().getValue("effectdate");
            Date enddate = (Date)this.getModel().getValue("invaliddate");
            if (enddate != null && startdate != null && startdate.compareTo(enddate) > 0) {
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u751f\u6548\u65e5\u671f\u3002", (String)"TjsjbConfigRuleEditPlugin_0", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter qfilter1 = new QFilter("invaliddate", ">=", (Object)startdate);
            qfilter1 = qfilter1.and(new QFilter("invaliddate", "<=", (Object)enddate));
            QFilter qfilter2 = new QFilter("effectdate", ">=", (Object)startdate);
            qfilter2 = qfilter2.and(new QFilter("invaliddate", "<=", (Object)enddate));
            QFilter qfilter3 = new QFilter("effectdate", "<=", (Object)startdate);
            qfilter3 = qfilter3.and(new QFilter("invaliddate", ">=", (Object)enddate));
            QFilter qfilter4 = new QFilter("effectdate", ">=", (Object)startdate);
            qfilter4 = qfilter4.and(new QFilter("effectdate", "<=", (Object)enddate));
            QFilter dateQ = qfilter1.or(qfilter2).or(qfilter3).or(qfilter4);
            QFilter allfilter = groupQ;
            allfilter = allfilter.and(typeQ);
            allfilter = allfilter.and(taxitemsnameQ);
            allfilter = allfilter.and(businesssourceQ);
            allfilter = allfilter.and(idObjQ);
            allfilter = allfilter.and(dateQ);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctsa_tjsjb_rule_config", (String)"id", (QFilter[])new QFilter[]{allfilter = allfilter.and(taxareagroupQ)});
            if (null != collection && collection.size() > 0) {
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u6761\u6570\u636e\u6709\u6548\u671f\u4e0e\u73b0\u6709\u6570\u636e\u5b58\u5728\u91cd\u5408\u65f6\u95f4\u3002", (String)"TjsjbConfigRuleEditPlugin_1", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObjectCollection entryRows = this.getModel().getEntryEntity(ENTRYENTITY);
        if (CollectionUtils.isEmpty((Collection)entryRows)) {
            return;
        }
        String entityname = ((DynamicObject)entryRows.get(0)).getString("accessobject");
        this.setComboEdit(entityname);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (FCSTAXITEMS.equals(name) || YHSTAXITEMS.equals(name)) {
            DynamicObject fcstaxitems = (DynamicObject)this.getView().getModel().getValue(FCSTAXITEMS.equals(name) ? FCSTAXITEMS : YHSTAXITEMS);
            if (fcstaxitems != null) {
                long id = fcstaxitems.getLong("id");
                QFilter idFilter = new QFilter("id", "=", (Object)id);
                String fcsfield = "id, entryentity.mergecode as mergecode,entryentity.subname as subname";
                String yhsfield = "id, entryentity.subnumber as mergecode,entryentity.subname as subname";
                DynamicObjectCollection resultCollection = QueryServiceHelper.query((String)(FCSTAXITEMS.equals(name) ? TPO_TCRET_TAXRATE : TPO_TCSD_TAXRATE), (String)(FCSTAXITEMS.equals(name) ? fcsfield : yhsfield), (QFilter[])new QFilter[]{idFilter});
                if (resultCollection != null && resultCollection.size() > 0) {
                    ArrayList<ComboItem> combos = new ArrayList<ComboItem>(resultCollection.size());
                    for (DynamicObject dynamicObject : resultCollection) {
                        ComboItem item = new ComboItem();
                        item.setValue(dynamicObject.getString("mergecode"));
                        item.setCaption(new LocaleString(dynamicObject.getString("subname")));
                        combos.add(item);
                    }
                    this.getModel().setValue("taxitemsname", (Object)((ComboItem)combos.get(0)).getValue());
                    ComboEdit comboEdit = (ComboEdit)this.getView().getControl("taxitemsname");
                    comboEdit.setComboItems(combos);
                }
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"taxitemsname"});
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)"accessobject")) {
            String entityname = (String)e.getChangeSet()[0].getNewValue();
            this.setComboEdit(entityname);
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        String fieldkey = cellClickEvent.getFieldKey();
        int row = cellClickEvent.getRow();
        if (OPERATIONCOLUMNAP.equals(fieldkey)) {
            String recheck = null;
            String datasourcetext = null;
            String datasourcejson = null;
            if (this.getView().getModel().getValue("recheck", row) != null) {
                recheck = this.getView().getModel().getValue("recheck", row).toString();
                datasourcetext = this.getView().getModel().getValue("datasourcetext", row).toString();
                datasourcejson = this.getView().getModel().getValue("datasourcejson_tag", row).toString();
            }
            this.openPage(fieldkey, row, recheck, datasourcetext, datasourcejson);
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    private void openPage(String key, int row, String recheck, String datasourcetext, String datasourcejson) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(TCTSA_TJSJB_DATAS_CONFIG);
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key + "_" + row);
        if (StringUtil.isNotEmpty((CharSequence)recheck)) {
            showParameter.setCustomParam("recheck", (Object)recheck);
            showParameter.setCustomParam("datasourcetext", (Object)datasourcetext);
            showParameter.setCustomParam("datasourcejson", (Object)datasourcejson);
        }
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String id = event.getActionId();
        Map returnData = (Map)event.getReturnData();
        String[] ids = id.split("_");
        if (null != returnData) {
            String textfield = returnData.get("datasourcetext").toString();
            String datasourcejson = returnData.get("datasourcejson").toString();
            String recheck = returnData.get("recheck").toString();
            this.getModel().setValue("datasourcetext", (Object)textfield, Integer.parseInt(ids[1]));
            this.getModel().setValue("datasourcejson_tag", (Object)datasourcejson, Integer.parseInt(ids[1]));
            this.getModel().setValue("recheck", (Object)recheck, Integer.parseInt(ids[1]));
        }
    }

    private void setComboEdit(String entityname) {
        try {
            if (StringUtils.isEmpty((CharSequence)entityname)) {
                return;
            }
            String id = MetadataDao.getIdByNumber((String)entityname, (MetaCategory)MetaCategory.Form);
            FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
            List items = formMeta.getItems();
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(items.size());
            for (ControlAp item : items) {
                if (!(item instanceof FieldAp)) continue;
                String namecol = item.getName().getLocaleValue();
                String key = item.getKey();
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString(namecol));
                comboItem.setValue(key);
                comboItems.add(comboItem);
            }
            ComboEdit comboEdit = (ComboEdit)this.getControl("accessfield");
            comboEdit.setComboItems(comboItems);
        }
        catch (Exception e) {
            logger.info("TjsjbConfigRuleEditPlugin.propertyChanged\u6839\u636e\u53d6\u6570\u9879\u76ee\u83b7\u53d6\u53d6\u6570\u5b57\u6bb5\u5931\u8d25\uff0c" + entityname, (Object)e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee\u5f02\u5e38\u3002", (String)"TjsjbConfigRuleEditPlugin_2", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
        }
    }
}

