/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.opplugin.fixedfill;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tctsa.common.constant.TctsaConstant;
import kd.taxc.tctsa.common.helper.FixedFillHandlerHelper;

public class BatchEnterpriseFillFlowOp
extends AbstractOperationServicePlugIn {
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] fillingAggrs;
        DynamicObject[] dataEntities;
        String operateKey = e.getOperationKey();
        super.afterExecuteOperationTransaction(e);
        if (!TctsaConstant.WORKFLOW_KEYS.contains(operateKey)) {
            return;
        }
        String billstatus = null;
        if ("submit".equals(operateKey)) {
            billstatus = "B";
        }
        if ("unsubmit".equals(operateKey) || "unaudit".equals(operateKey)) {
            billstatus = "A";
        }
        if ("audit".equals(operateKey)) {
            billstatus = "C";
        }
        if ((dataEntities = e.getDataEntities()) == null || dataEntities.length == 0) {
            return;
        }
        List ids = Arrays.stream(dataEntities).map(m -> m.getLong("id")).distinct().collect(Collectors.toList());
        for (DynamicObject fixedFillingAggr : fillingAggrs = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tctsa_fixed_filling_aggr"))) {
            DynamicObject[] fillings;
            List fixedFillingIds = fixedFillingAggr.getDynamicObjectCollection("entryentity").stream().map(m -> m.getLong("fixedfilling.id")).collect(Collectors.toList());
            for (DynamicObject filling : fillings = BusinessDataServiceHelper.load((Object[])fixedFillingIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tctsa_fixed_filling_query"))) {
                filling.set("billstatus", (Object)billstatus);
                filling.set("workflowno", (Object)fixedFillingAggr.getString("billno"));
            }
            SaveServiceHelper.update((DynamicObject[])fillings);
            FixedFillHandlerHelper.handlerFixedFillDataStatusChange((DynamicObject[])fillings, (String)billstatus);
        }
    }
}

