/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.opplugin.preferentstatistic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tctsa.opplugin.preferentstatistic.PreferentStstisticOp;

public class PreStstisticEnableOp
extends AbstractOperationServicePlugIn {
    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        String operationKey = args.getOperationKey();
        DynamicObject[] dataEntities = args.getDataEntities();
        if ("enable".equals(operationKey)) {
            HashSet taxcategoryidList = new HashSet(16);
            HashSet typeList = new HashSet(16);
            ArrayList ids = new ArrayList(16);
            Arrays.stream(dataEntities).forEach(a -> ids.add(a.getLong("id")));
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"tctsa_preferentdata", (String)"id,name,number,taxcategoryid.masterid,type,activedate,expdate", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            Arrays.stream(dynamicObjects).forEach(v -> {
                taxcategoryidList.add(v.getLong("taxcategoryid.masterid"));
                typeList.add(v.getString("type"));
            });
            QFilter commonFilter = new QFilter("taxcategoryid", "in", taxcategoryidList).and(new QFilter("type", "in", typeList).and(new QFilter("enable", "=", (Object)"1")));
            DynamicObjectCollection zspmByNames = QueryServiceHelper.query((String)"tctsa_preferentdata", (String)"id,name,number,taxcategoryid.masterid,type,activedate,expdate", (QFilter[])commonFilter.toArray());
            zspmByNames.addAll(Arrays.asList(dynamicObjects));
            this.checkTime(dynamicObjects, zspmByNames, args);
        }
    }

    private void checkTime(DynamicObject[] dynamicObjects, DynamicObjectCollection zspmByNames, BeforeOperationArgs args) {
        Map<String, List<DynamicObject>> zspmByNamesGroups = zspmByNames.stream().collect(Collectors.groupingBy(s -> s.getString("taxcategoryid.masterid").concat("_").concat(s.getString("type"))));
        for (DynamicObject dataEntity : dynamicObjects) {
            String taxcategoryid = dataEntity.getString("taxcategoryid.masterid");
            String type = dataEntity.getString("type");
            String flag = taxcategoryid.concat("_").concat(type);
            Date begin = dataEntity.getDate("activedate");
            Date end = dataEntity.getDate("expdate");
            Long id = dataEntity.getLong("id");
            if (zspmByNamesGroups.containsKey(flag) && !CollectionUtils.isEmpty((Collection)zspmByNamesGroups.get(flag))) {
                if (!PreferentStstisticOp.checkSingle(begin, end, id, zspmByNamesGroups.get(flag))) continue;
                String msg = String.format(ResManager.loadKDString((String)"\u8be5\u6761\u6570\u636e\u6709\u6548\u671f\u4e0e\u73b0\u6709\u53ef\u7528\u72b6\u6001\u6570\u636e\u5b58\u5728\u91cd\u5408\u65f6\u95f4\u3002", (String)"PreStstisticEnableOp_0", (String)"taxc-tctsa-opplugin", (Object[])new Object[0]), new Object[0]);
                args.setCancel(true);
                args.setCancelMessage(msg);
                break;
            }
            if (!PreferentStstisticOp.checkSingle(begin, end, id, (List<DynamicObject>)new DynamicObjectCollection())) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u8be5\u6761\u6570\u636e\u6709\u6548\u671f\u4e0e\u73b0\u6709\u53ef\u7528\u72b6\u6001\u6570\u636e\u5b58\u5728\u91cd\u5408\u65f6\u95f4\u3002", (String)"PreStstisticEnableOp_0", (String)"taxc-tctsa-opplugin", (Object[])new Object[0]), new Object[0]);
            args.setCancel(true);
            args.setCancelMessage(msg);
            break;
        }
    }
}

