/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.opplugin.preferentstatistic;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tctsa.opplugin.preferentstatistic.TimeCheckUtil;

public class PreferentStstisticOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ZspmValidator());
    }

    public static boolean checkSingle(Date begin, Date end, Long id, List<DynamicObject> zspmByNames) {
        for (DynamicObject zspm : zspmByNames) {
            Date date2;
            Date date1;
            if (id != null && id.equals(zspm.getLong("id")) || TimeCheckUtil.timeCheck(begin, end, date1 = zspm.getDate("activedate"), date2 = zspm.getDate("expdate"))) continue;
            return true;
        }
        return false;
    }

    private static class ZspmValidator
    extends AbstractValidator {
        private ZspmValidator() {
        }

        public void validate() {
            if (StringUtils.equals((CharSequence)"save", (CharSequence)this.getOperateKey()) || StringUtils.equals((CharSequence)"enable", (CharSequence)this.getOperateKey())) {
                List taxcategoryidList = Arrays.stream(this.dataEntities).map(dataEntity -> dataEntity.getDataEntity().getLong("taxcategoryid.masterid")).collect(Collectors.toList());
                List typeList = Arrays.stream(this.dataEntities).map(dataEntity -> dataEntity.getDataEntity().getString("type")).collect(Collectors.toList());
                QFilter commonFilter = new QFilter("taxcategoryid", "in", taxcategoryidList).and(new QFilter("type", "in", typeList).and(new QFilter("enable", "=", (Object)"1")));
                DynamicObjectCollection zspmByNames = QueryServiceHelper.query((String)"tctsa_preferentdata", (String)"id,name,number,taxcategoryid.masterid,type,activedate,expdate", (QFilter[])commonFilter.toArray());
                this.checkTime(this.dataEntities, zspmByNames);
            }
        }

        private void checkTime(ExtendedDataEntity[] dataEntities, DynamicObjectCollection zspmByNames) {
            Map<String, List<DynamicObject>> zspmByNamesGroups = zspmByNames.stream().collect(Collectors.groupingBy(s -> s.getString("taxcategoryid.masterid").concat("_").concat(s.getString("type"))));
            for (ExtendedDataEntity dataEntity : dataEntities) {
                String taxcategoryid = dataEntity.getDataEntity().getString("taxcategoryid.masterid");
                String type = dataEntity.getDataEntity().getString("type");
                String flag = taxcategoryid.concat("_").concat(type);
                Date begin = dataEntity.getDataEntity().getDate("activedate");
                Date end = dataEntity.getDataEntity().getDate("expdate");
                Long id = dataEntity.getDataEntity().getLong("id");
                if (zspmByNamesGroups.containsKey(flag) && !CollectionUtils.isEmpty((Collection)zspmByNamesGroups.get(flag))) {
                    if (!PreferentStstisticOp.checkSingle(begin, end, id, zspmByNamesGroups.get(flag))) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8be5\u6761\u6570\u636e\u6709\u6548\u671f\u4e0e\u73b0\u6709\u53ef\u7528\u72b6\u6001\u6570\u636e\u5b58\u5728\u91cd\u5408\u65f6\u95f4\u3002", (String)"PreferentStstisticOp_0", (String)"taxc-tctsa-opplugin", (Object[])new Object[0]), new Object[0]));
                    continue;
                }
                if (!PreferentStstisticOp.checkSingle(begin, end, id, (List<DynamicObject>)new DynamicObjectCollection())) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8be5\u6761\u6570\u636e\u6709\u6548\u671f\u4e0e\u73b0\u6709\u53ef\u7528\u72b6\u6001\u6570\u636e\u5b58\u5728\u91cd\u5408\u65f6\u95f4\u3002", (String)"PreferentStstisticOp_0", (String)"taxc-tctsa-opplugin", (Object[])new Object[0]), new Object[0]));
            }
        }
    }
}

