/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.mservice.skill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.fi.fatvs.skilldata.ISkillRunnable;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunContext;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunResult;
import kd.taxc.tctsa.business.service.TaxStatisticService;
import kd.taxc.tctsa.common.enums.TaxStatisticSkillEnum;
import kd.taxc.tctsa.common.util.DateUtils;

public class TaxStatisticSkillAPI
implements ISkillRunnable {
    private static String SKILL_NUMBER = "tjfxjqr";
    private static String AMOUNT_FIELD = "bqybtse";

    public SkillRunResult pullData(SkillRunContext skillRunContext) {
        SkillRunResult skillResult = skillRunContext.getSkillResult();
        String skillNum = skillRunContext.getSkillNum();
        Date startTime = skillRunContext.getStartTime();
        Date endTime = skillRunContext.getEndTime();
        if (SKILL_NUMBER.equalsIgnoreCase(skillNum)) {
            ArrayList list = new ArrayList(3);
            Date now = new Date();
            Date date = DateUtils.addMonth((Date)now, (int)-1);
            Date startDate = DateUtils.getFirstDateOfMonth((Date)date);
            Date endDate = DateUtils.getLastDateOfMonth((Date)date);
            for (TaxStatisticSkillEnum itemEnum : TaxStatisticSkillEnum.values()) {
                String number = itemEnum.getNumber();
                String value = this.getValueByNumber(number, startDate, endDate);
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("number", number);
                paramMap.put("name", itemEnum.getName());
                paramMap.put("valueType", itemEnum.getValueType());
                paramMap.put("value", value);
                list.add(paramMap);
            }
            int totalCount = 0;
            skillResult.setData(list);
            skillResult.setDate(skillRunContext.getStartTime());
            skillResult.setSkillNum(skillNum);
            skillResult.setFailCount(Integer.valueOf(0));
            skillResult.setTotalCount(Integer.valueOf(totalCount));
        }
        return skillResult;
    }

    private String getValueByNumber(String number, Date startTime, Date endTime) {
        StringBuilder valueBuilder = new StringBuilder();
        BigDecimal taxAmount = BigDecimal.ZERO;
        DynamicObjectCollection colls = null;
        switch (number) {
            case "nsze": {
                colls = TaxStatisticService.getTaxAmount((Date)startTime, (Date)endTime, null, null);
                break;
            }
            case "zzsnsze": {
                colls = TaxStatisticService.getTaxAmount((Date)startTime, (Date)endTime, Collections.singletonList(1L), null);
                break;
            }
            case "qysdsnsze": {
                colls = TaxStatisticService.getTaxAmount((Date)startTime, (Date)endTime, Collections.singletonList(3L), Collections.singletonList("qysdsjb"));
                break;
            }
        }
        if (colls != null && colls.size() > 0) {
            taxAmount = colls.stream().map(s -> s.getBigDecimal(AMOUNT_FIELD)).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        valueBuilder.append(taxAmount.setScale(2, 4).toString());
        valueBuilder.append(ResManager.loadKDString((String)" \u4e07\u5143", (String)"TaxStatisticSkillAPI_1", (String)"taxc-tctsa-mservice", (Object[])new Object[0]));
        return valueBuilder.toString();
    }
}

