/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.mservice.update;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.fileservice.utils.ExceptionUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.tctsa.common.util.DBUtils;
import kd.taxc.tctsa.common.util.DateUtils;

public class EnterpriseFillItemUpgradeService
implements IUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(EnterpriseFillItemUpgradeService.class);
    private static final String ALGOKEY = "EnterpriseFillItemUpgradeService";
    private static final String DBKEY_TAX = "taxc";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult up = new UpgradeResult();
        up.setSuccess(true);
        up.setLog(ResManager.loadKDString((String)"\u56fa\u5b9a\u586b\u62a5\u67e5\u8be2\uff0c\u586b\u62a5\u6240\u5c5e\u671f\u6b62\u5b57\u6bb5\u5347\u7ea7\u6210\u529f\u3002", (String)"EnterpriseFillItemUpgradeService_0", (String)"taxc-tctsa-mservice", (Object[])new Object[0]));
        LOGGER.info("EnterpriseFillItemUpgradeService\u56fa\u5b9a\u586b\u62a5\u67e5\u8be2\uff0c\u586b\u62a5\u6240\u5c5e\u671f\u6b62\u5b57\u6bb5\u5347\u7ea7\uff0c\u5f00\u59cb\u5347\u7ea7");
        try {
            List<Map<String, Object>> list = this.queryNeedUpgrade();
            LOGGER.info("\u9700\u8981\u5347\u7ea7\u7684\u6570\u91cf" + list.size());
            this.batchSave(list);
            LOGGER.info("\u5347\u7ea7\u7ed3\u675f");
        }
        catch (Exception e) {
            up.setSuccess(true);
            up.setLog(ResManager.loadKDString((String)"\u56fa\u5b9a\u586b\u62a5\u67e5\u8be2\uff0c\u586b\u62a5\u6240\u5c5e\u671f\u6b62\u5b57\u6bb5\u5347\u7ea7\u5931\u8d25\u3002", (String)"EnterpriseFillItemUpgradeService_1", (String)"taxc-tctsa-mservice", (Object[])new Object[]{ExceptionUtil.toString((Throwable)e)}));
            LOGGER.error("\u56fa\u5b9a\u586b\u62a5\u67e5\u8be2\uff0c\u586b\u62a5\u6240\u5c5e\u671f\u6b62\u5b57\u6bb5\u5347\u7ea7\u5931\u8d25\uff1a" + ExceptionUtil.toString((Throwable)e));
        }
        return up;
    }

    private List<Map<String, Object>> queryNeedUpgrade() {
        ArrayList<Map<String, Object>> target = new ArrayList<Map<String, Object>>(8);
        StringBuilder sql = new StringBuilder("select fid,fskssqz from t_tctsa_fix_filling_query");
        DataSet datas = DB.queryDataSet((String)ALGOKEY, (DBRoute)DBRoute.of((String)DBKEY_TAX), (String)sql.toString());
        while (datas.hasNext()) {
            Row row = datas.next();
            Date fskssqz = row.getDate("fskssqz");
            HashMap<String, Comparable<Long>> sbpz = new HashMap<String, Comparable<Long>>(8);
            sbpz.put("id", row.getLong("fid"));
            sbpz.put("fskssqz", DateUtils.getLastDateOfMonth2((Date)fskssqz));
            target.add(sbpz);
        }
        datas.close();
        return target;
    }

    private void batchSave(List<Map<String, Object>> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List partition = Lists.partition(list, (int)300);
        for (List maps : partition) {
            ArrayList<Object[]> params = new ArrayList<Object[]>(4);
            for (Map item : maps) {
                Object[] objs = new Object[]{item.get("fskssqz"), item.get("id")};
                params.add(objs);
            }
            StringBuilder sql = new StringBuilder();
            sql.append("update t_tctsa_fix_filling_query set fskssqz= ? where fid= ? ");
            DBUtils.executeBatch((String)DBKEY_TAX, (String)sql.toString(), params);
        }
    }
}

