/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.common.enums;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.lang3.StringUtils;

public enum FilterItemEnum {
    ORG("org", filterItem -> FilterItemEnum.collectionValueToQFilter(filterItem, "org")),
    TAX_TYPE("taxtype", filterItem -> FilterItemEnum.collectionValueToQFilter(filterItem, "taxtype")),
    MANAGE_AREA("manageareas", filterItem -> FilterItemEnum.collectionValueToQFilter(filterItem, "orgattr.fbasedataid.id")),
    INDUSTRY("industrycode", filterItem -> FilterItemEnum.collectionValueToQFilter(filterItem, "codeandname.id")),
    BUSINESS_SEGMENTS("bizsegment", filterItem -> FilterItemEnum.collectionValueToQFilter(filterItem, "orgattr.fbasedataid.id")),
    ID_LIST("ids", filterItem -> FilterItemEnum.collectionValueToQFilter(filterItem, "id")),
    ASSERT_ADDRESS("zcdz", filterItem -> {
        DynamicObjectCollection areas = (DynamicObjectCollection)filterItem.getValue();
        QFilter filter = null;
        for (DynamicObject area : areas) {
            String fullName = area.getString("fullname");
            if (null == filter) {
                filter = new QFilter("zcdz", "like", (Object)fullName);
                continue;
            }
            filter.or(new QFilter("zcdz", "like", (Object)fullName));
        }
        return filter;
    }),
    START_DATE("startdate", filterItem -> FilterItemEnum.startDateValueToQFilter(filterItem, ">=", "skssqq")),
    END_DATE("enddate", filterItem -> FilterItemEnum.endDateValueToQFilter(filterItem, "<", "skssqz")),
    DECLARATION_FORM_TYPE("tabletypefilter", filterItem -> {
        Object value = filterItem.getValue();
        if (value == null) {
            return null;
        }
        List types = Arrays.stream(value.toString().split(",")).filter(p -> StringUtils.isNotEmpty((CharSequence)p.trim())).collect(Collectors.toList());
        return new QFilter("type", "in", types);
    }),
    LEVY_TYPE("levytype", filterItem -> {
        Object value = filterItem.getValue();
        if (value == null) {
            return null;
        }
        List types = Arrays.stream(value.toString().split(",")).filter(v -> StringUtils.isNotEmpty((CharSequence)v)).collect(Collectors.toList());
        return new QFilter("levytype", "in", types);
    });

    private String filterItemPropName;
    private FilterConvert filterConvert;

    private FilterItemEnum(String filterItemPropName, FilterConvert filterConvert) {
        this.filterItemPropName = filterItemPropName;
        this.filterConvert = filterConvert;
    }

    public FilterConvert getFilterConvert() {
        return this.filterConvert;
    }

    public String getFilterItemPropName() {
        return this.filterItemPropName;
    }

    public static QFilter collectionValueToQFilter(FilterItemInfo filterItem, String qFilterProperty) {
        Object value = filterItem.getValue();
        if (value instanceof DynamicObjectCollection) {
            List ids = ((DynamicObjectCollection)value).stream().map(p -> p.getLong("id")).collect(Collectors.toList());
            return new QFilter(qFilterProperty, "in", ids);
        }
        if (value instanceof List) {
            return new QFilter(qFilterProperty, "in", value);
        }
        return null;
    }

    public static QFilter startDateValueToQFilter(FilterItemInfo filterItem, String cp, String qFilterProperty) {
        return new QFilter(qFilterProperty, cp, (Object)DateUtils.getFirstDateOfMonth((Date)((Date)filterItem.getValue())));
    }

    public static QFilter endDateValueToQFilter(FilterItemInfo filterItem, String cp, String qFilterProperty) {
        return new QFilter(qFilterProperty, cp, (Object)DateUtils.getLastDateOfMonth((Date)((Date)filterItem.getValue())));
    }

    public static FilterItemEnum getEnumByFilterItemPropName(String filterItemPropName) {
        for (FilterItemEnum value : FilterItemEnum.values()) {
            if (!filterItemPropName.equalsIgnoreCase(value.getFilterItemPropName())) continue;
            return value;
        }
        return null;
    }

    public static interface FilterConvert {
        public QFilter getQFilter(FilterItemInfo var1);
    }
}

