/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.common.enums;

public enum RangeLevelEnum {
    A("A", "1,2,3", "M|\u2014"),
    B("B", "1", "A,M|1,\u2014"),
    B1("B", "2,3", "M|\u2014"),
    M("M", "1,2,3", "A,B,C,D,M|\u2014,\u2014,\u2014,\u2014,\u2014"),
    C("C", "1", "B,A,M|1,2,\u2014"),
    C1("C", "2", "A,M|2,\u2014"),
    C2("C", "3", "M|\u2014"),
    D("D", "1", "C,B,A,M|1,2,3,\u2014"),
    D1("D", "2", "B,A,M|2,3,\u2014"),
    D2("D", "3", "A,M|3,\u2014"),
    K("", "1,2,3", "A,B,C,D,M|\u2014,\u2014,\u2014,\u2014,\u2014");

    private String creditLevel;
    private String rangeLevel;
    private String creditlevels;

    private RangeLevelEnum(String creditLevel, String rangeLevel, String creditlevels) {
        this.creditLevel = creditLevel;
        this.rangeLevel = rangeLevel;
        this.creditlevels = creditlevels;
    }

    public static String getlevelsByRangeLevel(String creditLevel, String rangeLevel) {
        for (RangeLevelEnum value : RangeLevelEnum.values()) {
            if (!value.getCreditLevel().equals(creditLevel) || !value.getRangeLevel().contains(rangeLevel)) continue;
            return value.getCreditlevels();
        }
        return "";
    }

    public String getCreditLevel() {
        return this.creditLevel;
    }

    public String getRangeLevel() {
        return this.rangeLevel;
    }

    public String getCreditlevels() {
        return this.creditlevels;
    }
}

