/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.common.enums;

import kd.taxc.bdtaxr.common.constant.BaseTaxCategory;
import kd.taxc.tctsa.common.util.TaxcategoryUtil;

public enum ShowDeclareEnum {
    ZZS(BaseTaxCategory.ZZS, "", "1", "zzs"),
    FJSF(1031650785223514112L, "", "2", "fjsf"),
    CSWHJSS(6L, "", "3", "cswhjss"),
    JYFJ(19L, "", "4", "jyffj"),
    DFJYFJ(20L, "", "5", "dfjyfj"),
    YHS(BaseTaxCategory.YHS, "yhs", "yhs", "yhs"),
    FCS(BaseTaxCategory.FCS, "fcs", "", "fcs,fcscztdsys"),
    CZTDSYS(BaseTaxCategory.CZTDSYS, "cztdsys", "", "cztdsys"),
    HJBHS(18L, "hbs", "", "hbs"),
    CCS(BaseTaxCategory.CCS, "ccs", "", "ccs"),
    QS(BaseTaxCategory.QS, "qs", "", "qs"),
    TDZZS(BaseTaxCategory.TDZZS, "tdzzs", "", "tdzzs"),
    YYS(17L, "yys", "", "yys"),
    GDZYS(15L, "gdzys", "", "gdzys"),
    ZYS(5L, "zys", "", "zys"),
    QYSDS(BaseTaxCategory.QYSDS, "", "", "qysds"),
    XFS(BaseTaxCategory.XFS, "", "", "xfs"),
    SZYS(BaseTaxCategory.SZYS, "", "", "szys"),
    GHJF(BaseTaxCategory.GHJF, "", "", "ghjf"),
    WHSYJSF(BaseTaxCategory.WHSYJSF, "", "", "whsyjsf"),
    DFSJJSJJ(1457213022396239872L, "", "", "sljsjj"),
    CJRJYBZJ(1494840676213682176L, "", "", "totf_cjrjybzj"),
    CLGZS(13L, "", "", "tvpt"),
    CZLJCLF(TaxcategoryUtil.CZLJCLF, "", "", "ljclf"),
    GHCBJ(BaseTaxCategory.GHCBJ, "", "", "ghcbj"),
    DWFHF(TaxcategoryUtil.DWFHF, "", "", "dwfhf");

    private Long taxTypeId;
    private String ccsId;
    private String zzsId;
    private String jndId;

    private ShowDeclareEnum(Long taxTypeId, String ccsId, String zzsId, String jndId) {
        this.taxTypeId = taxTypeId;
        this.ccsId = ccsId;
        this.zzsId = zzsId;
        this.jndId = jndId;
    }

    public static String getccsIdBytaxTypeId(Long taxTypeId) {
        for (ShowDeclareEnum value : ShowDeclareEnum.values()) {
            if (taxTypeId.compareTo(value.getTaxTypeId()) != 0) continue;
            return value.getCcsId();
        }
        return null;
    }

    public static String getjndIdBytaxTypeId(Long taxTypeId) {
        for (ShowDeclareEnum value : ShowDeclareEnum.values()) {
            if (taxTypeId.compareTo(value.getTaxTypeId()) != 0) continue;
            return value.getJndId();
        }
        return "0";
    }

    public static String getzzsIdBytaxTypeId(Long taxTypeId) {
        for (ShowDeclareEnum value : ShowDeclareEnum.values()) {
            if (taxTypeId.compareTo(value.getTaxTypeId()) != 0) continue;
            return value.getZzsId();
        }
        return null;
    }

    public Long getTaxTypeId() {
        return this.taxTypeId;
    }

    public void setTaxTypeId(Long taxTypeId) {
        this.taxTypeId = taxTypeId;
    }

    public String getCcsId() {
        return this.ccsId;
    }

    public void setCcsId(String ccsId) {
        this.ccsId = ccsId;
    }

    public String getZzsId() {
        return this.zzsId;
    }

    public void setZzsId(String zzsId) {
        this.zzsId = zzsId;
    }

    public String getJndId() {
        return this.jndId;
    }

    public void setJndId(String jndId) {
        this.jndId = jndId;
    }
}

