/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.common.enums;

import java.util.ArrayList;
import java.util.List;

public enum TaxTypeReportIdEnum {
    ZZS(1L, "zzs", 3),
    XFS(2L, "xfs", 6),
    QYSDS(3L, "qysds", 9),
    GRSDS(4L, "grsds", 12),
    ZYS(5L, "zys", 15),
    CSWHJSF(6L, "cswhjsf", 18),
    FCS(7L, "fcs", 21),
    YHS(8L, "yhs", 24),
    CZTDSYS(9L, "cztdsys", 27),
    TDZZS(10L, "tdzzs", 30),
    CCSYS(11L, "ccsys", 33),
    CPDS(12L, "cpds", 36),
    CLGZS(13L, "clgzs", 39),
    GS(14L, "gs", 42),
    GDZYS(15L, "gdzys", 45),
    QS(16L, "qs", 48),
    YYS(17L, "yys", 51),
    HBS(18L, "hbs", 54),
    JYFFJ(19L, "jyffj", 57),
    DFJYFFJ(20L, "dfjyxffj", 60),
    FJSF(1031650785223514112L, "fjsf", 63),
    SZYS(1307815368747699200L, "szys", 66),
    GFJF(1457212597437747200L, "gfjf", 69),
    DFSLJSJJ(1457213022396239872L, "dfsljsjj", 72),
    ZCLJCLF(1457213271932163072L, "zcljclf", 75),
    WHSYJSF(1457213499691257856L, "whsyjsf", 78),
    CJRJYBZJ(1549371200977776640L, "gfcbj", 81),
    TWFHF(1744188677522933760L, "twfhf", 84);

    private long taxType;
    private String taxTypeName;
    private int taxTypeIndex;

    private TaxTypeReportIdEnum(long taxType, String taxTypeName, int taxTypeIndex) {
        this.taxType = taxType;
        this.taxTypeName = taxTypeName;
        this.taxTypeIndex = taxTypeIndex;
    }

    public static String getTaxNameByType(long taxType) {
        for (TaxTypeReportIdEnum value : TaxTypeReportIdEnum.values()) {
            if (value.getTaxType() != taxType) continue;
            return value.getTaxTypeName();
        }
        return "";
    }

    public static int getTaxIndexByType(long taxType) {
        for (TaxTypeReportIdEnum value : TaxTypeReportIdEnum.values()) {
            if (value.getTaxType() != taxType) continue;
            return value.getTaxTypeIndex();
        }
        return 0;
    }

    public static List<Long> getAllPashTaxTypeIds() {
        ArrayList<Long> ids = new ArrayList<Long>(16);
        for (TaxTypeReportIdEnum value : TaxTypeReportIdEnum.values()) {
            ids.add(value.getTaxType());
        }
        return ids;
    }

    public long getTaxType() {
        return this.taxType;
    }

    public String getTaxTypeName() {
        return this.taxTypeName;
    }

    public int getTaxTypeIndex() {
        return this.taxTypeIndex;
    }

    public TaxTypeReportIdEnum setTaxTypeIndex(int taxTypeIndex) {
        this.taxTypeIndex = taxTypeIndex;
        return this;
    }
}

