/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.common.enums;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.taxc.bdtaxr.common.constant.BaseTaxCategory;
import kd.taxc.tctsa.common.entity.MultiLangEnumBridge;
import kd.taxc.tctsa.common.util.TaxcategoryUtil;

public enum TctsaSysTaxTypeEnum {
    TAX_ZZS(1L, "#40A9FF", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u589e\u503c\u7a0e", (String)"TctsaSysTaxTypeEnum_0", (String)"taxc-tctsa-common", (Object[])new Object[0]), "TctsaSysTaxTypeEnum_0", "taxc-tctsa-common")),
    TAX_XFS(2L, "#26C9C3", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u6d88\u8d39\u7a0e", (String)"TctsaSysTaxTypeEnum_1", (String)"taxc-tctsa-common", (Object[])new Object[0]), "TctsaSysTaxTypeEnum_1", "taxc-tctsa-common")),
    TAX_QYS(3L, "#73D13D", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e", (String)"TctsaSysTaxTypeEnum_2", (String)"taxc-tctsa-common", (Object[])new Object[0]), "TctsaSysTaxTypeEnum_2", "taxc-tctsa-common")),
    TAX_GRS(4L, "#FFC53D", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u4e2a\u4eba\u6240\u5f97\u7a0e", (String)"TctsaSysTaxTypeEnum_3", (String)"taxc-tctsa-common", (Object[])new Object[0]), "TctsaSysTaxTypeEnum_3", "taxc-tctsa-common")),
    TAX_ZYS(5L, "#FFA940", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u8d44\u6e90\u7a0e", (String)"TctsaSysTaxTypeEnum_4", (String)"taxc-tctsa-common", (Object[])new Object[0]), "TctsaSysTaxTypeEnum_4", "taxc-tctsa-common")),
    TAX_CSJS(6L, "#F57582", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u57ce\u5e02\u7ef4\u62a4\u5efa\u8bbe\u7a0e", (String)"TctsaSysTaxTypeEnum_5", (String)"taxc-tctsa-common", (Object[])new Object[0]), "TctsaSysTaxTypeEnum_5", "taxc-tctsa-common")),
    TAX_FCS(7L, "#F273B5", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u623f\u4ea7\u7a0e", (String)"TctsaSysTaxTypeEnum_6", (String)"taxc-tctsa-common", (Object[])new Object[0]), "TctsaSysTaxTypeEnum_6", "taxc-tctsa-common")),
    TAX_YHS(8L, "#9F69E2", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u5370\u82b1\u7a0e", (String)"TctsaSysTaxTypeEnum_7", (String)"taxc-tctsa-common", (Object[])new Object[0]), "TctsaSysTaxTypeEnum_7", "taxc-tctsa-common")),
    TAX_CZTDS(9L, "#6682F5", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u57ce\u9547\u571f\u5730\u4f7f\u7528\u7a0e", (String)"TctsaSysTaxTypeEnum_8", (String)"taxc-tctsa-common", (Object[])new Object[0]), "TctsaSysTaxTypeEnum_8", "taxc-tctsa-common")),
    TAX_TDZZS(10L, "#40A9FF", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u571f\u5730\u589e\u503c\u7a0e", (String)"TctsaSysTaxTypeEnum_9", (String)"taxc-tctsa-common", (Object[])new Object[0]), "TctsaSysTaxTypeEnum_9", "taxc-tctsa-common")),
    TAX_CCS(11L, "#26C9C3", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u8f66\u8239\u7a0e", (String)"TctsaSysTaxTypeEnum_10", (String)"taxc-tctsa-common", (Object[])new Object[0]), "TctsaSysTaxTypeEnum_10", "taxc-tctsa-common")),
    TAX_CPDS(12L, "#73D13D", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u8239\u8236\u5428\u7a0e", (String)"TctsaSysTaxTypeEnum_11", (String)"taxc-tctsa-common", (Object[])new Object[0]), "TctsaSysTaxTypeEnum_11", "taxc-tctsa-common")),
    TAX_CLGZS(13L, "#FFC53D", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u8f66\u8f86\u8d2d\u7f6e\u7a0e", (String)"TctsaSysTaxTypeEnum_12", (String)"taxc-tctsa-common", (Object[])new Object[0]), "TctsaSysTaxTypeEnum_12", "taxc-tctsa-common")),
    TAX_GS(14L, "#FFC53D", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u5173\u7a0e", (String)"TctsaSysTaxTypeEnum_13", (String)"taxc-tctsa-common", (Object[])new Object[0]), "TctsaSysTaxTypeEnum_13", "taxc-tctsa-common")),
    AX_GDZYS(15L, "#FFA940", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u8015\u5730\u5360\u7528\u7a0e", (String)"TctsaSysTaxTypeEnum_14", (String)"taxc-tctsa-common", (Object[])new Object[0]), "TctsaSysTaxTypeEnum_14", "taxc-tctsa-common")),
    AX_QS(16L, "#F57582", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u5951\u7a0e", (String)"TctsaSysTaxTypeEnum_15", (String)"taxc-tctsa-common", (Object[])new Object[0]), "TctsaSysTaxTypeEnum_15", "taxc-tctsa-common")),
    TAX_YYS(17L, "#F273B5", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u70df\u53f6\u7a0e", (String)"TctsaSysTaxTypeEnum_16", (String)"taxc-tctsa-common", (Object[])new Object[0]), "TctsaSysTaxTypeEnum_16", "taxc-tctsa-common")),
    TAX_HBS(18L, "#9F69E2", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u73af\u5883\u4fdd\u62a4\u7a0e", (String)"TctsaSysTaxTypeEnum_17", (String)"taxc-tctsa-common", (Object[])new Object[0]), "TctsaSysTaxTypeEnum_17", "taxc-tctsa-common")),
    TAX_FJS(1031650785223514112L, "#6682F5", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u9644\u52a0\u7a0e\u8d39", (String)"TctsaSysTaxTypeEnum_18", (String)"taxc-tctsa-common", (Object[])new Object[0]), "TctsaSysTaxTypeEnum_18", "taxc-tctsa-common")),
    TAX_JYFFJ(19L, "#40A9FF", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u6559\u80b2\u8d39\u9644\u52a0", (String)"TctsaSysTaxTypeEnum_19", (String)"taxc-tctsa-common", (Object[])new Object[0]), "TctsaSysTaxTypeEnum_19", "taxc-tctsa-common")),
    TAX_DFJYFJ(20L, "#26C9C3", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u5730\u65b9\u6559\u80b2\u8d39\u9644\u52a0", (String)"TctsaSysTaxTypeEnum_20", (String)"taxc-tctsa-common", (Object[])new Object[0]), "TctsaSysTaxTypeEnum_20", "taxc-tctsa-common")),
    TAX_SZYS(1307815368747699200L, "#73D13D", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u6c34\u8d44\u6e90\u7a0e", (String)"TctsaSysTaxTypeEnum_21", (String)"taxc-tctsa-common", (Object[])new Object[0]), "TctsaSysTaxTypeEnum_21", "taxc-tctsa-common")),
    GHJF(BaseTaxCategory.GHJF, "#40A9FF", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u5de5\u4f1a\u7ecf\u8d39", (String)"TctsaSysTaxTypeEnum_22", (String)"taxc-tctsa-common", (Object[])new Object[0]), "TctsaSysTaxTypeEnum_21", "taxc-tctsa-common")),
    GHCBJ(BaseTaxCategory.GHCBJ, "#26C9C3", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u5de5\u4f1a\u7b79\u5907\u91d1", (String)"TctsaSysTaxTypeEnum_23", (String)"taxc-tctsa-common", (Object[])new Object[0]), "TctsaSysTaxTypeEnum_21", "taxc-tctsa-common")),
    DWFHF(TaxcategoryUtil.DWFHF, "#9F69E2", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u5824\u56f4\u9632\u62a4\u8d39", (String)"TctsaSysTaxTypeEnum_24", (String)"taxc-tctsa-common", (Object[])new Object[0]), "TctsaSysTaxTypeEnum_21", "taxc-tctsa-common")),
    DFSLJSJJ(TaxcategoryUtil.DFSLJSJJ, "#73D13D", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u5730\u65b9\u6c34\u5229\u5efa\u8bbe\u57fa\u91d1", (String)"TctsaSysTaxTypeEnum_25", (String)"taxc-tctsa-common", (Object[])new Object[0]), "TctsaSysTaxTypeEnum_21", "taxc-tctsa-common")),
    CZLJCLF(TaxcategoryUtil.CZLJCLF, "#6682F5", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u57ce\u9547\u5783\u573e\u5904\u7406\u8d39", (String)"TctsaSysTaxTypeEnum_26", (String)"taxc-tctsa-common", (Object[])new Object[0]), "TctsaSysTaxTypeEnum_21", "taxc-tctsa-common")),
    WHSYJSF(1457213499691257856L, "#F57582", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u6587\u5316\u4e8b\u4e1a\u5efa\u8bbe\u8d39", (String)"TctsaSysTaxTypeEnum_27", (String)"taxc-tctsa-common", (Object[])new Object[0]), "TctsaSysTaxTypeEnum_27", "taxc-tctsa-common"));

    private long taxType;
    private String color;
    private MultiLangEnumBridge bridge;

    private TctsaSysTaxTypeEnum(long taxType, String color, MultiLangEnumBridge bridge) {
        this.taxType = taxType;
        this.color = color;
        this.bridge = bridge;
    }

    public static String getTaxNameByType(long taxType) {
        for (TctsaSysTaxTypeEnum value : TctsaSysTaxTypeEnum.values()) {
            if (value.getTaxType() != taxType) continue;
            return value.getTaxTypeName();
        }
        return "";
    }

    public static String getColorByType(long taxType) {
        for (TctsaSysTaxTypeEnum value : TctsaSysTaxTypeEnum.values()) {
            if (value.getTaxType() != taxType) continue;
            return value.getColor();
        }
        return "";
    }

    public long getTaxType() {
        return this.taxType;
    }

    public String getColor() {
        return this.color;
    }

    public String getTaxTypeName() {
        return this.bridge.loadKDString();
    }

    public static List<Long> getTypeIdList() {
        return Arrays.asList(TctsaSysTaxTypeEnum.values()).stream().map(s -> s.getTaxType()).collect(Collectors.toList());
    }

    public static Long getTaxTypeId(String taxName) {
        for (TctsaSysTaxTypeEnum value : TctsaSysTaxTypeEnum.values()) {
            if (!value.bridge.getDescription().equals(taxName)) continue;
            return value.taxType;
        }
        return null;
    }
}

