/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.common.enums;

import java.util.Arrays;
import kd.bos.dataentity.resource.ResManager;
import kd.taxc.bdtaxr.common.constant.BaseTaxCategory;
import kd.taxc.tctsa.common.util.TaxcategoryUtil;

public enum TysbDeclareEnum {
    GHJF(BaseTaxCategory.GHJF, "ghjf", new String[]{ResManager.loadKDString((String)"\u5de5\u4f1a\u7ecf\u8d39", (String)"TysbDeclareEnum_0", (String)"taxc-tctsa-common", (Object[])new Object[0])}),
    GHCBJ(BaseTaxCategory.GHCBJ, "ghcbj", new String[]{ResManager.loadKDString((String)"\u5de5\u4f1a\u7b79\u5907\u91d1", (String)"TysbDeclareEnum_1", (String)"taxc-tctsa-common", (Object[])new Object[0])}),
    DWFHF(TaxcategoryUtil.DWFHF, "dwfhf", new String[]{ResManager.loadKDString((String)"\u5824\u56f4\u9632\u62a4\u8d39", (String)"TysbDeclareEnum_2", (String)"taxc-tctsa-common", (Object[])new Object[0])}),
    DFSLJSJJ(TaxcategoryUtil.DFSLJSJJ, "sljsjj", new String[]{ResManager.loadKDString((String)"\u5730\u65b9\u6c34\u5229\u5efa\u8bbe\u57fa\u91d1", (String)"TysbDeclareEnum_3", (String)"taxc-tctsa-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6c34\u5229\u5efa\u8bbe\u57fa\u91d1", (String)"TysbDeclareEnum_4", (String)"taxc-tctsa-common", (Object[])new Object[0])}),
    CZLJCLF(TaxcategoryUtil.CZLJCLF, "ljclf", new String[]{ResManager.loadKDString((String)"\u57ce\u9547\u5783\u573e\u5904\u7406\u8d39", (String)"TysbDeclareEnum_5", (String)"taxc-tctsa-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5783\u573e\u5904\u7406\u8d39", (String)"TysbDeclareEnum_6", (String)"taxc-tctsa-common", (Object[])new Object[0])});

    private Long taxTypeId;
    private String taxitemId;
    private String[] zspmName;

    private TysbDeclareEnum(Long taxTypeId, String taxitemId, String[] zspmName) {
        this.taxTypeId = taxTypeId;
        this.zspmName = zspmName;
        this.taxitemId = taxitemId;
    }

    public static Long getTaxType(String zspmName) {
        for (TysbDeclareEnum value : TysbDeclareEnum.values()) {
            if (!Arrays.asList(value.getZspmName()).contains(zspmName)) continue;
            return value.getTaxTypeId();
        }
        return 0L;
    }

    public static String[] getzspmNameByTaxId(Long taxTypeId) {
        for (TysbDeclareEnum value : TysbDeclareEnum.values()) {
            if (taxTypeId == null || taxTypeId.compareTo(value.getTaxTypeId()) != 0) continue;
            return value.getZspmName();
        }
        return new String[0];
    }

    public static String gettaxitemIdByzspm(String zspmName) {
        for (TysbDeclareEnum value : TysbDeclareEnum.values()) {
            if (!Arrays.asList(value.getZspmName()).contains(zspmName)) continue;
            return value.getTaxitemId();
        }
        return null;
    }

    public Long getTaxTypeId() {
        return this.taxTypeId;
    }

    public void setTaxTypeId(Long taxTypeId) {
        this.taxTypeId = taxTypeId;
    }

    public String[] getZspmName() {
        return this.zspmName;
    }

    public void setZspmName(String[] zspmName) {
        this.zspmName = zspmName;
    }

    public String getTaxitemId() {
        return this.taxitemId;
    }

    public void setTaxitemId(String taxitemId) {
        this.taxitemId = taxitemId;
    }
}

