/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.tctsa.common.entity.TsjsbTaxReportWriteBackBean;
import kd.taxc.tctsa.common.json.JsonUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class FixedFillHandlerHelper {
    private static final Log LOGGER = LogFactory.getLog(FixedFillHandlerHelper.class);

    public static void handlerFixedFillDataStatusChange(DynamicObject[] dataEntities, String billstatus) {
        LOGGER.info("\u5f00\u59cb\u5904\u7406\u6570\u636e:start handler,\u72b6\u6001\u4e3a" + billstatus);
        ArrayList<TsjsbTaxReportWriteBackBean> tsjsbWBBList = new ArrayList<TsjsbTaxReportWriteBackBean>(16);
        for (DynamicObject entity : dataEntities) {
            Object pkValue = entity.getPkValue();
            DynamicObject declare = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"tctsa_fixed_filling_query");
            tsjsbWBBList.add(new TsjsbTaxReportWriteBackBean(declare.getDate("skssqq"), declare.getDate("skssqz"), "1", declare.getDynamicObject("org").getLong("id"), declare.getDynamicObject("taxtype").getString("id"), declare.getLong("id"), billstatus, "1", declare.getString("tstatus"), declare.getLong("sbbid")));
        }
        LOGGER.info("\u5f00\u59cb\u8c03\u7528\u63a5\u53e3:start handler,\u72b6\u6001\u4e3a" + billstatus);
        DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctsa", (String)"TjsjbTaxReportWriteBack", (String)"executorTjsjbTaxReportWriteBack", (Object[])new Object[]{JsonUtil.toJson(tsjsbWBBList)});
    }

    public static void executeBatchFixedFillOperate(List<Long> ids, String operationKey, IFormView view) {
        DynamicObject[] fixedFillings;
        Boolean haveSingleFlow = FixedFillHandlerHelper.haveFlow(false);
        Boolean haveBatchFlow = FixedFillHandlerHelper.haveFlow(true);
        if (haveBatchFlow.booleanValue() && haveSingleFlow.booleanValue()) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u5355\u4e2a\u5ba1\u6279\u6d41\u548c\u6279\u91cf\u5ba1\u6279\u6d41\u914d\u7f6e\u91cd\u590d\u3002", (String)"FixedFillHandlerHelper_0", (String)"taxc-tctsa-common", (Object[])new Object[0]));
            return;
        }
        for (DynamicObject dyo : fixedFillings = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tctsa_fixed_filling_query"))) {
            String errorMsg = FixedFillHandlerHelper.validateBillstatus(operationKey, dyo.getString("billstatus"));
            if (!StringUtils.isNotEmpty((CharSequence)errorMsg)) continue;
            view.showTipNotification(errorMsg);
            return;
        }
        String billStatus = fixedFillings[0].getString("billstatus");
        Map<String, List<DynamicObject>> groupMap = Arrays.stream(fixedFillings).collect(Collectors.groupingBy(o -> o.getString("org.id") + "#" + o.getString("skssqq") + "#" + o.getString("skssqz")));
        boolean checkResult = true;
        OperationResult result = null;
        for (Map.Entry<String, List<DynamicObject>> entry : groupMap.entrySet()) {
            OperationResult localResult;
            DynamicObject[] matchAggrList;
            List<DynamicObject> fixedList = entry.getValue();
            if (CollectionUtils.isEmpty(fixedList)) continue;
            List<Long> groupIds = fixedList.stream().map(m -> m.getLong("id")).collect(Collectors.toList());
            QFilter matchFilter = new QFilter("billstatus", "=", (Object)billStatus).and("org", "=", fixedList.get(0).get("org.id")).and("tskssqq", "=", fixedList.get(0).get("skssqq")).and("tskssqz", "=", fixedList.get(0).get("skssqz")).and("entryentity.fixedfilling", "in", groupIds);
            DynamicObject[] opMatchAggrList = new DynamicObject[]{};
            for (DynamicObject dyo : matchAggrList = BusinessDataServiceHelper.load((String)"tctsa_fixed_filling_aggr", (String)MetadataUtil.getAllSubFieldString((String)"tctsa_fixed_filling_aggr"), (QFilter[])matchFilter.toArray())) {
                List fixedFillingIds = dyo.getDynamicObjectCollection("entryentity").stream().map(m -> m.getLong("fixedfilling.id")).sorted().collect(Collectors.toList());
                boolean equalCollection = CollectionUtils.isEqualCollection(groupIds, fixedFillingIds);
                if (!equalCollection) continue;
                opMatchAggrList = new DynamicObject[]{dyo};
                break;
            }
            if (opMatchAggrList.length == 0 && Arrays.asList("unsubmit", "audit", "unaudit").contains(operationKey)) {
                List workflownoList = fixedList.stream().map(m -> m.getString("workflowno")).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
                opMatchAggrList = BusinessDataServiceHelper.load((String)"tctsa_fixed_filling_aggr", (String)MetadataUtil.getAllSubFieldString((String)"tctsa_fixed_filling_aggr"), (QFilter[])new QFilter("billstatus", "=", (Object)billStatus).and("billno", "in", workflownoList).toArray());
            }
            if (opMatchAggrList.length == 0) {
                opMatchAggrList = new DynamicObject[]{FixedFillHandlerHelper.addNewBatchFixedFillingAggr(groupIds, fixedList, billStatus)};
            }
            if ((localResult = OperationServiceHelper.executeOperate((String)operationKey, (String)"tctsa_fixed_filling_aggr", (DynamicObject[])opMatchAggrList, (OperateOption)OperateOption.create())).isSuccess()) continue;
            checkResult = false;
            if (result == null) {
                result = localResult;
                continue;
            }
            result.mergeOperateResult(localResult);
        }
        if (!checkResult) {
            view.showOperationResult(result);
        }
    }

    private static DynamicObject addNewBatchFixedFillingAggr(List<Long> ids, List<DynamicObject> fixedList, String billStatus) {
        DynamicObject object = fixedList.get(0);
        DynamicObject fixedFillingAggr = BusinessDataServiceHelper.newDynamicObject((String)"tctsa_fixed_filling_aggr");
        fixedFillingAggr.set("billstatus", (Object)billStatus);
        fixedFillingAggr.set("org", object.get("org"));
        fixedFillingAggr.set("tskssqq", object.get("skssqq"));
        fixedFillingAggr.set("tskssqz", object.get("skssqz"));
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        String number = codeRuleService.getNumber("tctsa_fixed_filling_aggr", fixedFillingAggr, null);
        fixedFillingAggr.set("billno", (Object)number);
        DynamicObjectCollection entryentity = fixedFillingAggr.getDynamicObjectCollection("entryentity");
        for (Long id : ids) {
            DynamicObject dynamicObject = entryentity.addNew();
            dynamicObject.set("fixedfilling", (Object)id);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{fixedFillingAggr});
        return fixedFillingAggr;
    }

    public static Boolean haveFlow(Boolean isBatch) {
        String entityname = isBatch != false ? "tctsa_fixed_filling_aggr" : "tctsa_fixed_filling_query";
        QFilter qFilter1 = new QFilter("entrabill", "=", (Object)entityname);
        QFilter qFilter2 = new QFilter("enable", "=", (Object)"enable");
        DynamicObject batchFlow = QueryServiceHelper.queryOne((String)"wf_processdefinition", (String)"id", (QFilter[])new QFilter[]{qFilter1, qFilter2});
        return batchFlow != null;
    }

    public static String validateBillstatus(String operateKey, String billstatus) {
        String errorMsg = "";
        if (!"A".equals(billstatus) && "delete".equals(operateKey)) {
            errorMsg = ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u72b6\u6001\u7684\u6570\u636e\u624d\u5141\u8bb8\u5220\u9664\u3002", (String)"FixedFillHandlerHelper_1", (String)"taxc-tctsa-common", (Object[])new Object[0]);
        } else if (!"A".equals(billstatus) && "submit".equals(operateKey)) {
            errorMsg = ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u72b6\u6001\u7684\u6570\u636e\u624d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"FixedFillHandlerHelper_2", (String)"taxc-tctsa-common", (Object[])new Object[0]);
        } else if (!"B".equals(billstatus) && "unsubmit".equals(operateKey)) {
            errorMsg = ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5fc5\u987b\u662f\u5df2\u63d0\u4ea4\u624d\u80fd\u64a4\u9500\u3002", (String)"FixedFillHandlerHelper_3", (String)"taxc-tctsa-common", (Object[])new Object[0]);
        } else if (!"B".equals(billstatus) && "audit".equals(operateKey)) {
            errorMsg = ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\u624d\u80fd\u5ba1\u6838\u3002", (String)"FixedFillHandlerHelper_4", (String)"taxc-tctsa-common", (Object[])new Object[0]);
        } else if (!"C".equals(billstatus) && "unaudit".equals(operateKey)) {
            errorMsg = ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u662f\u5df2\u5ba1\u6838\u7684\u6570\u636e\u624d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"FixedFillHandlerHelper_5", (String)"taxc-tctsa-common", (Object[])new Object[0]);
        }
        return errorMsg;
    }
}

