/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bos.view.ViewDataServiceHelper;
import kd.taxc.tctsa.common.enums.TreeShowTypeEnum;
import kd.taxc.tctsa.common.helper.OrgServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class OrgTreeReport {
    public static ReportQueryParam queryOrgTree(ReportQueryParam reportQueryParam) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        List<Long> orgList = new ArrayList<Long>();
        String showtype = "";
        for (FilterItemInfo filterItem : filterInfo.getFilterItems()) {
            switch (filterItem.getPropName()) {
                case "orgs": {
                    orgList = (List)filterItem.getValue();
                    break;
                }
                case "showtype": {
                    showtype = filterItem.getValue().toString();
                    break;
                }
            }
        }
        if (CollectionUtils.isNotEmpty(orgList)) {
            return OrgTreeReport.noEmptyOrg(showtype, reportQueryParam, orgList);
        }
        return OrgTreeReport.emptyorg(showtype, reportQueryParam);
    }

    private static ReportQueryParam emptyorg(String showtype, ReportQueryParam reportQueryParam) {
        OrgTreeReport.returnparamsShow(reportQueryParam, Boolean.TRUE);
        if (!showtype.equals(TreeShowTypeEnum.TILE.getCode())) {
            List<Long> neworgList = OrgServiceHelper.getOrgListHasPermissionAll();
            return OrgTreeReport.returnparams(reportQueryParam, neworgList);
        }
        return reportQueryParam;
    }

    private static ReportQueryParam noEmptyOrg(String showtype, ReportQueryParam reportQueryParam, List<Long> orgList) {
        if (showtype.equals(TreeShowTypeEnum.STEPINCLUDESSUB.getCode())) {
            List<Long> neworgList = new ArrayList<Long>();
            TaxResult orgresulet = ViewDataServiceHelper.getTaxOrgFilterByIdAndPer(orgList);
            if (orgresulet.isSuccess() && orgresulet.getData() != null) {
                neworgList = Arrays.stream((Object[])orgresulet.getData()).map(v -> v.getLong("org.id")).collect(Collectors.toList());
            }
            OrgTreeReport.returnparamsShow(reportQueryParam, Boolean.TRUE);
            return OrgTreeReport.returnparams(reportQueryParam, neworgList);
        }
        OrgTreeReport.returnparamsShow(reportQueryParam, Boolean.FALSE);
        return reportQueryParam;
    }

    private static ReportQueryParam returnparams(ReportQueryParam reportQueryParam, List<Long> neworgList) {
        List itemInfos = reportQueryParam.getFilter().getFilterItems();
        itemInfos.removeIf(item -> item.getPropName().equals("orgs"));
        FilterItemInfo dimensionInfo = new FilterItemInfo();
        dimensionInfo.setPropName("orgs");
        dimensionInfo.setValue(neworgList);
        reportQueryParam.getFilter().getFilterItems().add(dimensionInfo);
        return reportQueryParam;
    }

    private static ReportQueryParam returnparamsShow(ReportQueryParam reportQueryParam, Boolean showFlag) {
        List itemInfos = reportQueryParam.getFilter().getFilterItems();
        itemInfos.removeIf(item -> item.getPropName().equals("showFlag"));
        FilterItemInfo dimensionInfo = new FilterItemInfo();
        dimensionInfo.setPropName("showFlag");
        dimensionInfo.setValue((Object)showFlag);
        reportQueryParam.getFilter().getFilterItems().add(dimensionInfo);
        return reportQueryParam;
    }
}

