/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.ORM;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bos.view.ViewDataServiceHelper;
import kd.taxc.tctsa.common.entity.RowMetaMsgInfo;
import kd.taxc.tctsa.common.util.BizCommomUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;

public class OrgTreeReportDataDetailHelper {
    public static DataSet getTile(String className, DataSet reportdataSet) {
        List<RowMetaMsgInfo> infolist = OrgTreeReportDataDetailHelper.createRowMeta(reportdataSet.getRowMeta());
        OrgTreeReportDataDetailHelper.addField(infolist);
        ArrayList<Object[]> coll = new ArrayList<Object[]>();
        for (Row row : reportdataSet) {
            Object[] obj = new Object[infolist.size()];
            obj[0] = 0;
            obj[1] = OrgTreeReportDataDetailHelper.generateUniqueLong(0);
            obj[2] = "";
            obj[3] = 0;
            for (int i = 4; i < infolist.size(); ++i) {
                RowMetaMsgInfo msgInfo2 = infolist.get(i);
                obj[i] = row.get(msgInfo2.getDisplayField());
            }
            coll.add(obj);
        }
        return OrgTreeReportDataDetailHelper.resultDataSet(infolist, className, coll);
    }

    public static DataSet getStep(Boolean showFlag, Map<String, Object> colorTotal, List<String> sumField, List<Long> orgIds, String className, DataSet reportdataSet) {
        Object cillllist = new DynamicObjectCollection();
        TaxResult orgresulet = ViewDataServiceHelper.getTaxOrgFilterByIdAndPer(orgIds);
        if (orgresulet.isSuccess() && orgresulet.getData() != null) {
            cillllist = Arrays.asList((Object[])orgresulet.getData());
        }
        List<RowMetaMsgInfo> infolist = OrgTreeReportDataDetailHelper.createRowMeta(reportdataSet.getRowMeta());
        DynamicObjectCollection dynamicObjects = ORM.create().toPlainDynamicObjectCollection(reportdataSet);
        ArrayList<Object[]> coll = new ArrayList<Object[]>();
        OrgTreeReportDataDetailHelper.addField(infolist);
        OrgTreeReportDataDetailHelper.createdata(showFlag, (List<DynamicObject>)cillllist, dynamicObjects, infolist, coll);
        OrgTreeReportDataDetailHelper.changeTree(coll);
        OrgTreeReportDataDetailHelper.sumTree(infolist, sumField, coll);
        if (CollectionUtils.isNotEmpty(coll)) {
            OrgTreeReportDataDetailHelper.setTotalRow(sumField, infolist, colorTotal, coll);
        }
        Collections.sort(coll, (o1, o2) -> {
            Integer d1 = Integer.parseInt(o1[3].toString());
            Integer d2 = Integer.parseInt(o2[3].toString());
            return d1 - d2;
        });
        return OrgTreeReportDataDetailHelper.resultDataSet(infolist, className, coll);
    }

    private static void setTotalRow(List<String> sumField, List<RowMetaMsgInfo> infolist, Map<String, Object> colorTotal, List<Object[]> coll) {
        Object[] obj = new Object[infolist.size()];
        obj[0] = 0;
        String rowid = OrgTreeReportDataDetailHelper.generateUniqueLong(0);
        obj[1] = rowid;
        obj[2] = false;
        obj[3] = Integer.MAX_VALUE;
        obj[4] = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"OrgTreeReportDataDetailHelper_0", (String)"taxc-tctsa-common", (Object[])new Object[0]);
        List totalcoll = coll.stream().filter(v -> v[0].equals(0)).collect(Collectors.toList());
        for (int s = 4; s < infolist.size(); ++s) {
            RowMetaMsgInfo msgInfo2 = infolist.get(s);
            if (colorTotal.containsKey(msgInfo2.getDisplayField())) {
                obj[s] = colorTotal.get(msgInfo2.getDisplayField());
            }
            if (!sumField.contains(msgInfo2.getDisplayField())) continue;
            int finalI = s;
            double sum = totalcoll.stream().filter(v -> v[finalI] != "" && v[finalI] != null).map(v -> v[finalI].toString()).collect(Collectors.toList()).stream().mapToDouble(Double::parseDouble).sum();
            obj[s] = BigDecimal.valueOf(sum).setScale(2, 4);
        }
        coll.add(obj);
    }

    private static void createdata(Boolean showFlag, List<DynamicObject> cillllist, DynamicObjectCollection dynamicObjects, List<RowMetaMsgInfo> infolist, List<Object[]> coll) {
        List<Long> upOrgs = OrgTreeReportDataDetailHelper.upOrgAll(cillllist, dynamicObjects);
        cillllist = cillllist.stream().sorted(Comparator.comparing(v -> v.getInt("level"))).collect(Collectors.toList());
        Collections.reverse(cillllist);
        Map<Long, List<DynamicObject>> cillllistMap = cillllist.stream().filter(m -> m.get("parent") != null).collect(Collectors.groupingBy(o -> o.getLong("parent.id")));
        for (DynamicObject dynamicObject : cillllist) {
            List<DynamicObject> list = dynamicObjects.stream().filter(v -> v.getLong("orgid") == row.getLong("org.id")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(list)) {
                if (!showFlag.booleanValue() || !upOrgs.contains(dynamicObject.getLong("org.id"))) continue;
                OrgTreeReportDataDetailHelper.setParent(infolist, dynamicObject, coll);
                continue;
            }
            if (!dynamicObject.getBoolean("isleaf")) {
                ArrayList<Long> totalChildOrgIds = new ArrayList<Long>(256);
                OrgTreeReportDataDetailHelper.getChillOrgIds(dynamicObject.getLong("org.id"), totalChildOrgIds, cillllistMap);
                List subdatalist = dynamicObjects.stream().filter(v -> totalChildOrgIds.contains(v.getLong("orgid"))).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(subdatalist) || list.size() > 1) {
                    OrgTreeReportDataDetailHelper.setParentAndChild(infolist, dynamicObject, list, coll);
                    continue;
                }
                OrgTreeReportDataDetailHelper.setObjectIsgroupnode(infolist, dynamicObject, list, coll);
                continue;
            }
            if (list.size() > 1) {
                dynamicObject.set("isleaf", (Object)Boolean.FALSE);
                OrgTreeReportDataDetailHelper.setParent(infolist, dynamicObject, coll);
                OrgTreeReportDataDetailHelper.setChild(infolist, dynamicObject, list, coll, dynamicObject.getLong("org.id"));
                continue;
            }
            OrgTreeReportDataDetailHelper.setObjectIsgroupnode(infolist, dynamicObject, list, coll);
        }
    }

    private static void getChillOrgIds(Long orgId, List<Long> chilldIds, Map<Long, List<DynamicObject>> cillllistMap) {
        List list = cillllistMap.getOrDefault(orgId, new ArrayList());
        List ids = list.stream().map(m -> m.getLong("org.id")).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ids)) {
            chilldIds.addAll(ids);
            for (Long id : ids) {
                OrgTreeReportDataDetailHelper.getChillOrgIds(id, chilldIds, cillllistMap);
            }
        }
    }

    private static void setParentAndChild(List<RowMetaMsgInfo> infolist, DynamicObject row, List<DynamicObject> list, List<Object[]> coll) {
        OrgTreeReportDataDetailHelper.setParent(infolist, row, coll);
        OrgTreeReportDataDetailHelper.setChild(infolist, row, list, coll);
    }

    private static void setParent(List<RowMetaMsgInfo> infolist, DynamicObject row, List<Object[]> coll) {
        Object rowid;
        Object[] obj = new Object[infolist.size()];
        Object pid = row.get("parent.id");
        obj[0] = pid == null ? Long.valueOf(0L) : pid;
        obj[1] = rowid = row.get("org.id");
        Boolean isgroupnode = !row.getBoolean("isleaf");
        obj[2] = isgroupnode;
        obj[3] = row.get("sortcode");
        obj[4] = row.getLocaleString("org.name").getLocaleValue();
        coll.add(obj);
    }

    private static void setChild(List<RowMetaMsgInfo> infolist, DynamicObject row, List<DynamicObject> list, List<Object[]> coll) {
        for (int j = 0; j < list.size(); ++j) {
            Object pid;
            Object[] obj = new Object[infolist.size()];
            obj[0] = pid = row.get("org.id");
            String rowid = OrgTreeReportDataDetailHelper.generateUniqueLong(pid);
            obj[1] = rowid;
            obj[2] = false;
            obj[3] = row.get("sortcode");
            for (int i = 4; i < infolist.size(); ++i) {
                RowMetaMsgInfo msgInfo2 = infolist.get(i);
                obj[i] = list.get(j).get(msgInfo2.getDisplayField());
            }
            coll.add(obj);
        }
    }

    private static void setChild(List<RowMetaMsgInfo> infolist, DynamicObject row, List<DynamicObject> list, List<Object[]> coll, Long pid) {
        for (int j = 0; j < list.size(); ++j) {
            Object[] obj = new Object[infolist.size()];
            obj[0] = pid;
            String rowid = OrgTreeReportDataDetailHelper.generateUniqueLong(pid);
            obj[1] = rowid;
            obj[2] = false;
            obj[3] = row.get("sortcode");
            for (int i = 4; i < infolist.size(); ++i) {
                RowMetaMsgInfo msgInfo2 = infolist.get(i);
                obj[i] = list.get(j).get(msgInfo2.getDisplayField());
            }
            coll.add(obj);
        }
    }

    private static void setObjectIsgroupnode(List<RowMetaMsgInfo> infolist, DynamicObject row, List<DynamicObject> list, List<Object[]> coll) {
        for (int j = 0; j < list.size(); ++j) {
            Object pid;
            Object[] obj = new Object[infolist.size()];
            obj[0] = pid = row.get("parent.id");
            String rowid = OrgTreeReportDataDetailHelper.generateUniqueLong(pid);
            obj[1] = rowid;
            obj[2] = false;
            obj[3] = row.get("sortcode") != null ? Long.valueOf(row.getLong("sortcode") + 1L) : row.get("sortcode");
            for (int i = 4; i < infolist.size(); ++i) {
                RowMetaMsgInfo msgInfo2 = infolist.get(i);
                obj[i] = list.get(j).get(msgInfo2.getDisplayField());
            }
            coll.add(obj);
        }
    }

    private static List<Long> upOrgAll(List<DynamicObject> cillllist, DynamicObjectCollection dynamicObjects) {
        List<Long> insertList = dynamicObjects.stream().map(v -> v.getLong("orgid")).collect(Collectors.toList());
        ArrayList<Long> returnList = new ArrayList<Long>();
        OrgTreeReportDataDetailHelper.upOrg(insertList, returnList, cillllist);
        return returnList.stream().distinct().collect(Collectors.toList());
    }

    private static void upOrg(List<Long> insertList, List<Long> returnList, List<DynamicObject> cillllist) {
        List<Long> parentlist = cillllist.stream().filter(v -> insertList.contains(v.get("org.id"))).map(v -> v.getLong("parent.id")).distinct().collect(Collectors.toList());
        returnList.addAll(parentlist);
        if (CollectionUtils.isNotEmpty(parentlist)) {
            OrgTreeReportDataDetailHelper.upOrg(parentlist, returnList, cillllist);
        }
    }

    private static void addField(List<RowMetaMsgInfo> infolist) {
        RowMetaMsgInfo msg3 = new RowMetaMsgInfo();
        msg3.setDataType((DataType)DataType.LongType);
        msg3.setDisplayField("pid");
        infolist.add(0, msg3);
        RowMetaMsgInfo msg2 = new RowMetaMsgInfo();
        msg2.setDataType((DataType)DataType.StringType);
        msg2.setDisplayField("rowid");
        infolist.add(1, msg2);
        RowMetaMsgInfo msg = new RowMetaMsgInfo();
        msg.setDataType((DataType)DataType.BooleanType);
        msg.setDisplayField("isgroupnode");
        infolist.add(2, msg);
        RowMetaMsgInfo msg4 = new RowMetaMsgInfo();
        msg4.setDataType((DataType)DataType.IntegerType);
        msg4.setDisplayField("sumlevel");
        infolist.add(3, msg4);
    }

    private static void changeTree(List<Object[]> coll) {
        for (Object[] objects1 : coll) {
            if (objects1[0] != null) continue;
            objects1[0] = 0;
        }
        for (Object[] objects : coll) {
            boolean a;
            boolean b = coll.stream().filter(v -> v[1] != null).anyMatch(v -> v[1].equals(objects[0]));
            if (!b) {
                objects[0] = 0;
            }
            if (a = coll.stream().filter(v -> v[0] != null).anyMatch(v -> v[0].equals(objects[1]))) continue;
            objects[2] = false;
        }
    }

    private static void sumTree(List<RowMetaMsgInfo> infolist, List<String> sumField, List<Object[]> coll) {
        List<Object[]> collect = coll.stream().filter(objects -> BooleanUtils.isFalse((Boolean)((Boolean)objects[2]))).collect(Collectors.toList());
        OrgTreeReportDataDetailHelper.sumTreeSingle(collect, infolist, sumField, coll);
    }

    private static void sumTreeSingle(List<Object[]> collect, List<RowMetaMsgInfo> infolist, List<String> sumField, List<Object[]> coll) {
        List collect1 = collect.stream().map(v -> v[0]).distinct().collect(Collectors.toList());
        HashMap parentdoubleMap = new HashMap(10);
        for (Object parent : collect1) {
            HashMap<Integer, BigDecimal> doubleMap = new HashMap<Integer, BigDecimal>(10);
            for (int i1 = 4; i1 < infolist.size(); ++i1) {
                RowMetaMsgInfo msgInfo2 = infolist.get(i1);
                if (!sumField.contains(msgInfo2.getDisplayField())) continue;
                int finalI = i1;
                double sum = coll.stream().filter(v -> v[0].equals(parent) && v[finalI] != null && v[finalI] != "").map(v -> v[finalI].toString()).collect(Collectors.toList()).stream().mapToDouble(Double::parseDouble).sum();
                doubleMap.put(i1, BigDecimal.valueOf(sum).setScale(2, 4));
            }
            parentdoubleMap.put(parent, doubleMap);
        }
        for (Object[] objects2 : coll) {
            if (!parentdoubleMap.containsKey(objects2[1])) continue;
            Map integerDoubleMap = (Map)parentdoubleMap.get(objects2[1]);
            for (Map.Entry maps : integerDoubleMap.entrySet()) {
                objects2[((Integer)maps.getKey()).intValue()] = maps.getValue();
            }
        }
        List<Object[]> collect2 = coll.stream().filter(objects -> collect1.contains(objects[1])).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect2)) {
            OrgTreeReportDataDetailHelper.sumTreeSingle(collect2, infolist, sumField, coll);
        }
    }

    public static List<RowMetaMsgInfo> createRowMeta(RowMeta rowmate) {
        Field[] fieldarr;
        ArrayList<RowMetaMsgInfo> cols = new ArrayList<RowMetaMsgInfo>(10);
        for (Field field : fieldarr = rowmate.getFields()) {
            RowMetaMsgInfo msg = new RowMetaMsgInfo();
            msg.setDataType(field.getDataType());
            msg.setDisplayField(field.getName());
            cols.add(msg);
        }
        return cols;
    }

    private static DataSet resultDataSet(List<RowMetaMsgInfo> cols, String className, List<Object[]> coll) {
        RowMeta rowMeta = BizCommomUtil.createRowMeta(cols);
        CollectionInput inputs = new CollectionInput(rowMeta, coll);
        return Algo.create((String)className).createDataSet(new Input[]{inputs});
    }

    public static String generateUniqueLong(Object pid) {
        if (ObjectUtils.isNotEmpty((Object)pid)) {
            return pid.toString() + UUID.randomUUID().getLeastSignificantBits() + "";
        }
        return UUID.randomUUID().getLeastSignificantBits() + "";
    }
}

