/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.common.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.tctsa.common.helper.AbstractServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class TaxcMainServiceHelper
extends AbstractServiceHelper {
    public static String selectFields1 = "id,number,orgid,orgid.name,maincompany,taxcreditrating.creditlevel,taxcreditrating.year,taxcreditrating.ratingscore,taxcreditrating.remark";
    public static String selectFields2 = "id,orgid,orgid.name, registeraddress, regulatedareas,codeandname,orgattr.fbasedataid";
    public static String selectFields3 = "id";
    public static String selectFields4 = "id, orgid, registeraddress, orgattr.fbasedataid.id,orgattr.fbasedataid.name as name,orgattr.fbasedataid.group.number as number,codeandname.name as codename";
    public static String selectFields5 = "orgid";
    public static String orderBys1 = "taxcreditrating.year";

    public static List<DynamicObject> getTaxcMain(List<Long> orgList, String taxtype) {
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainAndCategoryByOrgIdsAndTaxtype(orgList, (String)taxtype);
        if (!result.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)result.getData()))) {
            return new ArrayList<DynamicObject>();
        }
        return (List)result.getData();
    }

    public static DynamicObject getTaxcMainSingleEnable(Long orgId, String taxtype, String enable) {
        DynamicObject obj = TaxcMainServiceHelper.getTaxcMainSingle(orgId, taxtype);
        if (obj == null) {
            return null;
        }
        DynamicObjectCollection categoryentryentity = obj.getDynamicObjectCollection("categoryentryentity");
        if (CollectionUtils.isEmpty((Collection)categoryentryentity) || !StringUtils.equals((CharSequence)((DynamicObject)categoryentryentity.get(0)).getString("enable"), (CharSequence)enable)) {
            return null;
        }
        return obj;
    }

    public static DynamicObject getTaxcMainSingle(Long orgId, String taxtype) {
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainAndCategoryByOrgIdsAndTaxtype(Collections.singletonList(orgId), (String)taxtype);
        if (!result.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)result.getData()))) {
            return null;
        }
        return (DynamicObject)((List)result.getData()).get(0);
    }

    public static DynamicObject getTaxcMainByMore(Long orgId) {
        List<DynamicObject> list = TaxcMainServiceHelper.getTaxcMain(Collections.singletonList(orgId), null);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    public static List<Long> queryTaxcMainOrgIdsByTaxpayer() {
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainOrgIdsByTaxpayer();
        if (!result.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)result.getData()))) {
            return new ArrayList<Long>();
        }
        return (List)result.getData();
    }

    public static DynamicObjectCollection queryDiyByid(List<Long> orgIds, String selectFields) {
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByCustomFilter(orgIds, (Long)TaxationsysMappingEnum.CHN.getId(), (String)selectFields, null, null);
        if (!result.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)result.getData()))) {
            return new DynamicObjectCollection();
        }
        return (DynamicObjectCollection)result.getData();
    }

    public static DynamicObjectCollection queryDiyOrderBys(QFilter[] qFilters, String selectFields, String orderBys) {
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByCustomFilter(new ArrayList(), (Long)TaxationsysMappingEnum.CHN.getId(), (String)selectFields, (QFilter[])qFilters, (String)orderBys);
        if (!result.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)result.getData()))) {
            return new DynamicObjectCollection();
        }
        return (DynamicObjectCollection)result.getData();
    }

    public static DynamicObjectCollection queryDiy(QFilter[] qFilters, String selectFields) {
        DynamicObjectCollection collection = TaxcMainServiceHelper.queryDiyOrderBys(qFilters, selectFields, null);
        return collection;
    }
}

