/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.common.rpt;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.datatype.StringType;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.DeclareTable;
import kd.taxc.bdtaxr.common.enums.MultiTableEnumBase;
import kd.taxc.bdtaxr.common.refactor.formula.fel.FelEngineImpl;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityInfo;
import kd.taxc.tctsa.common.helper.TaxcMainServiceHelper;
import kd.taxc.tctsa.common.rpt.RptDatasetProcess;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class RptDataSetFacility {
    private static final List<String> FILED_LIST = Arrays.asList("User", "Amount", "Attachment", "Decimal", "Creater", "CreaterId", "Modifier", "CreateDate", "ModifyDate", "ModifierId");
    private static final String REGEX = "@.*?@";

    public static String getTable(Long id) {
        DynamicObject rptConfig = BusinessDataServiceHelper.loadSingle((Object)id, (String)"tctsa_rpt_data");
        String type = rptConfig.getString("type");
        long sbbthreetype = rptConfig.getLong("sbbthreetype.id");
        String sbbtwotype = rptConfig.getString("sbbtwotype");
        String table = rptConfig.getString("table");
        return RptDataSetFacility.getTable(type, sbbthreetype, sbbtwotype, table);
    }

    public static String getTable(String type, Long sbbthreetypeId, String sbbtwotype, String table) {
        if ("3.0".equalsIgnoreCase(type)) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)sbbthreetypeId, (String)"tpo_template");
            if (dynamicObject == null) {
                return null;
            }
            long modelId = dynamicObject.getLong("model.id");
            DeclareTable declareTable = MultiTableEnumBase.getDeclareTable((Long)modelId);
            return declareTable.getMainTable();
        }
        if ("2.0".equalsIgnoreCase(type)) {
            return null;
        }
        if ("tz".equalsIgnoreCase(type)) {
            return table;
        }
        return null;
    }

    public static List<EntityField> getEntityFields(DynamicObject model) {
        if (model == null || model.get("sbbthreetype") == null) {
            return new ArrayList<EntityField>();
        }
        long sbbTypeId = model.getLong("sbbthreetype.id");
        if (sbbTypeId == 0L) {
            return new ArrayList<EntityField>();
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)sbbTypeId, (String)"tpo_template");
        long modelId = dynamicObject.getLong("model.id");
        DeclareTable declareTable = MultiTableEnumBase.getDeclareTable((Long)modelId);
        String mainTable = declareTable.getMainTable();
        EntityInfo entityInfo = MetadataUtil.getEntityById((String)mainTable);
        if (entityInfo == null) {
            return new ArrayList<EntityField>();
        }
        return entityInfo.getFieldList().stream().filter(m -> !FILED_LIST.contains(m.getFieldType())).filter(m -> !m.getFieldId().endsWith("_id")).collect(Collectors.toList());
    }

    public static String getPluginClassName(String type) {
        if (StringUtils.isEmpty((CharSequence)type)) {
            return null;
        }
        if ("vat".equalsIgnoreCase(type)) {
            return "kd.taxc.tctsa.formplugin.baserpt.data.plugin.impl.VatDatesetProcess";
        }
        if ("usacit".equalsIgnoreCase(type)) {
            return "kd.taxc.tctsa.formplugin.baserpt.data.plugin.impl.UsaCitRptDasetProcess";
        }
        return null;
    }

    public static DataSet getArgRows(Long id, List<QFilter> filters) {
        DynamicObject rptConfig = BusinessDataServiceHelper.loadSingle((Object)id, (String)"tctsa_rpt_data");
        String table = RptDataSetFacility.getTable(rptConfig.getLong("id"));
        if (StringUtils.isEmpty((CharSequence)table)) {
            return RptDataSetFacility.getEmptyRows(rptConfig, "arg");
        }
        List<EntityField> entityFields = RptDataSetFacility.getEntityFields(rptConfig);
        if (entityFields == null || org.apache.commons.collections4.CollectionUtils.isEmpty(entityFields)) {
            return RptDataSetFacility.getEmptyRows(rptConfig, "arg");
        }
        List<String> fields = entityFields.stream().map(EntityField::getFieldId).collect(Collectors.toList());
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])fields.toArray(new String[0]), (DataType[])((DataType[])fields.stream().map(m -> DataType.StringType).toArray(DataType[]::new)));
        ArrayList<Object[]> result = new ArrayList<Object[]>(12);
        String selectField = String.join((CharSequence)",", fields);
        DataSet rows = QueryServiceHelper.queryDataSet((String)(System.currentTimeMillis() + ""), (String)table, (String)selectField, (QFilter[])filters.toArray(new QFilter[0]), null);
        for (Row row : rows) {
            ArrayList<String> dynRow = new ArrayList<String>(8);
            for (String field : fields) {
                dynRow.add(row.getString(field));
            }
            result.add(dynRow.toArray(new Object[0]));
        }
        rows.close();
        CollectionInput inputs = new CollectionInput(rowMeta, result);
        return Algo.create((String)(System.currentTimeMillis() + "")).createDataSet(new Input[]{inputs});
    }

    private static DataSet getEmptyRows(DynamicObject rptConfig, String type) {
        RowMeta rowMeta = RptDataSetFacility.getDatesetRowMeta(rptConfig, type);
        CollectionInput inputs = new CollectionInput(rowMeta, new ArrayList());
        return Algo.create((String)(System.currentTimeMillis() + "")).createDataSet(new Input[]{inputs});
    }

    public static ImmutablePair<DataSet, Map<String, String>> getCellRow(Long id, List<QFilter> filters) {
        String table = RptDataSetFacility.getTable(id);
        HashMap<String, String> cellMap = new HashMap<String, String>(1024);
        DynamicObject rptConfig = BusinessDataServiceHelper.loadSingle((Object)id, (String)"tctsa_rpt_data");
        DynamicObjectCollection cellEntryentity = rptConfig.getDynamicObjectCollection("cell_entryentity");
        if (org.apache.commons.collections4.CollectionUtils.isEmpty((Collection)cellEntryentity)) {
            return ImmutablePair.of((Object)RptDataSetFacility.getEmptyRows(rptConfig, "cell"), cellMap);
        }
        ArrayList<Object[]> result = new ArrayList<Object[]>(12);
        RowMeta rowMeta = RptDataSetFacility.getDatesetRowMeta(rptConfig, "cell");
        List<String> btFields = cellEntryentity.stream().filter(m -> "bt".equalsIgnoreCase(m.getString("cell_by"))).map(m -> m.getString("cell_bref")).collect(Collectors.toList());
        if (!btFields.contains("id")) {
            btFields.add(0, "id");
        }
        String mainField = String.join((CharSequence)",", btFields);
        DataSet mainTsdDataSet = QueryServiceHelper.queryDataSet((String)(System.currentTimeMillis() + "getCellRow"), (String)table, (String)mainField, (QFilter[])filters.toArray(new QFilter[0]), null);
        if (mainTsdDataSet.isEmpty()) {
            CollectionInput inputs = new CollectionInput(rowMeta, result);
            DataSet dataSet = Algo.create((String)(System.currentTimeMillis() + "")).createDataSet(new Input[]{inputs});
            return ImmutablePair.of((Object)dataSet, cellMap);
        }
        DataSet idsDataSet = mainTsdDataSet.copy();
        ArrayList<Long> entryids = new ArrayList<Long>(8);
        for (Row mian : idsDataSet) {
            entryids.add(mian.getLong("id"));
        }
        idsDataSet.close();
        Set cellHw = cellEntryentity.stream().filter(m -> m.get("cell_hw") != null).map(m -> m.getLong("cell_hw.id")).collect(Collectors.toSet());
        Set cellLw = cellEntryentity.stream().filter(m -> m.get("cell_lw") != null).map(m -> m.getLong("cell_lw.id")).collect(Collectors.toSet());
        Set cellJczllw = cellEntryentity.stream().filter(m -> m.get("cell_jczllw") != null).map(m -> m.getLong("cell_jczllw.id")).collect(Collectors.toSet());
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(cellJczllw)) {
            cellLw.addAll(cellJczllw);
        }
        QFilter detailFilter = new QFilter("entryid", "in", entryids).and("row", "in", new ArrayList(cellHw)).and("column", "in", new ArrayList(cellLw));
        DataSet mainTsdDetailSet = QueryServiceHelper.queryDataSet((String)String.valueOf(System.currentTimeMillis()), (String)"tpo_declare_detail_tsd", (String)"entryid,cellnumber,dynrowno,index,valuetype,value", (QFilter[])detailFilter.toArray(), (String)"cellnumber asc");
        DataSet dataSet = mainTsdDataSet.copy().join(mainTsdDetailSet).on("id", "entryid").select(btFields.toArray(new String[0]), new String[]{"cellnumber", "dynrowno", "index", "value"}).finish();
        DataSet mapDataset = dataSet.copy();
        for (Row row : mapDataset) {
            String key = row.getString("id") + "#" + row.getString("cellnumber");
            String value = row.getString("value");
            cellMap.put(key, value);
        }
        mapDataset.close();
        for (Row row : mainTsdDataSet) {
            ArrayList<Object> rowData = new ArrayList<Object>(8);
            Long rowId = row.getLong("id");
            rowData.add(rowId);
            for (DynamicObject cellEntry : cellEntryentity) {
                String cellHwName = cellEntry.getString("cell_hw.number");
                String cellLwName = cellEntry.getString("cell_lw.number");
                String cellType = cellEntry.getString("cell_type");
                if ("bt".equalsIgnoreCase(cellEntry.getString("cell_by"))) {
                    Object value = RptDataSetFacility.getBtValue(cellType, row, cellEntry.getString("cell_bref"));
                    rowData.add(value);
                    continue;
                }
                if ("gd".equalsIgnoreCase(cellEntry.getString("cell_by"))) {
                    String concat = String.valueOf(rowId).concat("#").concat(cellHwName).concat("#").concat(cellLwName);
                    Object gdValue = RptDataSetFacility.getGdValue(cellType, (String)cellMap.get(concat));
                    rowData.add(gdValue);
                    continue;
                }
                Integer maxRow = RptDataSetFacility.getMaxRow(String.valueOf(rowId), cellHwName, cellLwName, cellMap);
                rowData.add(String.valueOf(maxRow));
            }
            result.add(rowData.toArray(new Object[0]));
        }
        CollectionInput inputs = new CollectionInput(rowMeta, result);
        DataSet set = Algo.create((String)(System.currentTimeMillis() + "")).createDataSet(new Input[]{inputs});
        return ImmutablePair.of((Object)set, cellMap);
    }

    private static Object getBtValue(String cellType, Row row, String filld) {
        if ("str".equalsIgnoreCase(cellType)) {
            return row.getString(filld);
        }
        if ("je".equalsIgnoreCase(cellType)) {
            return row.getBigDecimal(filld);
        }
        if ("sl".equalsIgnoreCase(cellType)) {
            return row.getInteger(filld);
        }
        if ("id".equalsIgnoreCase(cellType)) {
            return row.getLong(filld);
        }
        if ("date".equalsIgnoreCase(cellType)) {
            return row.getDate(filld);
        }
        if ("xs".equalsIgnoreCase(cellType)) {
            return row.getBigDecimal(filld);
        }
        return null;
    }

    private static Object getGdValue(String cellType, String value) {
        if (value == null) {
            return null;
        }
        if ("str".equalsIgnoreCase(cellType)) {
            return value;
        }
        if ("je".equalsIgnoreCase(cellType)) {
            return new BigDecimal(value);
        }
        if ("sl".equalsIgnoreCase(cellType)) {
            return Integer.parseInt(value);
        }
        if ("id".equalsIgnoreCase(cellType)) {
            return Long.parseLong(value);
        }
        if ("date".equalsIgnoreCase(cellType)) {
            return DateUtils.stringToDate2((String)value);
        }
        if ("xs".equalsIgnoreCase(cellType)) {
            return new BigDecimal(value);
        }
        return null;
    }

    private static Integer getMaxRow(String id, String hw, String lw, Map<String, String> cellMap) {
        if (MapUtils.isEmpty(cellMap)) {
            return 0;
        }
        for (int i = 1; i < 1000; ++i) {
            String key = id.concat("#").concat(hw).concat("#").concat(String.valueOf(i)).concat("#").concat(lw);
            if (cellMap.containsKey(key)) continue;
            return i - 1;
        }
        return 0;
    }

    private static RowMeta getDatesetRowMeta(DynamicObject rptConfig, String type) {
        if ("arg".equalsIgnoreCase(type)) {
            ArrayList<String> fields = new ArrayList<String>(8);
            List<EntityField> entityFields = RptDataSetFacility.getEntityFields(rptConfig);
            for (EntityField entityField : entityFields) {
                fields.add(entityField.getFieldId());
            }
            ArrayList<StringType> dataTypes = new ArrayList<StringType>(8);
            for (String ignored : fields) {
                dataTypes.add(DataType.StringType);
            }
            return RowMetaFactory.createRowMeta((String[])fields.toArray(new String[0]), (DataType[])dataTypes.toArray(new DataType[0]));
        }
        if ("cell".equalsIgnoreCase(type)) {
            DynamicObjectCollection cellEntryentity = rptConfig.getDynamicObjectCollection("cell_entryentity");
            List<String> fields = cellEntryentity.stream().map(m -> m.getString("cell_no")).collect(Collectors.toList());
            fields.add(0, "id");
            ArrayList<Object> dataTypes = new ArrayList<Object>(8);
            dataTypes.add(DataType.LongType);
            for (DynamicObject entry : cellEntryentity) {
                if ("dth".equalsIgnoreCase(entry.getString("cell_by"))) {
                    dataTypes.add(DataType.StringType);
                    continue;
                }
                String cellType = entry.getString("cell_type");
                if ("str".equalsIgnoreCase(cellType)) {
                    dataTypes.add(DataType.StringType);
                    continue;
                }
                if ("je".equalsIgnoreCase(cellType)) {
                    dataTypes.add(DataType.BigDecimalType);
                    continue;
                }
                if ("sl".equalsIgnoreCase(cellType)) {
                    dataTypes.add(DataType.IntegerType);
                    continue;
                }
                if ("id".equalsIgnoreCase(cellType)) {
                    dataTypes.add(DataType.LongType);
                    continue;
                }
                if ("date".equalsIgnoreCase(cellType)) {
                    dataTypes.add(DataType.DateType);
                    continue;
                }
                if (!"xs".equalsIgnoreCase(cellType)) continue;
                dataTypes.add(DataType.DoubleType);
            }
            return RowMetaFactory.createRowMeta((String[])fields.toArray(new String[0]), (DataType[])dataTypes.toArray(new DataType[0]));
        }
        if ("value".equalsIgnoreCase(type)) {
            DynamicObjectCollection valueEntryentity = rptConfig.getDynamicObjectCollection("value_entryentity");
            ArrayList<String> fields = new ArrayList<String>(8);
            fields.add(0, "id");
            for (DynamicObject dynamicObject : valueEntryentity) {
                String valueNo = dynamicObject.getString("value_no");
                String valueFormula = dynamicObject.getString("value_formula");
                if (!StringUtils.isNotEmpty((CharSequence)valueFormula)) continue;
                fields.add(valueNo);
            }
            ArrayList dataTypes = new ArrayList(8);
            for (String ignored : fields) {
                dataTypes.add(DataType.StringType);
            }
            return RowMetaFactory.createRowMeta((String[])fields.toArray(new String[0]), (DataType[])dataTypes.toArray(new DataType[0]));
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u914d\u7f6e\u9519\u8bef", (String)"RptDataSetFacility_0", (String)"taxc-tctsa-common", (Object[])new Object[0]));
    }

    public static DataSet getValueRows(Long id, List<QFilter> filters) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        DynamicObject rptConfig = BusinessDataServiceHelper.loadSingle((Object)id, (String)"tctsa_rpt_data");
        String plugin = RptDataSetFacility.getPluginClassName(rptConfig.getString("plugintype"));
        DataSet valueRowWithNoArg = RptDataSetFacility.getValueRowWithNoFormula(id, filters);
        if (StringUtils.isEmpty((CharSequence)plugin)) {
            return valueRowWithNoArg;
        }
        Class<?> aClass = Class.forName(plugin);
        RptDatasetProcess rptDatasetProcess = (RptDatasetProcess)aClass.newInstance();
        ImmutablePair<DataSet, Map<String, String>> pair = RptDataSetFacility.getCellRow(id, filters);
        return rptDatasetProcess.getValueDataset((DataSet)pair.left, (Map)pair.right, valueRowWithNoArg, rptConfig);
    }

    private static DataSet getValueRowWithNoFormula(Long id, List<QFilter> filters) {
        DataSet cellRow = (DataSet)RptDataSetFacility.getCellRow((Long)id, filters).left;
        DynamicObject rptConfig = BusinessDataServiceHelper.loadSingle((Object)id, (String)"tctsa_rpt_data");
        if (cellRow.isEmpty()) {
            return RptDataSetFacility.getEmptyRows(rptConfig, "value");
        }
        ArrayList<Object[]> result = new ArrayList<Object[]>(12);
        DynamicObjectCollection valueEntryentity = rptConfig.getDynamicObjectCollection("value_entryentity");
        DataSet copy1 = cellRow.copy();
        DataSet orgDateset = copy1.select("org").distinct();
        ArrayList<Long> orgsList = new ArrayList<Long>(8);
        for (Row row : orgDateset) {
            orgsList.add(row.getLong("org"));
        }
        orgDateset.close();
        QFilter filter = new QFilter("id", "!=", (Object)0L);
        DynamicObject[] taxationsys = BusinessDataServiceHelper.load((String)"bd_taxationsys", (String)"id,name,number", (QFilter[])filter.toArray());
        Map<Long, List<DynamicObject>> taxationsysMap = Arrays.stream(taxationsys).collect(Collectors.groupingBy(m -> m.getLong("id")));
        DynamicObject[] taxcategories = BusinessDataServiceHelper.load((String)"bd_taxcategory", (String)"id,name,number", (QFilter[])filter.toArray());
        Map<Long, List<DynamicObject>> taxcategoryMap = Arrays.stream(taxcategories).collect(Collectors.groupingBy(m -> m.getLong("id")));
        DynamicObject[] bastaxTaxareagroups = BusinessDataServiceHelper.load((String)"bastax_taxareagroup", (String)"id,name,number", (QFilter[])filter.toArray());
        Map<Long, List<DynamicObject>> taxareagroupMap = Arrays.stream(bastaxTaxareagroups).collect(Collectors.groupingBy(m -> m.getLong("id")));
        QFilter authFilter = new QFilter("id", "in", orgsList);
        DynamicObjectCollection bastaxTaxorg = QueryServiceHelper.query((String)"bastax_taxorg", (String)"org.id as id,org.name as name", (QFilter[])authFilter.toArray());
        Map<Long, List<DynamicObject>> bastaxTaxorgMap = bastaxTaxorg.stream().collect(Collectors.groupingBy(m -> m.getLong("id")));
        for (Row row : cellRow) {
            ArrayList<Object> rowData = new ArrayList<Object>(8);
            rowData.add(row.getString("id"));
            for (DynamicObject valueEntry : valueEntryentity) {
                List<DynamicObject> list;
                String valueFormula = valueEntry.getString("value_formula");
                String valueDefaultFormula = valueEntry.getString("value_default_formula");
                if (StringUtils.isEmpty((CharSequence)valueFormula)) continue;
                Object value = RptDataSetFacility.getValue(valueFormula, row);
                if (StringUtils.isEmpty((CharSequence)valueDefaultFormula)) {
                    rowData.add(value);
                    continue;
                }
                if ("glqy".equalsIgnoreCase(valueDefaultFormula)) {
                    rowData.add(null);
                    continue;
                }
                if ("sshy".equalsIgnoreCase(valueDefaultFormula)) {
                    rowData.add(null);
                    continue;
                }
                if ("sszd".equalsIgnoreCase(valueDefaultFormula)) {
                    list = taxationsysMap.get(Long.parseLong(String.valueOf(value)));
                    if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(list) && list.size() == 1) {
                        rowData.add(list.get(0).getString("name"));
                        continue;
                    }
                    rowData.add(null);
                    continue;
                }
                if ("sz".equalsIgnoreCase(valueDefaultFormula)) {
                    list = taxcategoryMap.get(Long.parseLong(String.valueOf(value)));
                    if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(list) && list.size() == 1) {
                        rowData.add(list.get(0).getString("name"));
                        continue;
                    }
                    rowData.add(null);
                    continue;
                }
                if ("ssxq".equalsIgnoreCase(valueDefaultFormula)) {
                    list = taxareagroupMap.get(Long.parseLong(String.valueOf(value)));
                    if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(list) && list.size() == 1) {
                        rowData.add(list.get(0).getString("name"));
                        continue;
                    }
                    rowData.add(null);
                    continue;
                }
                if (!"swzzmc".equalsIgnoreCase(valueDefaultFormula)) continue;
                list = bastaxTaxorgMap.get(Long.parseLong(String.valueOf(value)));
                if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(list) && list.size() == 1) {
                    rowData.add(list.get(0).getString("name"));
                    continue;
                }
                rowData.add(null);
            }
            result.add(rowData.toArray(new Object[0]));
        }
        RowMeta rowMeta = RptDataSetFacility.getDatesetRowMeta(rptConfig, "value");
        CollectionInput inputs = new CollectionInput(rowMeta, result);
        return Algo.create((String)(System.currentTimeMillis() + "")).createDataSet(new Input[]{inputs});
    }

    public static Map<Long, List<DynamicObject>> queryTaxMainInfo(List<Long> orgs, List<Long> codeandname) {
        List<Object> labels = TaxcMainServiceHelper.getTaxcMain(orgs, null);
        if (!CollectionUtils.isEmpty(codeandname)) {
            labels = labels.stream().filter(v -> codeandname.contains(v.getLong("codeandname.id"))).collect(Collectors.toList());
        }
        return labels.stream().collect(Collectors.groupingBy(s -> s.getLong("orgid.id")));
    }

    public static String getSshyName(List<DynamicObject> taxinfoList) {
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(taxinfoList)) {
            return null;
        }
        Object codeandname = taxinfoList.get(0).get("codeandname");
        if (codeandname == null) {
            return null;
        }
        return taxinfoList.get(0).getString("codeandname.name");
    }

    public static Long getSshyId(List<DynamicObject> taxinfoList) {
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(taxinfoList)) {
            return 0L;
        }
        Object codeandname = taxinfoList.get(0).get("codeandname");
        if (codeandname == null) {
            return 0L;
        }
        return taxinfoList.get(0).getLong("codeandname.id");
    }

    public static String getGlqy(List<DynamicObject> taxinfoList) {
        if (CollectionUtils.isEmpty(taxinfoList)) {
            return null;
        }
        for (DynamicObject dynamicObject : taxinfoList) {
            if (CollectionUtils.isEmpty((Collection)dynamicObject.getDynamicObjectCollection("orgattr"))) continue;
            for (DynamicObject orgattrObj : dynamicObject.getDynamicObjectCollection("orgattr")) {
                if (!"regulated_areas".equalsIgnoreCase(orgattrObj.getString("fbasedataid.group.number"))) continue;
                return orgattrObj.getString("fbasedataid.name");
            }
        }
        return null;
    }

    public static Object getValue(String valueFormula, Row cellRow) {
        if (StringUtils.isEmpty((CharSequence)valueFormula)) {
            return null;
        }
        if (!valueFormula.contains("@")) {
            Object value = cellRow.get(valueFormula);
            if (value instanceof Date) {
                value = DateUtils.format((Date)((Date)value));
            }
            if (value != null) {
                value = String.valueOf(value);
            }
            return value;
        }
        Pattern pattern = Pattern.compile(REGEX);
        Matcher matcher = pattern.matcher(valueFormula);
        HashMap<Object, String> map = new HashMap<Object, String>(8);
        while (matcher.find()) {
            String group = matcher.group();
            String string = group.replaceAll("@", "");
            map.put(group, cellRow.getString(string));
        }
        for (Map.Entry entry : map.entrySet()) {
            valueFormula = valueFormula.replaceAll((String)entry.getKey(), (String)entry.getValue());
        }
        FelEngineImpl engine = new FelEngineImpl();
        return engine.eval(valueFormula);
    }
}

