/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.common.rpt;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterItemInfo;
import org.apache.commons.collections4.CollectionUtils;

public class RptUtils {
    public static List<Long> getFilterValueIds(List<FilterItemInfo> filterItemInfoList, String propName) {
        if (CollectionUtils.isEmpty(filterItemInfoList)) {
            return new ArrayList<Long>(8);
        }
        for (FilterItemInfo itemInfo : filterItemInfoList) {
            String name = itemInfo.getPropName();
            if (!propName.equals(name)) continue;
            return RptUtils.getFilterValueIds(itemInfo);
        }
        return new ArrayList<Long>(8);
    }

    public static List<Long> getFilterValueIds(FilterItemInfo filterItemInfo) {
        Object value = filterItemInfo.getValue();
        List<Long> ids = new ArrayList<Long>(8);
        if (value == null) {
            return ids;
        }
        if (value instanceof DynamicObjectCollection) {
            ids = ((DynamicObjectCollection)value).stream().map(m -> m.getLong("id")).distinct().collect(Collectors.toList());
        } else if (value instanceof List) {
            if (((List)value).size() != 0) {
                ids = (List)value;
            }
        } else if (value instanceof DynamicObject) {
            long id = ((DynamicObject)value).getLong("id");
            ids.add(id);
        }
        return ids;
    }

    public static BigDecimal getSflRate(BigDecimal ynse, BigDecimal ynsr, BigDecimal jmse, int xsjd, int bfbjd) {
        if (jmse == null || jmse.compareTo(BigDecimal.ZERO) == 0) {
            return ynse == null || ynsr == null || ynsr.compareTo(BigDecimal.ZERO) == 0 ? null : ynse.divide(ynsr, xsjd, RoundingMode.HALF_UP).multiply(new BigDecimal("100")).setScale(bfbjd, RoundingMode.HALF_UP);
        }
        return ynse == null || ynsr == null || ynsr.compareTo(BigDecimal.ZERO) == 0 ? null : ynse.subtract(jmse).divide(ynsr, xsjd, RoundingMode.HALF_UP).multiply(new BigDecimal("100")).setScale(bfbjd, RoundingMode.HALF_UP);
    }

    public static BigDecimal getTbbdl(BigDecimal ynsecol, BigDecimal ynsrcol, BigDecimal jmsecol, BigDecimal qntqynsecol, BigDecimal sntqsrcol, BigDecimal sntqjmsecol) {
        BigDecimal sflRate = RptUtils.getSflRate(ynsecol, ynsrcol, jmsecol, 10, 10);
        BigDecimal sntqsflRate = RptUtils.getSflRate(qntqynsecol, sntqsrcol, sntqjmsecol, 10, 10);
        return sflRate == null || sntqsflRate == null || sntqsflRate.compareTo(BigDecimal.ZERO) == 0 ? null : sflRate.subtract(sntqsflRate).divide(sntqsflRate, 6, RoundingMode.HALF_UP).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
    }
}

