/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.common.threadpools;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.taxc.tctsa.common.threadpools.Task;

public class ThreadPoolsService {
    private static Log logger = LogFactory.getLog(ThreadPoolsService.class);
    private static ThreadPoolsService threadPoolsService = new ThreadPoolsService();
    private static ExecutorService dispatch = ThreadPools.newExecutorService((String)"tctsa-threadPoolsService-dispatch", (int)6);
    private static ExecutorService ex = ThreadPools.newExecutorService((String)"tctsa-threadPoolsService", (int)6);

    private ThreadPoolsService() {
    }

    public static ThreadPoolsService getInstance() {
        return threadPoolsService;
    }

    public boolean submit(Task call) {
        long time = System.currentTimeMillis();
        Future<Boolean> future = dispatch.submit(new ExecutorTask(RequestContext.getOrCreate(), ex, call));
        try {
            future.get();
        }
        catch (Exception e) {
            logger.error("ThreadPoolsService submit", (Throwable)e);
        }
        logger.info("\u6267\u884c\u4efb\u52a1\u82b1\u8d39\u65f6\u95f4:" + (System.currentTimeMillis() - time));
        return true;
    }

    static class ExecutorTask
    implements Callable<Boolean> {
        private RequestContext rc;
        protected ExecutorService ex;
        private Task call;

        public ExecutorTask(RequestContext rc, ExecutorService ex, Task call) {
            this.ex = ex;
            this.rc = rc;
            this.call = call;
        }

        @Override
        public Boolean call() throws Exception {
            RequestContext.copyAndSet((RequestContext)this.rc);
            List values = this.call.getValue();
            ArrayList list = new ArrayList(values.size());
            for (Object t : values) {
                list.add(this.ex.submit(this.call.call(this.rc, t)));
            }
            for (Future future : list) {
                future.get(5000L, TimeUnit.SECONDS);
            }
            return Boolean.TRUE;
        }
    }
}

