/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.taxc.tctsa.common.util.PermissionUtils;
import kd.taxc.tctsa.common.util.TreeUtils;

public class BaseDataUtil {
    public static ArrayList<Long> getAllPermOrgs() {
        Long orgId = RequestContext.get().getOrgId();
        long userId = Long.parseLong(RequestContext.get().getUserId());
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getUserHasPermOrgs((long)userId);
        List permOrgs = hasPermOrgResult.getHasPermOrgs();
        ArrayList<Long> rootOrg = new ArrayList<Long>();
        rootOrg.add(orgId);
        List childOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)10L, rootOrg, (boolean)true);
        permOrgs.retainAll(childOrgs);
        List<Long> orgidList = TreeUtils.queryOrgIdsByCondition(permOrgs);
        return (ArrayList)orgidList;
    }

    public static String getDefaultOrg(IFormView view) {
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs(view);
        List<Long> orgidList = TreeUtils.queryOrgListHasPermission(hasPermOrgs);
        if (CollectionUtils.isEmpty(orgidList)) {
            return "";
        }
        long orgId = RequestContext.get().getOrgId();
        if (orgidList.contains(orgId)) {
            return Long.toString(orgId);
        }
        return Long.toString(orgidList.get(0));
    }

    public static void getChildId(Long id, List<Long> childIds, DynamicObjectCollection allData) {
        for (DynamicObject dyo : allData) {
            long parent = dyo.getLong("parent");
            if (parent != id) continue;
            childIds.add(dyo.getLong("id"));
            BaseDataUtil.getChildId((Long)dyo.getLong("id"), childIds, allData);
        }
    }

    public static void getChildId(Long id, List<Long> childIds, String entityName) {
        DynamicObjectCollection allData = QueryServiceHelper.query((String)entityName, (String)"id,parent", (QFilter[])new QFilter[0]);
        childIds.add(id);
        BaseDataUtil.getChildId(id, childIds, allData);
        List collect = childIds.stream().distinct().sorted().collect(Collectors.toList());
        childIds.clear();
        childIds.addAll(collect);
    }
}

