/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.common.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;

public class BigDecimalUtil {
    public static BigDecimal checkPrecision(BigDecimal checknumber, Integer integer, Integer decimal) {
        Integer n;
        Integer n2;
        StringBuilder str = new StringBuilder();
        Integer i = 0;
        while (i < integer) {
            str.append("0");
            n2 = i;
            n = i = Integer.valueOf(i + 1);
        }
        i = 0;
        while (i < decimal) {
            if (i == 0) {
                str.append(".");
            }
            str.append("0");
            n2 = i;
            n = i = Integer.valueOf(i + 1);
        }
        DecimalFormat df = new DecimalFormat(str.toString());
        String trueNumber = df.format(checknumber);
        String[] arr = checknumber.toString().split("\\.");
        if (arr[0].length() > integer) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u503c\u4e0d\u7b26\u5408\u7cbe\u5ea6", (String)"BigDecimalUtil_0", (String)"taxc-tctsa-common", (Object[])new Object[0]));
        }
        if (arr.length > 1 && arr[1].length() > decimal) {
            if (checknumber.compareTo(BigDecimalUtil.setScale(trueNumber, decimal)) == 0) {
                return BigDecimalUtil.setScale(trueNumber, decimal);
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u503c\u4e0d\u7b26\u5408\u7cbe\u5ea6", (String)"BigDecimalUtil_0", (String)"taxc-tctsa-common", (Object[])new Object[0]));
        }
        return checknumber;
    }

    public static BigDecimal setScale(Object dec) {
        return BigDecimalUtil.setScale(dec, 2);
    }

    public static BigDecimal setScale(Object dec, int scale) {
        BigDecimal bigDecimal = BigDecimalUtil.toBigDecimal(dec);
        if (bigDecimal == null) {
            return BigDecimal.ZERO;
        }
        return bigDecimal.setScale(scale, 4);
    }

    public static BigDecimal subtractObject(Object dec1, Object dec2) {
        if (dec1 == null && dec2 == null) {
            return null;
        }
        return BigDecimalUtil.toBigDecimal(dec1).subtract(BigDecimalUtil.toBigDecimal(dec2));
    }

    public static BigDecimal subtractObject(Object dec1, Object dec2, int scale) {
        if (dec1 == null && dec2 == null) {
            return null;
        }
        return BigDecimalUtil.toBigDecimal(dec1).subtract(BigDecimalUtil.toBigDecimal(dec2)).setScale(scale, 4);
    }

    public static BigDecimal divideObject(Object dec1, Object dec2, int scale) {
        return BigDecimalUtil.divideObject(dec1, dec2, scale, 4);
    }

    public static BigDecimal divideObject(Object dec1, Object dec2, int scale, int roundingMode) {
        if (dec1 == null && dec2 == null) {
            return null;
        }
        if (BigDecimalUtil.toBigDecimal(dec2).signum() == 0) {
            return null;
        }
        return BigDecimalUtil.toBigDecimal(dec1).divide(BigDecimalUtil.toBigDecimal(dec2), scale, roundingMode);
    }

    public static BigDecimal multiplyObject(Object dec1, Object dec2, int scale) {
        if (dec1 == null || dec2 == null) {
            return null;
        }
        BigDecimal obj = BigDecimalUtil.toBigDecimal(dec1).multiply(BigDecimalUtil.toBigDecimal(dec2));
        return obj.setScale(scale, 6);
    }

    public static BigDecimal addObject(Object dec1, Object dec2) {
        if (dec1 == null && dec2 == null) {
            return null;
        }
        return BigDecimalUtil.toBigDecimal(dec1).add(BigDecimalUtil.toBigDecimal(dec2));
    }

    public static BigDecimal toBigDecimal(Object obj) {
        if (obj == null) {
            return BigDecimal.ZERO;
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj instanceof Integer) {
            return new BigDecimal(((Integer)obj).toString());
        }
        if (obj instanceof Long) {
            return new BigDecimal(((Long)obj).toString());
        }
        if (obj instanceof Double) {
            return BigDecimal.valueOf((Double)obj);
        }
        if (obj.toString() == null) {
            return BigDecimal.ZERO;
        }
        String str = obj.toString().trim();
        if (str.toLowerCase().contains("e")) {
            try {
                return new BigDecimal(str);
            }
            catch (NumberFormatException e) {
                return BigDecimal.ZERO;
            }
        }
        if (str.matches("^[+-]?\\d+[\\.\\d]?\\d*+$")) {
            return new BigDecimal(str);
        }
        return BigDecimal.ZERO;
    }

    public static String format(Object num, String pattern) {
        DecimalFormat format = new DecimalFormat(pattern, DecimalFormatSymbols.getInstance());
        return format.format(num);
    }
}

