/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.taxc.tctsa.common.enums.CreditLevelEnum;
import kd.taxc.tctsa.common.enums.RangeLevelEnum;
import kd.taxc.tctsa.common.util.DateUtils;
import kd.taxc.tctsa.common.util.StringUtil;

public class CreditHandlerUtils {
    public static List<Object[]> getAllData(DynamicObjectCollection queryCollection, DynamicObjectCollection compareCollection, String rangeLevel, Boolean isDemote) {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        Map<Long, List<DynamicObject>> compareGroups = compareCollection.stream().collect(Collectors.groupingBy(s -> s.getLong("orgid")));
        for (DynamicObject obj : queryCollection) {
            if (isDemote.booleanValue()) {
                String needCreditlevel;
                List<DynamicObject> dynamicObjects;
                if (!StringUtil.isNotEmpty((CharSequence)obj.getString("taxcreditrating.creditlevel")) || (dynamicObjects = compareGroups.get(obj.getLong("orgid"))) == null || dynamicObjects.size() <= 0 || !CreditHandlerUtils.matchRangeLevel(obj.getString("taxcreditrating.creditlevel"), rangeLevel, dynamicObjects) || !StringUtil.isNotEmpty((CharSequence)(needCreditlevel = CreditHandlerUtils.getRangeLevel(obj.getString("taxcreditrating.creditlevel"), rangeLevel)))) continue;
                String[] levels = needCreditlevel.split("\\|");
                String creditlevels = levels[0];
                String[] creditlevels1 = creditlevels.split(",");
                String showlevels = levels[1];
                String[] showlevels1 = showlevels.split(",");
                for (DynamicObject dynamicObject : dynamicObjects) {
                    int i = 0;
                    String showLevel = "";
                    for (String creditLevel : creditlevels1) {
                        if (creditLevel.equals(dynamicObject.getString("taxcreditrating.creditlevel"))) {
                            showLevel = showlevels1[i];
                            break;
                        }
                        ++i;
                    }
                    result.add(new Object[]{showLevel, StringUtil.isNotEmpty((CharSequence)obj.getString("taxcreditrating.creditlevel")) ? obj.getString("taxcreditrating.creditlevel") : "\u2014", obj.getString("orgid.name"), obj.getDate("taxcreditrating.year") != null ? Integer.valueOf(DateUtils.getYearOfDate(obj.getDate("taxcreditrating.year"))) : null, obj.getString("taxcreditrating.ratingscore"), dynamicObject.getDate("taxcreditrating.year") != null ? Integer.valueOf(DateUtils.getYearOfDate(dynamicObject.getDate("taxcreditrating.year"))) : null, dynamicObject.getString("taxcreditrating.creditlevel"), dynamicObject.getString("taxcreditrating.ratingscore"), obj.getString("taxcreditrating.remark"), "0", StringUtil.isEmpty((CharSequence)obj.getString("taxcreditrating.creditlevel")) ? "6" : CreditLevelEnum.getTaxNameByType(obj.getString("taxcreditrating.creditlevel")), showLevel});
                }
                continue;
            }
            if (obj.getDate("taxcreditrating.year") == null && StringUtil.isEmpty((CharSequence)obj.getString("taxcreditrating.creditlevel")) && StringUtil.isEmpty((CharSequence)obj.getString("taxcreditrating.ratingscore")) && StringUtil.isEmpty((CharSequence)obj.getString("taxcreditrating.remark"))) continue;
            result.add(new Object[]{"", StringUtil.isNotEmpty((CharSequence)obj.getString("taxcreditrating.creditlevel")) ? obj.getString("taxcreditrating.creditlevel") : "\u2014", obj.getString("orgid.name"), obj.getDate("taxcreditrating.year") != null ? Integer.valueOf(DateUtils.getYearOfDate(obj.getDate("taxcreditrating.year"))) : null, obj.getString("taxcreditrating.ratingscore"), "", "", "", obj.getString("taxcreditrating.remark"), "0", StringUtil.isEmpty((CharSequence)obj.getString("taxcreditrating.creditlevel")) ? "6" : CreditLevelEnum.getTaxNameByType(obj.getString("taxcreditrating.creditlevel")), ""});
        }
        return result;
    }

    private static String getRangeLevel(String creditlevel, String rangeLevel) {
        return RangeLevelEnum.getlevelsByRangeLevel(creditlevel, rangeLevel);
    }

    private static boolean matchRangeLevel(String creditlevel, String rangeLevel, List<DynamicObject> dynamicObjects) {
        String needCreditlevel = CreditHandlerUtils.getRangeLevel(creditlevel, rangeLevel);
        if (StringUtil.isNotEmpty((CharSequence)needCreditlevel)) {
            String[] levels = needCreditlevel.split("\\|");
            String creditlevels = levels[0];
            for (DynamicObject dynamicObject : dynamicObjects) {
                if (!creditlevels.contains(dynamicObject.getString("taxcreditrating.creditlevel"))) continue;
                return true;
            }
        }
        return false;
    }
}

