/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.taxc.tctsa.common.util.EmptyCheckUtils;

@Deprecated
public class DateUtils {
    public static final String YYYY = "yyyy";
    public static final String YYYY_MM = "yyyy-MM";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYYMMDD_CHINESE = DateUtils.getYyyymmddChinese();

    public static int getMonthDiff(Date d1, Date d2) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(d1);
        c2.setTime(d2);
        int year1 = c1.get(1);
        int year2 = c2.get(1);
        int month1 = c1.get(2);
        int month2 = c2.get(2);
        int day1 = c1.get(5);
        int day2 = c2.get(5);
        int yearInterval = year1 - year2;
        if (month1 < month2 || month1 == month2 && day1 < day2) {
            --yearInterval;
        }
        int monthInterval = month1 + 12 - month2;
        if (day1 < day2) {
            --monthInterval;
        }
        return Math.abs(yearInterval * 12 + (monthInterval %= 12));
    }

    public static String format(Date date, String format) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(date);
    }

    public static String format(Date date) {
        return DateUtils.format(date, YYYY_MM_DD);
    }

    public static String formatMonth(Date date) {
        return DateUtils.format(date, YYYY_MM);
    }

    public static Date stringToDate(String datestr) {
        Date date;
        if (EmptyCheckUtils.isEmpty(datestr)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(YYYY_MM_DD);
        try {
            date = df.parse(datestr);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a:%s", (String)"DateUtils_17", (String)"taxc-tctsa-common", (Object[])new Object[0]), YYYY_MM_DD), e);
        }
        return date;
    }

    public static Date stringToDate(String datestr, String dateformat) {
        Date date;
        SimpleDateFormat df = new SimpleDateFormat(dateformat);
        try {
            date = df.parse(datestr);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u65e5\u671f[%1$s]\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a:%2$s", (String)"DateUtils_18", (String)"taxc-tctsa-common", (Object[])new Object[0]), datestr, dateformat), e);
        }
        return date;
    }

    public static Date getFirstDateOfMonth(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getLastDateOfMonth(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date trunc(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getDayFirst(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getLastDateOfMonth2(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date addMonth(Date date, int imonth) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.add(2, imonth);
        return cd.getTime();
    }

    public static Date addYear(Date date, int iyear) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.add(1, iyear);
        return cd.getTime();
    }

    public static int getYearOfDate(Date date) {
        int y = 0;
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        y = cd.get(1);
        return y;
    }

    public static int getMonthOfDate(Date date) {
        int m = 0;
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        m = cd.get(2);
        return m + 1;
    }

    public static int getDayOfDate(Date date) {
        int y = 0;
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        y = cd.get(5);
        return y;
    }

    public static Date trunc(Date date, String format) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String s = sdf.format(date);
        try {
            return sdf.parse(s);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a:%s", (String)"DateUtils_17", (String)"taxc-tctsa-common", (Object[])new Object[0]), format), e);
        }
    }

    public static Date getFirstDateOfSeason(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(DateUtils.getFirstDateOfMonth(date));
        int month = cd.get(2);
        if (month < 3) {
            cd.set(2, 0);
        } else if (month >= 3 && month < 6) {
            cd.set(2, 3);
        } else if (month >= 6 && month < 9) {
            cd.set(2, 6);
        } else {
            cd.set(2, 9);
        }
        return DateUtils.getFirstDateOfMonth(cd.getTime());
    }

    public static Date getLastDateOfSeason(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        int month = cd.get(2);
        if (month < 3) {
            cd.set(2, 0);
        } else if (month >= 3 && month < 6) {
            cd.set(2, 3);
            cd.get(2);
            cd.set(2, 3);
        } else if (month >= 6 && month < 9) {
            cd.set(2, 6);
        } else {
            cd.set(2, 9);
        }
        cd.add(2, 2);
        return DateUtils.getLastDateOfMonth(cd.getTime());
    }

    public static Date getFirstDateOfHalfYear(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(DateUtils.getFirstDateOfMonth(date));
        int month = cd.get(2);
        if (month < 6) {
            cd.set(2, 0);
        } else {
            cd.set(2, 6);
        }
        return DateUtils.getFirstDateOfMonth(cd.getTime());
    }

    public static Date getLastDateOfHalfYear(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(DateUtils.getFirstDateOfMonth(date));
        int month = cd.get(2);
        if (month < 6) {
            cd.set(2, 5);
        } else {
            cd.set(2, 11);
        }
        return DateUtils.getLastDateOfMonth(cd.getTime());
    }

    public static Date getFirstDateOfYear(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        String str = new SimpleDateFormat(YYYY).format(cd.getTime()) + "-01-01 00:00:00";
        return DateUtils.stringToDate(str);
    }

    public static Date getLastDateOfYear(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        String str = new SimpleDateFormat(YYYY).format(cd.getTime()) + "-12-31 00:00:00";
        return DateUtils.stringToDate(str, YYYY_MM_DD_HH_MM_SS);
    }

    public static Date getDateBySeasonal(Date date, String number) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        String str = null;
        switch (number) {
            case "1": {
                str = new SimpleDateFormat(YYYY).format(cd.getTime()) + "-01-01 00:00:00";
                break;
            }
            case "2": {
                str = new SimpleDateFormat(YYYY).format(cd.getTime()) + "-04-01 00:00:00";
                break;
            }
            case "3": {
                str = new SimpleDateFormat(YYYY).format(cd.getTime()) + "-07-01 00:00:00";
                break;
            }
            case "4": {
                str = new SimpleDateFormat(YYYY).format(cd.getTime()) + "-10-01 00:00:00";
                break;
            }
        }
        return DateUtils.stringToDate(str);
    }

    public static Date getLastDateOfMonth1(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    public static String getTaxLimit(Date startDate, Date endDate) {
        int monthDiff = DateUtils.getMonthDiff(endDate, startDate);
        if (monthDiff == 0) {
            return "month";
        }
        if (monthDiff == 2) {
            return "season";
        }
        if (monthDiff == 5) {
            return "halfyear";
        }
        if (monthDiff == 11) {
            return "year";
        }
        return "";
    }

    public static List<String> getMonthBetween(Date minDate, Date maxDate) {
        ArrayList<String> result = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat(YYYY_MM);
        Calendar min = Calendar.getInstance();
        Calendar max = Calendar.getInstance();
        min.setTime(minDate);
        min.set(min.get(1), min.get(2), 1);
        max.setTime(maxDate);
        max.set(max.get(1), max.get(2), 2);
        Calendar curr = min;
        while (curr.before(max)) {
            result.add(sdf.format(curr.getTime()));
            curr.add(2, 1);
        }
        return result;
    }

    private static String getYyyymmddChinese() {
        return InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId());
    }

    public static boolean isEffectiveDate(Date nowTime, Date startTime, Date endTime) {
        Calendar nowDate = Calendar.getInstance();
        nowDate.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(startTime);
        if (endTime == null) {
            return nowDate.after(begin);
        }
        if (nowTime.getTime() == startTime.getTime() || nowTime.getTime() == endTime.getTime()) {
            return true;
        }
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return nowDate.after(begin) && nowDate.before(end);
    }
}

