/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.common.util;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.taxc.tctsa.common.enums.LicenseTaxEnum;
import kd.taxc.tctsa.common.helper.LicenseCheckServiceHelper;
import kd.taxc.tctsa.common.helper.OrgCheckServiceHelper;
import kd.taxc.tctsa.common.util.EmptyCheckUtils;
import kd.taxc.tctsa.common.util.PermissionUtils;
import kd.taxc.tctsa.common.util.TreeUtils;

public class OrgCheckUtil {
    public static boolean searchCheck(TreeNode node, IFormView view, boolean needErrorMsg) {
        List<Long> orgidList;
        String orgId = node.getId();
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs(view);
        if (!hasPermOrgResult.hasAllOrgPerm() && !(orgidList = TreeUtils.queryOrgIdsByCondition(hasPermOrgResult.getHasPermOrgs())).contains(Long.parseLong(orgId))) {
            if (needErrorMsg) {
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5f53\u524d\u7ec4\u7ec7\u662f\u53ef\u7528\u4e14\u6709\u6743\u9650\u7684\u7a0e\u52a1\u7ec4\u7ec7\uff0c\u5982\u9700\u64cd\u4f5c,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u7528\u6237\u6388\u6743\u3002", (String)"OrgCheckUtil_11", (String)"taxc-tctsa-common", (Object[])new Object[0]), new Object[0]));
            }
            return false;
        }
        String appid = view.getFormShowParameter().getAppId();
        LicenseTaxEnum taxEnum = LicenseTaxEnum.getEnumInstanceByAppid(appid);
        if (null == taxEnum) {
            return true;
        }
        return !(needErrorMsg ? LicenseCheckServiceHelper.check(orgId, view, taxEnum.getAppid()) : LicenseCheckServiceHelper.check(orgId, null, taxEnum.getAppid()));
    }

    public static boolean withoutLicenseCheck(IFormView view, String orgId, String appid, String categoryType) {
        return OrgCheckUtil.withoutLicenseCheck(view, orgId, appid, categoryType, true);
    }

    public static boolean withoutLicenseCheck(IFormView view, String orgId, String appid, String categoryType, boolean needErrorMsg) {
        return OrgCheckUtil.checkOrgAndEnable(view, orgId, needErrorMsg) || OrgCheckUtil.isTaxPayerAuth(view, orgId, needErrorMsg);
    }

    public static boolean checkOrgAndEnable(IFormView view, String orgId, boolean needErrorMsg) {
        return OrgCheckServiceHelper.checkOrgAndEnable(view, orgId, needErrorMsg);
    }

    public static boolean isTaxPayerAuth(IFormView view, String orgId, boolean needErrorMsg) {
        return OrgCheckServiceHelper.isTaxPayerAuth(view, orgId, needErrorMsg);
    }

    public static String findTaxOrg(IFormView view, String orgField, IPageCache pageCache) {
        Long unitOrgId = RequestContext.get().getOrgId();
        TreeNode treeNode = new TreeNode();
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs(view);
        List<Long> orgidList = TreeUtils.queryOrgListHasPermission(hasPermOrgs);
        pageCache.put("orgList", SerializationUtils.toJsonString(orgidList));
        if (!CollectionUtils.isEmpty(orgidList)) {
            ArrayList<Long> orgids = new ArrayList<Long>(10);
            for (Long obj : orgidList) {
                treeNode.setId(String.valueOf(obj));
                if (!OrgCheckUtil.searchCheck(treeNode, view, false)) continue;
                orgids.add(obj);
                if (!unitOrgId.equals(obj)) continue;
                return String.valueOf(obj);
            }
            if (EmptyCheckUtils.isNotEmpty(orgids)) {
                return String.valueOf(orgids.get(0));
            }
        }
        return null;
    }
}

