/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.common.util;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tctsa.common.enums.BooleanEnum;
import kd.taxc.tctsa.common.helper.OrgServiceHelper;
import kd.taxc.tctsa.common.helper.TaxcMainServiceHelper;
import kd.taxc.tctsa.common.util.DateUtils;
import kd.taxc.tctsa.common.util.EmptyCheckUtils;
import kd.taxc.tctsa.common.util.TreeUtils;

public class OrgUtils {
    private static Comparator<Object> CHINA_COMPARATOR = Collator.getInstance(Locale.CHINA);
    private static final String FIELD_EFFECTDATE = "effectdate";
    private static final String FIELD_INVALIDDATE = "invaliddate";

    public static String getOrgNameById(String orgid) {
        return OrgServiceHelper.getOrgNameById(orgid);
    }

    public static Long getDefaultViewSchemaInfoId() {
        return OrgServiceHelper.getDefaultViewSchemaInfoId();
    }

    public static QFilter getQFilter(Date enddate) {
        QFilter q = new QFilter(FIELD_EFFECTDATE, "<=", (Object)DateUtils.getLastDateOfMonth1(enddate)).and(FIELD_INVALIDDATE, ">=", (Object)DateUtils.getLastDateOfMonth1(enddate));
        q = q.or(new QFilter(FIELD_EFFECTDATE, "<=", (Object)DateUtils.getLastDateOfMonth1(enddate)).and(QFilter.isNull((String)FIELD_INVALIDDATE)));
        return q;
    }

    public static final List<String> getOrgIdByStructurePkids(List<String> structureIds) {
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"bos_org_structure", (String)"org", (QFilter[])new QFilter[]{new QFilter("id", "in", structureIds.stream().map(v -> Long.parseLong(v)).collect(Collectors.toList()))});
        return EmptyCheckUtils.isEmpty(dys) ? new ArrayList<String>() : dys.stream().map(v -> v.getString("org")).collect(Collectors.toList());
    }

    public static final List<String> getStructurePkidsByOrgId(List<String> orgIds) {
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"bos_org_structure", (String)"id", (QFilter[])new QFilter[]{new QFilter("org.id", "in", orgIds.stream().map(v -> Long.parseLong(v)).collect(Collectors.toList())), OrgUtils.getDefaultTaxOrgStructureViewQfilter()});
        return EmptyCheckUtils.isEmpty(dys) ? new ArrayList<String>() : dys.stream().map(v -> v.getString("id")).distinct().collect(Collectors.toList());
    }

    public static List<Long> mergeOrgIds(List<Long> idList) {
        return OrgServiceHelper.mergeOrgIds(idList);
    }

    public static QFilter getDefaultTaxOrgStructureViewQfilter() {
        return new QFilter("view.treetype", "=", (Object)String.valueOf(OrgUtils.getDefaultViewSchemaInfoId())).and("view.number", "=", (Object)"40");
    }

    public static final DynamicObjectCollection getTaxOrgListHasPermission(QFilter qFilter) {
        List<Long> orgids = OrgServiceHelper.getOrgListHasPermissionAll();
        if (EmptyCheckUtils.isEmpty(orgids)) {
            return null;
        }
        return OrgUtils.filterNonTaxPayerOrg(orgids, qFilter);
    }

    public static DynamicObjectCollection filterNonTaxPayerOrg(List<Long> orgids, QFilter qFilter) {
        QFilter istaxpayerFilter = new QFilter("taxorg.istaxpayer", "=", (Object)BooleanEnum.YES.getCode());
        QFilter orgFilter = new QFilter("orgid", "in", orgids);
        DynamicObjectCollection taxmainCollection = EmptyCheckUtils.isEmpty(qFilter) ? TaxcMainServiceHelper.queryDiy(new QFilter[]{istaxpayerFilter, orgFilter}, TaxcMainServiceHelper.selectFields2) : TaxcMainServiceHelper.queryDiy(new QFilter[]{istaxpayerFilter, orgFilter, qFilter}, TaxcMainServiceHelper.selectFields2);
        return taxmainCollection;
    }

    public static DynamicObjectCollection getTaxOrgList() {
        QFilter istaxpayerFilter = new QFilter("taxorg.istaxpayer", "=", (Object)BooleanEnum.YES.getCode());
        QFilter statusqFilter = new QFilter("taxorg.status", "=", (Object)BooleanEnum.YES.getCode());
        return TaxcMainServiceHelper.queryDiy(new QFilter[]{istaxpayerFilter, statusqFilter}, TaxcMainServiceHelper.selectFields2);
    }

    public static List<Long> getChildrenIds(List<Long> orgIds) {
        Map<String, Map<String, String>> viewTreeMap = OrgUtils.getAllOrgByViewId(Long.parseLong("40"));
        Map<String, List<Map<String, String>>> flatOrgTreeMap = OrgUtils.getOrgTreeMap(viewTreeMap);
        TreeNode viewRoot = OrgUtils.createTreeNode(viewTreeMap);
        if (viewRoot == null) {
            return orgIds;
        }
        OrgUtils.createChildNodes(flatOrgTreeMap, viewRoot.getId(), viewRoot);
        ArrayList childNodes = new ArrayList();
        orgIds.stream().forEach(node -> {
            TreeNode parentNode = viewRoot.getTreeNode(String.valueOf(node), 10);
            childNodes.addAll(TreeUtils.getChildIdList(parentNode));
        });
        List childNodesTemp = childNodes.stream().map(o -> Long.valueOf(o)).collect(Collectors.toList());
        orgIds.addAll(childNodesTemp);
        return orgIds;
    }

    public static TreeNode createTreeNode(Map<String, Map<String, String>> orgTreeMap) {
        Map<String, Map> rootIdMap = orgTreeMap.entrySet().stream().filter(v -> "0".equals(((Map)v.getValue()).get("parentid"))).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Map)e.getValue()));
        Set<String> rootIdSet = rootIdMap.keySet();
        if (rootIdSet.isEmpty()) {
            return null;
        }
        String rootId = rootIdSet.toArray(new String[0])[0];
        String rootName = orgTreeMap.get(rootId).get("name");
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setId(rootId);
        root.setText(rootName);
        root.setIsOpened(true);
        root.setLongNumber(orgTreeMap.get(rootId).get("longnumber"));
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("isleaf", "0");
        dataMap.put("level", "1");
        dataMap.put("fullname", rootName);
        root.setData(dataMap);
        return root;
    }

    public static TreeNode createChildNodes(Map<String, List<Map<String, String>>> orgTreeMap, String rootId, TreeNode root) {
        if (orgTreeMap == null || rootId == null || orgTreeMap.size() == 0 || root == null) {
            return null;
        }
        OrgUtils.buildTreeNode(orgTreeMap, rootId, root);
        return root;
    }

    public static void buildTreeNode(Map<String, List<Map<String, String>>> orgTreeMap, String rootId, TreeNode treeNode) {
        List<Map<String, String>> childList = orgTreeMap.get(rootId);
        HashMap dataMap = (HashMap)treeNode.getData();
        if (childList == null || childList.size() == 0) {
            dataMap.put("isleaf", "1");
            return;
        }
        String parentLongNumber = treeNode.getLongNumber();
        int parentLevel = Integer.parseInt((String)dataMap.get("level"));
        String parentName = (String)dataMap.get("fullname");
        for (Map<String, String> org : childList) {
            TreeNode childrenTree = new TreeNode();
            String orgid = org.get("id");
            if ("0".equals(orgid) || StringUtils.isEmpty((CharSequence)org.get("name"))) continue;
            childrenTree.setParentid(org.get("parentid"));
            childrenTree.setId(orgid);
            childrenTree.setText(org.get("name"));
            childrenTree.setIsOpened(false);
            childrenTree.setLongNumber(parentLongNumber + "!" + orgid);
            HashMap<String, String> childDataMap = new HashMap<String, String>();
            childDataMap.put("isleaf", "0");
            childDataMap.put("level", String.valueOf(parentLevel + 1));
            childDataMap.put("fullname", parentName + "_" + org.get("name"));
            childrenTree.setData(childDataMap);
            treeNode.addChild(childrenTree);
            OrgUtils.buildTreeNode(orgTreeMap, orgid, childrenTree);
        }
        OrgUtils.sortTreeNode(treeNode.getChildren());
    }

    public static void sortTreeNode(List<TreeNode> nodes) {
        if (nodes != null && !nodes.isEmpty()) {
            Collections.sort(nodes, (node1, node2) -> CHINA_COMPARATOR.compare(node1.getText(), node2.getText()));
        }
    }

    public static void buildOrgTree(Map<String, String> org, Map<String, Map<String, String>> orgMap, Map<String, List<Map<String, String>>> orgTreeMap) {
        List<Map<String, String>> parentList;
        String orgid = org.get("id");
        if (orgid == null || orgid.equalsIgnoreCase("0")) {
            return;
        }
        String parentid = org.get("parentid");
        Map<String, String> parentOrg = orgMap.get(parentid);
        if (orgTreeMap.get(orgid) == null) {
            orgTreeMap.put(orgid, new ArrayList());
        }
        if (parentOrg == null) {
            return;
        }
        if (orgTreeMap.get(parentid) == null) {
            OrgUtils.buildOrgTree(parentOrg, orgMap, orgTreeMap);
        }
        if ((parentList = orgTreeMap.get(parentid)) == null) {
            return;
        }
        if (!parentList.contains(org)) {
            parentList.add(org);
        }
    }

    public static Map<String, List<Map<String, String>>> getOrgTreeMap(Map<String, Map<String, String>> orgMap) {
        HashMap<String, List<Map<String, String>>> orgTreeMap = new HashMap<String, List<Map<String, String>>>();
        for (Map.Entry<String, Map<String, String>> orgId : orgMap.entrySet()) {
            OrgUtils.buildOrgTree(orgId.getValue(), orgMap, orgTreeMap);
        }
        return orgTreeMap;
    }

    public static Map<String, Map<String, String>> getAllOrgByViewId(Long orgViewSchemaId) {
        return OrgUtils.getAllOrgByViewId(orgViewSchemaId, null);
    }

    public static Map<String, Map<String, String>> getAllOrgByViewId(Long orgViewSchemaId, QFilter qFilter) {
        QFilter orgViewIdFilter = new QFilter("view", "=", (Object)orgViewSchemaId);
        if (qFilter != null) {
            orgViewIdFilter.and(qFilter);
        }
        orgViewIdFilter.and(new QFilter("org.enable", "=", (Object)"1"));
        HashMap<String, Map<String, String>> orgTreeMap = new HashMap<String, Map<String, String>>();
        try (DataSet data = QueryServiceHelper.queryDataSet((String)"kd.tmc.fbd.formplugin.companysys.CompanySysViewEdit.getAllOrgByViewId()", (String)"bos_org_structure", (String)"id,org.id,org.name,org.number,parent.id,isleaf,longnumber", (QFilter[])orgViewIdFilter.toArray(), (String)"longnumber");){
            while (data.hasNext()) {
                HashMap<String, String> mtree = new HashMap<String, String>();
                Row row = data.next();
                String id = String.valueOf(row.getLong("org.id"));
                mtree.put("id", id);
                mtree.put("name", row.getString("org.name"));
                mtree.put("number", row.getString("org.number"));
                mtree.put("parentid", String.valueOf(row.getLong("parent.id")));
                mtree.put("isleaf", row.getBoolean("isleaf") != false ? "1" : "0");
                mtree.put("longnumber", row.getString("longnumber"));
                orgTreeMap.put(id, mtree);
            }
        }
        return orgTreeMap;
    }
}

