/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.common.util;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.taxc.tctsa.common.enums.DateMappingEnum;
import kd.taxc.tctsa.common.util.DateUtils;

public class TctsaUtils {
    public static final String FIELD_STARTDATE = "startdate";
    public static final String FIELD_ENDDATE = "enddate";

    public static final List<Map<String, String>> parseJson(String json) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        try {
            List map = SerializationUtils.fromJsonStringToList((String)json, Map.class);
            list.addAll(map);
        }
        catch (Exception e) {
            Map map = (Map)SerializationUtils.fromJsonString((String)json, Map.class);
            list.add(map);
        }
        return list;
    }

    public static List<Map<String, Date>> getCalDate(String calType, Date startDate, Date endDate) {
        ArrayList<Map<String, Date>> list = new ArrayList<Map<String, Date>>();
        Date startdate = DateUtils.trunc(startDate);
        Date enddate = endDate;
        Date orgenddate = endDate;
        Date orgstartdate = DateUtils.trunc(startDate);
        if (DateMappingEnum.TIME_DEVIATION_MONTH.getDeviatedType().equals(calType)) {
            TctsaUtils.getMonthTypeList(list, startdate, enddate);
        } else if (DateMappingEnum.TIME_DEVIATION_SEASON.getDeviatedType().equals(calType)) {
            TctsaUtils.getSeasonTypeList(list, startdate, enddate, orgstartdate, orgenddate);
        } else if (DateMappingEnum.TIME_DEVIATION_YEAR.getDeviatedType().equals(calType)) {
            TctsaUtils.getYearTypeList(list, startdate, enddate, orgstartdate, orgenddate);
        } else if (DateMappingEnum.TIME_DEVIATION_HALF_YEAR.getDeviatedType().equals(calType)) {
            TctsaUtils.getHalfYearTypeList(list, startdate, enddate, orgstartdate, orgenddate);
        }
        return list;
    }

    private static void getMonthTypeList(List<Map<String, Date>> list, Date startDate, Date endDate) {
        while (startDate.compareTo(endDate) < 0) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(startDate);
            Date lastDateOfMonth = DateUtils.trunc(DateUtils.getLastDateOfMonth(startDate));
            if (lastDateOfMonth.compareTo(endDate) > 0) break;
            HashMap<String, Date> map = new HashMap<String, Date>();
            map.put(FIELD_STARTDATE, startDate);
            map.put(FIELD_ENDDATE, lastDateOfMonth);
            startDate = DateUtils.addMonth(DateUtils.getFirstDateOfMonth(startDate), 1);
            list.add(map);
        }
    }

    private static void getSeasonTypeList(List<Map<String, Date>> list, Date startdate, Date enddate, Date orgstartdate, Date orgenddate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startdate);
        int month = calendar.get(2);
        calendar.set(2, TctsaUtils.getStartQMonth(month));
        startdate = DateUtils.getFirstDateOfMonth(calendar.getTime());
        calendar.setTime(enddate);
        month = calendar.get(2);
        calendar.set(2, TctsaUtils.getEndQMonth(month));
        enddate = DateUtils.getLastDateOfMonth(calendar.getTime());
        while (startdate.compareTo(enddate) < 0) {
            Calendar dar = Calendar.getInstance();
            dar.setTime(startdate);
            HashMap<String, Date> map = new HashMap<String, Date>();
            Date end = DateUtils.getLastDateOfMonth(DateUtils.addMonth(startdate, 2));
            if (DateUtils.trunc(end).compareTo(enddate) > 0) break;
            map.put(FIELD_STARTDATE, startdate);
            map.put(FIELD_ENDDATE, DateUtils.trunc(end));
            if (startdate.compareTo(orgstartdate) >= 0 && DateUtils.getLastDateOfMonth(orgenddate).compareTo(end) >= 0) {
                list.add(map);
            }
            startdate = DateUtils.addMonth(DateUtils.getFirstDateOfMonth(startdate), 3);
        }
    }

    private static void getYearTypeList(List<Map<String, Date>> list, Date startdate, Date enddate, Date orgstartdate, Date orgenddate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startdate);
        calendar.set(2, 0);
        calendar.set(5, 1);
        startdate = calendar.getTime();
        while (startdate.compareTo(enddate) < 0) {
            Calendar dar = Calendar.getInstance();
            dar.setTime(startdate);
            HashMap<String, Date> map = new HashMap<String, Date>();
            String end = DateUtils.getYearOfDate(startdate) + "-12-31";
            Date endData = DateUtils.stringToDate(end);
            if (DateUtils.trunc(endData).compareTo(enddate) > 0) break;
            map.put(FIELD_STARTDATE, startdate);
            map.put(FIELD_ENDDATE, DateUtils.trunc(endData));
            if (startdate.compareTo(orgstartdate) >= 0 && orgenddate.compareTo(endData) >= 0) {
                list.add(map);
            }
            startdate = DateUtils.addYear(DateUtils.getFirstDateOfMonth(startdate), 1);
        }
    }

    private static void getHalfYearTypeList(List<Map<String, Date>> list, Date startdate, Date enddate, Date orgstartdate, Date orgenddate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startdate);
        int month = calendar.get(2);
        calendar.set(2, month < 6 ? 0 : 6);
        startdate = DateUtils.getFirstDateOfMonth(calendar.getTime());
        calendar.setTime(enddate);
        month = calendar.get(2);
        calendar.set(2, month < 6 ? 5 : 11);
        enddate = DateUtils.getLastDateOfMonth(calendar.getTime());
        while (startdate.compareTo(enddate) < 0) {
            Calendar dar = Calendar.getInstance();
            dar.setTime(startdate);
            HashMap<String, Date> map = new HashMap<String, Date>();
            Date end = DateUtils.getLastDateOfMonth(DateUtils.addMonth(startdate, 5));
            if (DateUtils.trunc(end).compareTo(enddate) > 0) break;
            map.put(FIELD_STARTDATE, startdate);
            map.put(FIELD_ENDDATE, DateUtils.trunc(end));
            if (startdate.compareTo(orgstartdate) >= 0 && DateUtils.getLastDateOfMonth(orgenddate).compareTo(end) >= 0) {
                list.add(map);
            }
            startdate = DateUtils.addMonth(DateUtils.getFirstDateOfMonth(startdate), 6);
        }
    }

    private static int getStartQMonth(int month) {
        if (month < 3) {
            return 0;
        }
        if (month < 6) {
            return 3;
        }
        if (month < 9) {
            return 6;
        }
        return 9;
    }

    private static int getEndQMonth(int month) {
        if (month < 3) {
            return 2;
        }
        if (month < 6) {
            return 5;
        }
        if (month < 9) {
            return 8;
        }
        return 11;
    }

    public static Map<String, String> getInfoByOrgIdFromErp(String orgId, String ... selectFields) {
        QFilter id = new QFilter("id", "=", (Object)Long.parseLong(orgId));
        StringBuilder selectStrBuilder = new StringBuilder();
        int len = selectFields.length;
        for (int i = 0; i < len; ++i) {
            selectStrBuilder.append(selectFields[i]);
            selectStrBuilder.append(',');
        }
        String temp = selectStrBuilder.toString();
        String selectStr = temp.substring(0, temp.length() - 1);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)OrgViewServiceHelper.class.getName(), (String)"bos_org", (String)selectStr, (QFilter[])new QFilter[]{id}, (String)"id");){
            HashMap<String, String> map = new HashMap<String, String>();
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                Row row = (Row)iter.next();
                for (int key = 0; key < selectFields.length; ++key) {
                    map.put(selectFields[key], row.getString(selectFields[key]));
                }
            }
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
    }
}

