/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.taxc.tctsa.common.helper.OrgServiceHelper;

public class TreeUtils {
    public static List<Long> queryOrgIdsByCondition(List<Long> orgIdList) {
        List<Long> orgList = OrgServiceHelper.queryOrgListByCondition();
        if (CollectionUtils.isEmpty(orgList) || CollectionUtils.isEmpty(orgIdList)) {
            return new ArrayList<Long>();
        }
        orgIdList.retainAll(orgList);
        return orgIdList;
    }

    public static List<Long> queryOrgListHasPermission(HasPermOrgResult hasPermOrgResult) {
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            return TreeUtils.queryOrgIdsByCondition(hasPermOrgResult.getHasPermOrgs());
        }
        return OrgServiceHelper.getOrgLists();
    }

    public static List<String> getChildIdList(TreeNode treeNode) {
        ArrayList<String> idlist = new ArrayList<String>();
        if (treeNode != null && !CollectionUtils.isEmpty((Collection)treeNode.getChildren())) {
            for (TreeNode node : treeNode.getChildren()) {
                idlist.addAll(TreeUtils.childList(node));
            }
        }
        return idlist;
    }

    private static List<String> childList(TreeNode treeNode) {
        ArrayList<String> idlist = new ArrayList<String>();
        if (treeNode != null) {
            idlist.add(treeNode.getId());
            if (!CollectionUtils.isEmpty((Collection)treeNode.getChildren())) {
                for (TreeNode node : treeNode.getChildren()) {
                    idlist.addAll(TreeUtils.childList(node));
                }
            }
        }
        return idlist;
    }
}

