/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.dao.declare;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class DeclareReportDao {
    private static final Map<String, String> DEADLINE_TAXLIMIT = new HashMap<String, String>();

    public DynamicObject queryOneDeclareReport(List<QFilter> filterList) {
        return QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"id", (QFilter[])filterList.toArray(new QFilter[0]));
    }

    public DynamicObjectCollection queryYbnsrDeclaredReport(String orgid, String period) {
        QFilter filter = new QFilter("org", "=", (Object)Long.parseLong(orgid));
        QFilter typefilter = new QFilter("type", "=", (Object)"zzsybnsr");
        Date perioddate = DateUtils.stringToDate((String)period, (String)"yyyy-MM");
        Date startdate = DateUtils.getFirstDateOfMonth((Date)perioddate);
        Date enddate = DateUtils.getLastDateOfMonth((Date)perioddate);
        QFilter skssqq = new QFilter("skssqq", ">=", (Object)startdate);
        QFilter skssqz = new QFilter("skssqz", "<=", (Object)enddate);
        QFilter declarestatus = new QFilter("declarestatus", "=", (Object)"declared");
        return QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id,declarestatus", (QFilter[])new QFilter[]{filter, typefilter, skssqq, skssqz, declarestatus});
    }

    public DynamicObject queryNsrxx(String orgid, Date startdate, Date enddate, QFilter typefilter, String deadline) {
        QFilter filter = new QFilter("org", "=", (Object)Long.parseLong(orgid));
        QFilter skssqq = new QFilter("skssqq", "=", (Object)startdate);
        QFilter skssqz = new QFilter("skssqz", "=", (Object)DateUtils.trunc((Date)enddate));
        QFilter taxlimit = new QFilter("taxlimit", "=", (Object)DEADLINE_TAXLIMIT.get(deadline));
        return QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"id,bqybtse,yssr", (QFilter[])new QFilter[]{filter, typefilter, skssqq, skssqz, taxlimit});
    }

    public DynamicObjectCollection queryZzsZb(String sbbid) {
        QFilter qFilter = new QFilter("ewblxh", "in", (Object)new String[]{"1", "3"}).and("sbbid", "=", (Object)sbbid);
        return QueryServiceHelper.query((String)"tcvat_ybnsr_zb", (String)"ewblxh,ynsehj,(asysljsxse+ajybfjsxse+mdtbfckxse+msxse) as xse", (QFilter[])qFilter.toArray());
    }

    public DynamicObjectCollection queryXgmZb(String sbbid) {
        QFilter qFilter = new QFilter("ewblxh", "in", (Object)new String[]{"1", "2"}).and("sbbid", "=", (Object)sbbid);
        return QueryServiceHelper.query((String)"tcvat_xgm_zb", (String)"sum(bqybtse) as bqybtse,(sum(yzzzsbhsxse)+sum(yzzzsbhsxse2)+sum(xssygdysgdzcbhsxse)+sum(msxse)+sum(ckmsxse)) as xse", (QFilter[])qFilter.toArray());
    }

    public DynamicObjectCollection queryDeclareReportBySbbid(List<Long> sbbid) {
        QFilter filter = new QFilter("id", "in", sbbid);
        return QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id,riskcontent,declarestatus,paystatus", (QFilter[])new QFilter[]{filter});
    }

    static {
        DEADLINE_TAXLIMIT.put("ajsb", "season");
        DEADLINE_TAXLIMIT.put("aysb", "month");
    }
}

