/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.dao.inputdeduction;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineCalcFilterService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class InputIdentifyDao {
    private static InputIdentifyDao inputIdentifyDao = new InputIdentifyDao();
    private static final String PAGE_TCVAT_INPUT_INVOICE_SIGN = "tcvat_input_invoice_sign";
    private static final String INVOICE_SIGN_FIELDS = "id,invoicepkid,org,taxperiod,currentsigntaxamount,baseinvoicetype as invoicetype,consumertype,invoicecode,invoiceno as voucherno,taxamount,effectivetaxamount";

    private InputIdentifyDao() {
    }

    public static InputIdentifyDao getInstance() {
        return inputIdentifyDao;
    }

    public DynamicObjectCollection queryInvoiceSign(Map<String, List<Long>> orgRelationMap, List<String> dateList, List<Long> orglist, Map<String, String> invoiceTypeMap) {
        QFilter orgQfilterByList = EngineCalcFilterService.getOrgQfilterByList(orgRelationMap, orglist, (String)PAGE_TCVAT_INPUT_INVOICE_SIGN, (String)PAGE_TCVAT_INPUT_INVOICE_SIGN, (String)"org");
        QFilter periodFilter = new QFilter("taxperiod", "in", dateList);
        QFilter invoicetype = new QFilter("baseinvoicetype", "in", (Object)new Long[]{Long.parseLong(invoiceTypeMap.get("1")), Long.parseLong(invoiceTypeMap.get("2")), Long.parseLong(invoiceTypeMap.get("4")), Long.parseLong(invoiceTypeMap.get("9")), Long.parseLong(invoiceTypeMap.get("10")), Long.parseLong(invoiceTypeMap.get("12")), Long.parseLong(invoiceTypeMap.get("15")), Long.parseLong(invoiceTypeMap.get("16")), Long.parseLong(invoiceTypeMap.get("20")), Long.parseLong(invoiceTypeMap.get("21")), Long.parseLong(invoiceTypeMap.get("26")), Long.parseLong(invoiceTypeMap.get("27"))});
        QFilter signtype = new QFilter("signtype", "=", (Object)"1");
        QFilter signstatus = new QFilter("signstatus", "=", (Object)"1");
        DynamicObjectCollection invoiceSignCollection = QueryServiceHelper.query((String)PAGE_TCVAT_INPUT_INVOICE_SIGN, (String)INVOICE_SIGN_FIELDS, (QFilter[])new QFilter[]{orgQfilterByList, periodFilter, signstatus, invoicetype, signtype});
        orgQfilterByList.__setProperty("tax_org");
        invoicetype.__setProperty("invoice_type");
        QFilter taxPeriodFilter = new QFilter("tax_period", ">=", (Object)DateUtils.stringToDate((String)dateList.get(0), (String)"yyyy-MM")).and(new QFilter("tax_period", "<=", (Object)DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)dateList.get(dateList.size() - 1), (String)"yyyy-MM"))));
        QFilter deleteFilter = new QFilter("delete", "=", (Object)"1");
        DynamicObjectCollection rimInvoice = QueryServiceHelper.query((String)"rim_invoice", (String)"id,invoice_code,invoice_no,tax_org,tax_period,invoice_type", (QFilter[])new QFilter[]{orgQfilterByList, taxPeriodFilter, invoicetype, deleteFilter});
        List invoiceCodeAndNoList = rimInvoice.stream().map(i -> i.getString("invoice_code") + i.getString("invoice_no")).collect(Collectors.toList());
        invoiceSignCollection.removeIf(i -> !invoiceCodeAndNoList.contains(i.getString("invoicepkid")));
        return invoiceSignCollection;
    }
}

