/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.dynamicrow;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicListBasePlugin;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.utils.BigDecimalUtil;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;
import org.apache.commons.lang3.ObjectUtils;

public class TcvatGjncpyyscjyFetchDataPlugin
extends AbstractDynamicListBasePlugin {
    public static final String TPO_DECLARE_MAIN_TSD = "tpo_declare_main_tsd";
    public static final String TPO_DECLARE_DETAIL_TSD = "tpo_declare_detail_tsd";
    private static final Long VAT202206_A = 1389922186361365504L;
    private static final Long VAT202206_HUNAN = 1447826235349590016L;
    private static final Long VAT202206_HNGX = 1636309081566231552L;
    public static final Set<Long> FROMIMPORT = Sets.newHashSet((Object[])new Long[]{VAT202206_A, VAT202206_HUNAN, VAT202206_HNGX});

    public List<Map<String, Object>> query(BussinessParamsVo bussinessParamsVo) {
        String endDate;
        String startDate;
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>(16);
        Map extendParams = bussinessParamsVo.getExtendParams();
        String orgId = (String)extendParams.get("orgId");
        if (ObjectUtils.anyNull((Object[])new Object[]{orgId, startDate = (String)extendParams.get("startdate"), endDate = (String)extendParams.get("enddate")})) {
            return maps;
        }
        Long templateId = (Long)extendParams.get("templateId");
        if (ObjectUtils.anyNull((Object[])new Object[]{orgId, startDate, endDate, templateId})) {
            return maps;
        }
        boolean isFromImport = false;
        if (FROMIMPORT.contains(templateId) && SystemParamUtil.getZeroDeclareParameter((String)"tcvat", (String)"ncpjzjtsbbyr", (long)Long.parseLong(orgId))) {
            isFromImport = true;
        }
        if (!isFromImport) {
            return maps;
        }
        List<DynamicObjectCollection> draftDetailCollections = this.getDraftDetailCollection(Long.valueOf(orgId), DateUtils.stringToDate((String)startDate), DateUtils.stringToDate((String)endDate));
        for (DynamicObjectCollection draftDetailCollection : draftDetailCollections) {
            List<Map<String, String>> list = this.packDynrow(draftDetailCollection, "ncphdkcjsdk4_dth#1");
            for (int i = 0; i < list.size(); ++i) {
                Map<String, Object> resultMap = this.getResultMap(draftDetailCollection, list.get(i), i + 1);
                maps.add(resultMap);
            }
        }
        return maps;
    }

    public List<DynamicObjectCollection> getDraftDetailCollection(Long orgId, Date skssqq, Date skssqz) {
        ArrayList<DynamicObjectCollection> result = new ArrayList<DynamicObjectCollection>();
        QFilter q1 = new QFilter("org", "=", (Object)orgId);
        QFilter q2 = new QFilter("skssqq", ">=", (Object)skssqq);
        QFilter q3 = new QFilter("skssqz", "<=", (Object)skssqz);
        QFilter q4 = new QFilter("templateid.number", "=", (Object)"NCP_HDKC_DG_IMPORT");
        QFilter q5 = new QFilter("templatetype.number", "=", (Object)"ncpdg_import");
        DynamicObjectCollection draftCollection = QueryServiceHelper.query((String)TPO_DECLARE_MAIN_TSD, (String)"id", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5}, (String)"billno");
        if (ObjectUtils.isEmpty((Object)draftCollection)) {
            return result;
        }
        for (DynamicObject ncphdkcDraft : draftCollection) {
            result.add(QueryServiceHelper.query((String)TPO_DECLARE_DETAIL_TSD, (String)"dynrowno,index,cellnumber,value", (QFilter[])new QFilter[]{new QFilter("entryid", "=", (Object)ncphdkcDraft.getLong("id"))}, (String)"index"));
        }
        return result;
    }

    public List<Map<String, String>> packDynrow(DynamicObjectCollection collection, String dynrowno) {
        long count = collection.stream().filter(e -> dynrowno.equals(e.getString("dynrowno"))).map(e -> e.getInt("index")).distinct().count();
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>((int)count);
        int i = 0;
        while ((long)i < count) {
            list.add(new HashMap());
            ++i;
        }
        collection.stream().filter(e -> dynrowno.equals(e.getString("dynrowno"))).forEach(e -> ((Map)list.get(e.getInt("index") - 1)).put(e.getString("cellnumber"), e.getString("value")));
        return list;
    }

    public Map<String, Object> getResultMap(DynamicObjectCollection draftDetailCollection, Map<String, String> map, int index) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("tcvat_ybnsr_gjncpyyscjy#cpmc", Long.valueOf(map.getOrDefault("ncphdkcjsdk4_dth#" + index + "#ncphdkcjsdklw4_cpmc", "0")));
        resultMap.put("tcvat_ybnsr_gjncpyyscjy#hyncpmc", Long.valueOf(map.getOrDefault("ncphdkcjsdk4_dth#" + index + "#ncphdkcjsdklw4_hyncpmc", "0")));
        resultMap.put("tcvat_ybnsr_gjncpyyscjy#dqhyncpsl", this.getDraftBigDecimalValue(draftDetailCollection, "ncphdkcjsdk4_dth#" + index + "#ncphdkcjsdklw4_dqhyncpsl"));
        resultMap.put("tcvat_ybnsr_gjncpyyscjy#qckcncpsl", this.getDraftBigDecimalValue(draftDetailCollection, "ncphdkcjsdk4_dth#" + index + "#ncphdkcjsdklw4_qckcncpsl"));
        resultMap.put("tcvat_ybnsr_gjncpyyscjy#qcpjmj", this.getDraftBigDecimalValue(draftDetailCollection, "ncphdkcjsdk4_dth#" + index + "#ncphdkcjsdklw4_qcpjmj"));
        resultMap.put("tcvat_ybnsr_gjncpyyscjy#dqgjncpsl", this.getDraftBigDecimalValue(draftDetailCollection, "ncphdkcjsdk4_dth#" + index + "#ncphdkcjsdklw4_dqgjncpsl"));
        resultMap.put("tcvat_ybnsr_gjncpyyscjy#dqmj", this.getDraftBigDecimalValue(draftDetailCollection, "ncphdkcjsdk4_dth#" + index + "#ncphdkcjsdklw4_dqmj"));
        resultMap.put("tcvat_ybnsr_gjncpyyscjy#kcl", this.getDraftBigDecimalValue(draftDetailCollection, "ncphdkcjsdk4_dth#" + index + "#ncphdkcjsdklw4_kcl"));
        return resultMap;
    }

    public BigDecimal getDraftBigDecimalValue(DynamicObjectCollection draftDetailCollection, String cellNumber) {
        BigDecimal result = BigDecimal.ZERO;
        Optional<DynamicObject> optional = draftDetailCollection.stream().filter(e -> cellNumber.equals(e.getString("cellnumber"))).findFirst();
        if (optional.isPresent()) {
            result = BigDecimalUtil.toBigDecimal((Object)optional.get().getString("value"));
        }
        return result;
    }
}

