/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.dynamicrow;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicListBasePlugin;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.admindivision.AdminDivisionUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.utils.BigDecimalUtil;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;
import org.apache.commons.compress.utils.Sets;
import org.apache.commons.lang3.ObjectUtils;

public class TcvatTrccfFetchDataPlugin
extends AbstractDynamicListBasePlugin {
    public static final String TPO_DECLARE_MAIN_TSD = "tpo_declare_main_tsd";
    public static final String TPO_DECLARE_DETAIL_TSD = "tpo_declare_detail_tsd";
    private static final Long VAT202206_A = 1389922186361365504L;
    private static final Long VAT202206_HUNAN = 1447826235349590016L;
    private static final Long VAT202206_HNGX = 1636309081566231552L;
    public static final Set<Long> FROMIMPORT = Sets.newHashSet((Object[])new Long[]{VAT202206_A, VAT202206_HUNAN, VAT202206_HNGX});

    public List<Map<String, Object>> query(BussinessParamsVo bussinessParamsVo) {
        Long templateId;
        String endDate;
        String startDate;
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>(16);
        Map extendParams = bussinessParamsVo.getExtendParams();
        String orgId = (String)extendParams.get("orgId");
        if (ObjectUtils.anyNull((Object[])new Object[]{orgId, startDate = (String)extendParams.get("startdate"), endDate = (String)extendParams.get("enddate"), templateId = (Long)extendParams.get("templateId")})) {
            return maps;
        }
        boolean isFromImport = false;
        if (FROMIMPORT.contains(templateId) && SystemParamUtil.getZeroDeclareParameter((String)"tcvat", (String)"ncpjzjtsbbyr", (long)Long.parseLong(orgId))) {
            isFromImport = true;
        }
        boolean isSpecialProvince = this.isSpecialProvince(Long.valueOf(orgId));
        List<DynamicObjectCollection> draftDetailCollections = this.getDraftDetailCollection(Long.valueOf(orgId), DateUtils.stringToDate((String)startDate), DateUtils.stringToDate((String)endDate), isFromImport);
        for (DynamicObjectCollection draftDetailCollection : draftDetailCollections) {
            int i;
            List<Map<String, String>> list1;
            if (isFromImport) {
                list1 = this.packDynrow(draftDetailCollection, "ncphdkcjsdk2_dth#1");
                for (i = 0; i < list1.size(); ++i) {
                    Map<String, Object> resultMap = this.getResultMap(draftDetailCollection, list1.get(i), i + 1);
                    maps.add(resultMap);
                }
                continue;
            }
            list1 = this.packDynrow(draftDetailCollection, "jxsejsdgdth#1");
            for (i = 0; i < list1.size(); ++i) {
                Map<String, Object> resultMap = this.getResultMap(draftDetailCollection, list1.get(i), i + 1, false);
                maps.add(resultMap);
            }
            List<Object> list2 = new ArrayList();
            if (isSpecialProvince) {
                list2 = this.packRow(draftDetailCollection, "jxsedeggdh#");
            }
            for (int i2 = 0; i2 < list2.size(); ++i2) {
                Map<String, Object> resultMap = this.getResultMap(draftDetailCollection, (Map)list2.get(i2), i2 + 1, true);
                maps.add(resultMap);
            }
        }
        return maps;
    }

    public List<DynamicObjectCollection> getDraftDetailCollection(Long orgId, Date skssqq, Date skssqz, boolean flag) {
        String templatetype;
        QFilter q5;
        ArrayList<DynamicObjectCollection> result = new ArrayList<DynamicObjectCollection>();
        QFilter q1 = new QFilter("org", "=", (Object)orgId);
        QFilter q2 = new QFilter("skssqq", ">=", (Object)skssqq);
        QFilter q3 = new QFilter("skssqz", "<=", (Object)skssqz);
        String templateid = flag ? "NCP_HDKC_DG_IMPORT" : "NCP_HDKC_DG";
        QFilter q4 = new QFilter("templateid.number", "=", (Object)templateid);
        DynamicObjectCollection draftCollection = QueryServiceHelper.query((String)TPO_DECLARE_MAIN_TSD, (String)"id", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5 = new QFilter("templatetype.number", "=", (Object)(templatetype = flag ? "ncpdg_import" : "ncpdg"))}, (String)"billno");
        if (ObjectUtils.isEmpty((Object)draftCollection)) {
            return result;
        }
        for (DynamicObject ncphdkcDraft : draftCollection) {
            result.add(QueryServiceHelper.query((String)TPO_DECLARE_DETAIL_TSD, (String)"dynrowno,index,cellnumber,value", (QFilter[])new QFilter[]{new QFilter("entryid", "=", (Object)ncphdkcDraft.getLong("id"))}, (String)"index"));
        }
        return result;
    }

    public boolean isSpecialProvince(Long orgId) {
        TaxResult taxMain = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgId);
        if (EmptyCheckUtils.isNotEmpty((Object)taxMain.getData())) {
            String registeradd = ((DynamicObject)taxMain.getData()).getString("registeraddress");
            boolean isLiaoning = AdminDivisionUtils.isSameTargetLevel((String)"1", (String)"2215", (String)registeradd);
            boolean isJiLin = AdminDivisionUtils.isSameTargetLevel((String)"1", (String)"2147", (String)registeradd);
            return isLiaoning || isJiLin;
        }
        return false;
    }

    public List<Map<String, String>> packDynrow(DynamicObjectCollection collection, String dynrowno) {
        long count = collection.stream().filter(e -> dynrowno.equals(e.getString("dynrowno"))).map(e -> e.getInt("index")).distinct().count();
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>((int)count);
        int i = 0;
        while ((long)i < count) {
            list.add(new HashMap());
            ++i;
        }
        collection.stream().filter(e -> dynrowno.equals(e.getString("dynrowno"))).forEach(e -> ((Map)list.get(e.getInt("index") - 1)).put(e.getString("cellnumber"), e.getString("value")));
        return list;
    }

    public List<Map<String, String>> packRow(DynamicObjectCollection collection, String row) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(1);
        HashMap map = new HashMap();
        collection.stream().filter(e -> e.getString("cellnumber").startsWith(row)).forEach(e -> map.put(e.getString("cellnumber"), e.getString("value")));
        list.add(map);
        return list;
    }

    public Map<String, Object> getResultMap(DynamicObjectCollection draftDetailCollection, Map<String, String> map, int index) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("tcvat_ybnsr_trccfhdncp#cpmc", Long.valueOf(map.getOrDefault("ncphdkcjsdk2_dth#" + index + "#ncphdkcjsdklw2_cpmc", "0")));
        resultMap.put("tcvat_ybnsr_trccfhdncp#hyncpmc", Long.valueOf(map.getOrDefault("ncphdkcjsdk2_dth#" + index + "#ncphdkcjsdklw2_hyncpmc", "0")));
        resultMap.put("tcvat_ybnsr_trccfhdncp#hddhsl", BigDecimalUtil.toBigDecimal((Object)map.getOrDefault("ncphdkcjsdk2_dth#" + index + "#ncphdkcjsdklw2_hddhsl", "0")));
        resultMap.put("tcvat_ybnsr_trccfhdncp#qckcncpsl", BigDecimalUtil.toBigDecimal((Object)map.getOrDefault("ncphdkcjsdk2_dth#" + index + "#ncphdkcjsdklw2_qckcncpsl", "0")));
        resultMap.put("tcvat_ybnsr_trccfhdncp#qcpjmj", BigDecimalUtil.toBigDecimal((Object)map.getOrDefault("ncphdkcjsdk2_dth#" + index + "#ncphdkcjsdklw2_qcpjmj", "0")));
        resultMap.put("tcvat_ybnsr_trccfhdncp#dqgjncpsl", BigDecimalUtil.toBigDecimal((Object)map.getOrDefault("ncphdkcjsdk2_dth#" + index + "#ncphdkcjsdklw2_dqgjncpsl", "0")));
        resultMap.put("tcvat_ybnsr_trccfhdncp#dqmj", BigDecimalUtil.toBigDecimal((Object)map.getOrDefault("ncphdkcjsdk2_dth#" + index + "#ncphdkcjsdklw2_dqmj", "0")));
        resultMap.put("tcvat_ybnsr_trccfhdncp#dqxshwsl", BigDecimalUtil.toBigDecimal((Object)map.getOrDefault("ncphdkcjsdk2_dth#" + index + "#ncphdkcjsdklw2_dqxshwsl", "0")));
        resultMap.put("tcvat_ybnsr_trccfhdncp#kcl", BigDecimalUtil.toBigDecimal((Object)map.getOrDefault("ncphdkcjsdk2_dth#" + index + "#ncphdkcjsdklw2_kcl", "0")));
        return resultMap;
    }

    public Map<String, Object> getResultMap(DynamicObjectCollection draftDetailCollection, Map<String, String> map, int index, boolean isSpecialProvince) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("tcvat_ybnsr_trccfhdncp#cpmc", isSpecialProvince ? Long.valueOf(map.getOrDefault("jxsedeggdh#jxse_sbcpmc", "0")) : Long.valueOf(map.getOrDefault("jxsejsdgdth#" + index + "#jxse_sbcpmc", "0")));
        resultMap.put("tcvat_ybnsr_trccfhdncp#hyncpmc", isSpecialProvince ? Long.valueOf(map.getOrDefault("jxsedeggdh#jxse_sbhyncpmc", "0")) : Long.valueOf(map.getOrDefault("jxsejsdgdth#" + index + "#jxse_sbhyncpmc", "0")));
        resultMap.put("tcvat_ybnsr_trccfhdncp#hddhsl", isSpecialProvince ? BigDecimalUtil.toBigDecimal((Object)map.getOrDefault("jxsedeggdh#jxse_sbdh", "0")) : BigDecimalUtil.toBigDecimal((Object)map.getOrDefault("jxsejsdgdth#" + index + "#jxse_sbdh", "0")));
        resultMap.put("tcvat_ybnsr_trccfhdncp#qckcncpsl", isSpecialProvince ? this.getDraftBigDecimalValue(draftDetailCollection, "gjzjxsdyggdh#gjzj_sl") : this.getDraftBigDecimalValue(draftDetailCollection, "sjgdyhgdh#sjg_sl"));
        resultMap.put("tcvat_ybnsr_trccfhdncp#qcpjmj", isSpecialProvince ? this.getDraftBigDecimalValue(draftDetailCollection, "gjzjxsdyggdh#gjzj_pjgmdj") : this.getDraftBigDecimalValue(draftDetailCollection, "sjgdyhgdh#sjg_pjgmdj"));
        resultMap.put("tcvat_ybnsr_trccfhdncp#dqgjncpsl", isSpecialProvince ? this.getDraftBigDecimalValue(draftDetailCollection, "gjzjxsbqxjgdh#gjzj_sl").subtract(this.getDraftBigDecimalValue(draftDetailCollection, "gjzjxsdyggdh#gjzj_sl")) : this.getDraftBigDecimalValue(draftDetailCollection, "sjgbqxjgdh#sjg_sl").subtract(this.getDraftBigDecimalValue(draftDetailCollection, "sjgdyhgdh#sjg_sl")));
        resultMap.put("tcvat_ybnsr_trccfhdncp#dqmj", isSpecialProvince ? this.getDraftBigDecimalValue(draftDetailCollection, "gjzjxsqmhjgdh#gjzj_dqmj") : this.getDraftBigDecimalValue(draftDetailCollection, "sjgqmhjgdh#sjg_dqmj"));
        resultMap.put("tcvat_ybnsr_trccfhdncp#dqxshwsl", isSpecialProvince ? BigDecimalUtil.toBigDecimal((Object)map.getOrDefault("jxsedeggdh#jxse_dqxshwsl", "0")) : BigDecimalUtil.toBigDecimal((Object)map.getOrDefault("jxsejsdgdth#" + index + "#jxse_dqxshwsl", "0")));
        resultMap.put("tcvat_ybnsr_trccfhdncp#kcl", isSpecialProvince ? BigDecimalUtil.toBigDecimal((Object)map.getOrDefault("jxsedeggdh#jxse_kcl", "0")) : BigDecimalUtil.toBigDecimal((Object)map.getOrDefault("jxsejsdgdth#" + index + "#jxse_kcl", "0")));
        return resultMap;
    }

    public BigDecimal getDraftBigDecimalValue(DynamicObjectCollection draftDetailCollection, String cellNumber) {
        BigDecimal result = BigDecimal.ZERO;
        Optional<DynamicObject> optional = draftDetailCollection.stream().filter(e -> cellNumber.equals(e.getString("cellnumber"))).findFirst();
        if (optional.isPresent()) {
            result = BigDecimalUtil.toBigDecimal((Object)optional.get().getString("value"));
        }
        return result;
    }
}

