/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.dynamicrow;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicListBasePlugin;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;
import kd.taxc.tcvat.business.service.engine.impl.utils.IncomeUtils;
import kd.taxc.tcvat.business.service.engine.task.NewRuleSettingTask;
import kd.taxc.tcvat.common.util.UUID;

public class TcvatWkpsrTzFetchDataPlugin
extends AbstractDynamicListBasePlugin {
    private static Log logger = LogFactory.getLog(TcvatWkpsrTzFetchDataPlugin.class);
    private static final Set<String> RATE1 = Sets.newHashSet((Object[])new String[]{"13%", "16%", "17%"});
    private static final Set<String> RATE2 = Sets.newHashSet((Object[])new String[]{"9%", "10%", "11%"});
    private static final String DYNAMIC_TABLE = "tcvat_wkpsr_data";
    private static final String SPLIT = "#";
    private static final String PAGE_ACCOUNTING_DETAIL = "tcvat_accdetail_income";
    private static final String PAGE_INVOICE_ACCOUNTING_DETAIL = "tcvat_income_invoice";
    private static final Map<String, String> rowLevyTypeNameMap = new HashMap<String, String>(){
        {
            this.put("1", ResManager.loadKDString((String)"\u4e00\u822c\u8ba1\u7a0e", (String)"TcvatWkpsrTzFetchDataPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.put("2", ResManager.loadKDString((String)"\u4e00\u822c\u8ba1\u7a0e", (String)"TcvatWkpsrTzFetchDataPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.put("3", ResManager.loadKDString((String)"\u4e00\u822c\u8ba1\u7a0e", (String)"TcvatWkpsrTzFetchDataPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.put("4", ResManager.loadKDString((String)"\u4e00\u822c\u8ba1\u7a0e", (String)"TcvatWkpsrTzFetchDataPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.put("5", ResManager.loadKDString((String)"\u4e00\u822c\u8ba1\u7a0e", (String)"TcvatWkpsrTzFetchDataPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.put("6", ResManager.loadKDString((String)"\u7b80\u6613\u8ba1\u7a0e", (String)"TcvatWkpsrTzFetchDataPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.put("7", ResManager.loadKDString((String)"\u7b80\u6613\u8ba1\u7a0e", (String)"TcvatWkpsrTzFetchDataPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.put("8", ResManager.loadKDString((String)"\u7b80\u6613\u8ba1\u7a0e", (String)"TcvatWkpsrTzFetchDataPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.put("9", ResManager.loadKDString((String)"\u7b80\u6613\u8ba1\u7a0e", (String)"TcvatWkpsrTzFetchDataPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.put("10", ResManager.loadKDString((String)"\u514d\u62b5\u9000\u7a0e", (String)"TcvatWkpsrTzFetchDataPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.put("11", ResManager.loadKDString((String)"\u514d\u62b5\u9000\u7a0e", (String)"TcvatWkpsrTzFetchDataPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.put("12", ResManager.loadKDString((String)"\u514d\u7a0e", (String)"TcvatWkpsrTzFetchDataPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.put("13", ResManager.loadKDString((String)"\u514d\u7a0e", (String)"TcvatWkpsrTzFetchDataPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
    };

    public List<Map<String, Object>> query(BussinessParamsVo bussinessParamsVo) {
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>(16);
        Map extendParams = bussinessParamsVo.getExtendParams();
        String orgId = (String)extendParams.get("orgId");
        String startdate = (String)extendParams.get("startdate");
        String enddate = (String)extendParams.get("enddate");
        List wkpsrRules = (List)RuleUtils.getSharingAndOrgRules((Long)Long.parseLong(orgId), (RuleTypeEnum)RuleTypeEnum.WKPSR, (String)"ybnsr", (String)"nssb").get(RuleTypeEnum.WKPSR);
        Object[] incomeRuleIds = wkpsrRules.stream().map(r -> r.getLong("rulename.id")).toArray();
        DynamicObject[] incomeRules = BusinessDataServiceHelper.load((Object[])incomeRuleIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tcvat_rule_income"));
        Map<Long, DynamicObject> incomeRuleMap = Stream.of(incomeRules).collect(Collectors.toMap(d -> d.getLong("id"), d -> d));
        Map<String, List<DynamicObject>> ruleMap = this.initRuleMap(wkpsrRules);
        EngineModel engineModel = new EngineModel(orgId, startdate, enddate);
        for (Map.Entry<String, List<DynamicObject>> entry : ruleMap.entrySet()) {
            String seq = entry.getKey();
            String dynRowNo = (String)extendParams.get("dynRowNo");
            if (dynRowNo == null || !dynRowNo.startsWith(DYNAMIC_TABLE + seq + SPLIT)) continue;
            List<DynamicObject> rules = entry.getValue();
            for (int i = 0; i < rules.size(); ++i) {
                DynamicObject rule = rules.get(i);
                HashMap<String, Object> result = new HashMap<String, Object>();
                String seqno = seq + "." + (i + 1);
                result.put(DYNAMIC_TABLE + seq + SPLIT + "seqno", seqno);
                String bizname = rule.getString("rulename.name");
                rule.set("name", (Object)bizname);
                result.put(DYNAMIC_TABLE + seq + SPLIT + "bizname", bizname);
                result.put(DYNAMIC_TABLE + seq + SPLIT + "levytype", rowLevyTypeNameMap.get(seq));
                BigDecimal yssr = this.fetchRuleAmount(startdate, rule, engineModel, rule.getDynamicObjectCollection("entryentity"), rule.getString("rulename.taxrate.number"), "");
                result.put(DYNAMIC_TABLE + seq + SPLIT + "yssr", yssr);
                long incomeRuleId = rule.getDynamicObject("rulename").getLong("id");
                DynamicObject incomeRule = incomeRuleMap.get(incomeRuleId);
                String taxrate = incomeRule.getString("taxrate.number");
                BigDecimal rate = new BigDecimal(taxrate.replace("%", ""));
                result.put(DYNAMIC_TABLE + seq + SPLIT + "sl", rate);
                BigDecimal invoiceamount = this.fetchRuleAmount(startdate, incomeRule, engineModel, incomeRule.getDynamicObjectCollection("invoiceentity"), taxrate, "12");
                BigDecimal qtfpbhssr = this.fetchRuleAmount(startdate, incomeRule, engineModel, incomeRule.getDynamicObjectCollection("entryentity1"), taxrate, "1");
                BigDecimal ykpsr = invoiceamount.add(qtfpbhssr);
                result.put(DYNAMIC_TABLE + seq + SPLIT + "ykpsr", ykpsr);
                result.put(DYNAMIC_TABLE + seq + SPLIT + "bqsjwkjfpxse", yssr.subtract(ykpsr));
                result.put(DYNAMIC_TABLE + seq + SPLIT + "wkjfpxsetzl", BigDecimal.ZERO);
                maps.add(result);
            }
        }
        return maps;
    }

    private Map<String, List<DynamicObject>> initRuleMap(List<DynamicObject> wkpsrRules) {
        Set businessTypesIds = wkpsrRules.stream().flatMap(r -> r.getDynamicObjectCollection("rulename.businesstype").stream()).map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
        DynamicObjectCollection businessTypes = QueryServiceHelper.query((String)"tpo_tcvat_taxrateentry", (String)"id,mergecode", (QFilter[])new QFilter[]{new QFilter("id", "in", businessTypesIds)});
        Map<Long, String> mergecodeMap = businessTypes.stream().collect(Collectors.toMap(b -> b.getLong("id"), b -> b.getString("mergecode")));
        HashMap<String, List<DynamicObject>> ruleMap = new HashMap<String, List<DynamicObject>>();
        for (DynamicObject wkpsrRule : wkpsrRules) {
            String taxrate = wkpsrRule.getString("rulename.taxrate.number");
            String taxation = wkpsrRule.getString("rulename.taxation.number");
            Set<String> mergecodeSet = wkpsrRule.getDynamicObjectCollection("rulename.businesstype").stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).map(mergecodeMap::get).collect(Collectors.toSet());
            if (RATE1.contains(taxrate) && "YBJS".equals(taxation)) {
                this.addRuleMap(mergecodeSet, ruleMap, wkpsrRule, 1, 2);
                continue;
            }
            if (RATE2.contains(taxrate) && "YBJS".equals(taxation)) {
                this.addRuleMap(mergecodeSet, ruleMap, wkpsrRule, 3, 4);
                continue;
            }
            if ("6%".equals(taxrate) && "YBJS".equals(taxation)) {
                this.addRuleMap(mergecodeSet, ruleMap, wkpsrRule, null, 5);
                continue;
            }
            if ("5%".equals(taxrate) && "JYZS_5".equals(taxation)) {
                this.addRuleMap(mergecodeSet, ruleMap, wkpsrRule, 6, 7);
                continue;
            }
            if ("3%".equals(taxrate) && "JYZS_3".equals(taxation)) {
                this.addRuleMap(mergecodeSet, ruleMap, wkpsrRule, 8, 9);
                continue;
            }
            if ("Export_02".equals(taxation)) {
                this.addRuleMap(mergecodeSet, ruleMap, wkpsrRule, 10, 11);
                continue;
            }
            if (!"MS".equals(taxation) && !"Export_01".equals(taxation)) continue;
            this.addRuleMap(mergecodeSet, ruleMap, wkpsrRule, 12, 13);
        }
        return ruleMap;
    }

    private void addRuleMap(Set<String> mergecodeSet, Map<String, List<DynamicObject>> ruleMap, DynamicObject wkpsrRule, Integer line12, Integer line345) {
        boolean anyMatch345;
        List rules;
        boolean anyMatch12;
        Function<String, List> stringListFunction = a -> new ArrayList(16);
        if (line12 != null && (anyMatch12 = mergecodeSet.stream().anyMatch(s -> s.startsWith("1") || s.startsWith("2")))) {
            rules = ruleMap.computeIfAbsent(String.valueOf(line12), stringListFunction);
            rules.add(wkpsrRule);
        }
        if (line345 != null && (anyMatch345 = mergecodeSet.stream().anyMatch(s -> s.startsWith("3") || s.startsWith("4") || s.startsWith("5")))) {
            rules = ruleMap.computeIfAbsent(String.valueOf(line345), stringListFunction);
            rules.add(wkpsrRule);
        }
    }

    private BigDecimal fetchRuleAmount(String startdate, DynamicObject rule, EngineModel engineModel, DynamicObjectCollection entryentity, String taxRate, String suffix) {
        String serialno = UUID.randomUUID();
        NewRuleSettingTask yssrTask = "12".equals(suffix) ? new NewRuleSettingTask(new ConcurrentHashMap<String, String>(), new ConcurrentHashMap<String, Map<String, Object>>(), rule, engineModel, entryentity, serialno, PAGE_INVOICE_ACCOUNTING_DETAIL, taxRate, suffix, "amount", startdate.substring(0, 7)) : new NewRuleSettingTask(new ConcurrentHashMap<String, String>(), new ConcurrentHashMap<String, Map<String, Object>>(), rule, engineModel, entryentity, serialno, PAGE_ACCOUNTING_DETAIL, taxRate, suffix, "amount", startdate.substring(0, 7));
        List yssrFuture = ThreadPoolsService.getInstance().submitReturnFuture((Task)yssrTask);
        List<DynamicObject> yssrList = this.getFutureList(yssrFuture);
        return IncomeUtils.getInvoiceTotalAmount(yssrList, "12".equals(suffix) ? "invoiceamount" : "amount");
    }

    private List<DynamicObject> getFutureList(List<Future<Object>> futures) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        try {
            for (Future<Object> future : futures) {
                list.addAll((Collection)future.get());
            }
        }
        catch (Exception e) {
            logger.error("getFutureList error " + e);
        }
        return list;
    }
}

