/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.dynamicrow;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicListBasePlugin;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;
import kd.taxc.tcvat.business.service.zlb.ZlbService;

public class TcvatYbYzFzTaxShareCalculateFetchDataPlugin
extends AbstractDynamicListBasePlugin {
    public List<Map<String, Object>> query(BussinessParamsVo bussinessParamsVo) {
        ArrayList<Map<String, Object>> resultMapList = new ArrayList<Map<String, Object>>(10);
        Map extendParams = bussinessParamsVo.getExtendParams();
        long orgId = Long.parseLong((String)extendParams.get("orgid"));
        String startdate = (String)extendParams.get("startdate");
        String enddate = (String)extendParams.get("enddate");
        Date skssqq = DateUtils.stringToDate((String)startdate);
        Date skssqz = DateUtils.stringToDate((String)enddate);
        QFilter dateFilter = new QFilter("startdate", "=", (Object)skssqq).and(new QFilter("enddate", "=", (Object)skssqz));
        DynamicObject collection = OrgUtils.getOrgDeclarePlan((Long)orgId, (Date)skssqq, (Date)skssqz);
        if (null == collection) {
            return resultMapList;
        }
        String currentOrg = (String)extendParams.get("orgid");
        List planOrgList = collection.getDynamicObjectCollection("orgrow").stream().filter(c -> c.getDynamicObject("orgid").getString("id").equals(currentOrg)).collect(Collectors.toList());
        DynamicObjectCollection orgrow = collection.getDynamicObjectCollection("orgrow");
        Long parentId = 0L;
        ArrayList<Long> orglist = new ArrayList<Long>(orgrow.size());
        for (DynamicObject obj : orgrow) {
            if (null == obj.getDynamicObject("parentid")) continue;
            String orgid = obj.getDynamicObject("orgid").getString("id");
            if (orgid.equals(currentOrg)) {
                parentId = obj.getDynamicObject("parentid").getLong("id");
                orglist.add(Long.valueOf(orgid));
                continue;
            }
            if (!obj.getDynamicObject("parentid").getString("id").equals(currentOrg)) continue;
            orglist.add(Long.valueOf(orgid));
        }
        DynamicObject[] policyConfirm = BusinessDataServiceHelper.load((String)"tcvat_ybhz_policy_confirm", (String)"hzentryentity.assignorg , hzentryentity.levelname", (QFilter[])new QFilter[]{new QFilter("orgid", "=", (Object)parentId), dateFilter, new QFilter("draftpurpose", "=", (Object)"nssb")}, (String)"hzentryentity.levelname");
        if (policyConfirm.length == 0) {
            return resultMapList;
        }
        DynamicObjectCollection hzentryentity = policyConfirm[0].getDynamicObjectCollection("hzentryentity");
        List suborgList = hzentryentity.stream().filter(h -> "3".equals(h.getString("levelname"))).map(h -> h.getDynamicObject("assignorg").getLong("id")).collect(Collectors.toList());
        suborgList.retainAll(orglist);
        if (suborgList.size() == 0) {
            return resultMapList;
        }
        BigDecimal ybxm = ZlbService.queryHzZlbAmount(parentId.toString(), startdate, enddate, "draft_zzsybnsr_ybhz", "31", "ybxm");
        BigDecimal jzjtxm = ZlbService.queryHzZlbAmount(parentId.toString(), startdate, enddate, "draft_zzsybnsr_ybhz", "31", "jzjtxm");
        BigDecimal ybts = ybxm.add(jzjtxm);
        HashMap jyjsffynseMap = new HashMap();
        if (ybts.compareTo(BigDecimal.ZERO) > 0) {
            DynamicObjectCollection query = QueryServiceHelper.query((String)"tcvat_hz_account_summary", (String)"suborg,totaltaxamount", (QFilter[])new QFilter[]{new QFilter("suborg", "in", suborgList), dateFilter, new QFilter("taxpayertype", "=", (Object)"zzsybnsr_yz_zjg"), new QFilter("taxrate", "in", Arrays.asList("3%", "5%"))});
            Map<Long, List<DynamicObject>> suborgMap = query.stream().collect(Collectors.groupingBy(o -> o.getLong("suborg")));
            suborgMap.forEach((k, v) -> {
                BigDecimal totaltaxamount = v.stream().map(o -> o.getBigDecimal("totaltaxamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                jyjsffynseMap.put(k, totaltaxamount);
            });
        }
        DynamicObjectCollection apportionCollection = QueryServiceHelper.query((String)"tcvat_zlb_yz_apportion", (String)"suborg,normaltaxsale,normaltaxamount,simpletaxamount,totaltaxamount", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)parentId), dateFilter});
        Map<String, DynamicObject> suborgDataMap = apportionCollection.stream().collect(Collectors.toMap(k -> k.getString("suborg"), v -> v, (k1, k2) -> k1));
        for (Long suborg : suborgList) {
            DynamicObject object = suborgDataMap.get(String.valueOf(suborg));
            HashMap<String, Object> rowMap = new HashMap<String, Object>(6);
            DynamicObject taxmain = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)object.getLong("suborg")).getData();
            rowMap.put("tcvat_ybhz_yz_zfjgfpb#corporatename", "");
            rowMap.put("tcvat_ybhz_yz_zfjgfpb#unifiedsocialcode", "");
            rowMap.put("tcvat_ybhz_yz_zfjgfpb#taxoffice", "");
            if (null != taxmain) {
                rowMap.put("tcvat_ybhz_yz_zfjgfpb#corporatename", taxmain.getDynamicObject("taxorg").getString("taxpayer"));
                rowMap.put("tcvat_ybhz_yz_zfjgfpb#unifiedsocialcode", taxmain.getDynamicObject("taxorg").getString("unifiedsocialcode"));
                rowMap.put("tcvat_ybhz_yz_zfjgfpb#taxoffice", taxmain.getDynamicObject("taxoffice").getString("id"));
            }
            rowMap.put("tcvat_ybhz_yz_zfjgfpb#jyjsynse", jyjsffynseMap.getOrDefault(suborg, BigDecimal.ZERO));
            rowMap.put("tcvat_ybhz_yz_zfjgfpb#normaltaxsale", object.getBigDecimal("normaltaxsale"));
            resultMapList.add(rowMap);
        }
        return resultMapList;
    }
}

