/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.dynamicrow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.assist.AssistService;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicListBasePlugin;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;

public class TcvatYbhzFb5FetchDataPlugin
extends AbstractDynamicListBasePlugin {
    private static final String YBHZ_ZLB_JGFPB = "tcvat_ybhz_zlb_jgfpb";
    private static final String DYNAMIC_TABLE = "tcvat_ybhz_fjsf_fpb";
    private static final String SPLIT = "#";
    private static Map<String, String> collectionMap = new HashMap<String, String>(4){
        {
            this.put("cityarea", ResManager.loadKDString((String)"\u5e02\u533a\uff08\u589e\u503c\u7a0e\u9644\u5f81\uff09", (String)"TcvatYbhzFb5FetchDataPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.put("nocityarea", ResManager.loadKDString((String)"\u53bf\u57ce\u3001\u9547\uff08\u589e\u503c\u7a0e\u9644\u5f81\uff09", (String)"TcvatYbhzFb5FetchDataPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.put("otherarea", ResManager.loadKDString((String)"\u5176\u4ed6\uff08\u589e\u503c\u7a0e\u9644\u5f81\uff09", (String)"TcvatYbhzFb5FetchDataPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
    };

    public List<Map<String, Object>> query(BussinessParamsVo bussinessParamsVo) {
        String endData;
        String startData;
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>(16);
        Map extendParams = bussinessParamsVo.getExtendParams();
        String orgId = (String)extendParams.get("orgId");
        DynamicObjectCollection jgfpbList = this.queryZlbJgfpb(orgId, startData = (String)extendParams.get("startdate"), endData = (String)extendParams.get("enddate"));
        if (!jgfpbList.isEmpty()) {
            List<Long> suborgList = jgfpbList.stream().map(o -> o.getLong("suborg")).collect(Collectors.toList());
            TaxResult taxResult = TaxcMainDataServiceHelper.queryTaxcMainFjsfByOrgId(suborgList);
            Map<Long, DynamicObject> orgidMap = ((List)taxResult.getData()).stream().filter(d -> EmptyCheckUtils.isNotEmpty((Object)d.getDynamicObjectCollection("categoryentryentity"))).collect(Collectors.toMap(a -> a.getLong("taxorg.id"), b -> (DynamicObject)b.getDynamicObjectCollection("categoryentryentity").get(0), (m, n) -> m));
            Map<Long, DynamicObject> nsrDataMap = this.queryOrgUnifiedsocialcodeAndTaxpayer(suborgList);
            List<String> zsxmList = this.getZsxmList();
            for (DynamicObject row : jgfpbList) {
                long suborg = row.getLong("suborg");
                DynamicObject nsrData = nsrDataMap.get(suborg);
                DynamicObject taxMain = orgidMap.get(suborg);
                if (nsrData == null || taxMain == null) continue;
                String cswhjssenable1 = "1".equals(taxMain.getString("cswhjssenable")) ? "1" : "0";
                String jyffjenable1 = "2".equals(taxMain.getString("jyffjenable")) ? "1" : "0";
                String dfjyffjenable1 = "3".equals(taxMain.getString("dfjyffjenable")) ? "1" : "0";
                for (String zsxm : zsxmList) {
                    HashMap<String, Object> result = new HashMap<String, Object>();
                    result.put("tcvat_ybhz_fjsf_fpb#nsrsbh", nsrData.getString("unifiedsocialcode"));
                    result.put("tcvat_ybhz_fjsf_fpb#nsrmc", nsrData.getString("taxpayer"));
                    result.put("tcvat_ybhz_fjsf_fpb#zsxm", zsxm);
                    result.put("tcvat_ybhz_fjsf_fpb#jsyj", row.getBigDecimal("fpse").add(row.getBigDecimal("jzjtfpse")).add(row.getBigDecimal("ysfwfpse")).add(row.getBigDecimal("ysfwjzjtfpse")));
                    String sl = "0";
                    String zspm = "";
                    if (ResManager.loadKDString((String)"\u57ce\u5e02\u7ef4\u62a4\u5efa\u8bbe\u7a0e", (String)"TcvatYbhzFb5FetchDataPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]).equals(zsxm)) {
                        sl = "1".equals(cswhjssenable1) ? this.getPolicyParams("CSWHJSS", startData, endData, String.valueOf(suborg)) : "0";
                        zspm = collectionMap.getOrDefault(taxMain.getString("orgplace"), "cityarea");
                    } else if (ResManager.loadKDString((String)"\u6559\u80b2\u8d39\u9644\u52a0", (String)"TcvatYbhzFb5FetchDataPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]).equals(zsxm)) {
                        sl = "1".equals(jyffjenable1) ? this.getPolicyParams("JYFFJ", startData, endData, String.valueOf(suborg)) : "0";
                        zspm = ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u6559\u80b2\u8d39\u9644\u52a0", (String)"TcvatYbhzFb5FetchDataPlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]);
                    } else if (ResManager.loadKDString((String)"\u5730\u65b9\u6559\u80b2\u9644\u52a0", (String)"TcvatYbhzFb5FetchDataPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]).equals(zsxm)) {
                        sl = "1".equals(dfjyffjenable1) ? this.getPolicyParams("DFJYFJ", startData, endData, String.valueOf(suborg)) : "0";
                        zspm = ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u5730\u65b9\u6559\u80b2\u9644\u52a0", (String)"TcvatYbhzFb5FetchDataPlugin_7", (String)"taxc-tcvat", (Object[])new Object[0]);
                    }
                    result.put("tcvat_ybhz_fjsf_fpb#zspm", zspm);
                    result.put("tcvat_ybhz_fjsf_fpb#sl", sl);
                    maps.add(result);
                }
            }
        }
        return maps;
    }

    private List<String> getZsxmList() {
        return Arrays.asList(ResManager.loadKDString((String)"\u57ce\u5e02\u7ef4\u62a4\u5efa\u8bbe\u7a0e", (String)"TcvatYbhzFb5FetchDataPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6559\u80b2\u8d39\u9644\u52a0", (String)"TcvatYbhzFb5FetchDataPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5730\u65b9\u6559\u80b2\u9644\u52a0", (String)"TcvatYbhzFb5FetchDataPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
    }

    private DynamicObjectCollection queryZlbJgfpb(String orgId, String startData, String endData) {
        QFilter orgIdFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        QFilter startFilter = new QFilter("startdate", "=", (Object)DateUtils.stringToDate((String)startData));
        QFilter endFilter = new QFilter("enddate", "=", (Object)DateUtils.stringToDate((String)endData));
        QFilter declarationFilter = new QFilter("declaration", "=", (Object)"3");
        return QueryServiceHelper.query((String)YBHZ_ZLB_JGFPB, (String)"id,org,xssr,fpbl,fpse,jzjtxssr,jzjtfpbl,jzjtfpse,ysfwxssr,ysfwfpbl,ysfwfpse,ysfwjzjtxssr,ysfwjzjtfpbl,ysfwjzjtfpse,pbsehj,suborgname,startdate,enddate,suborg,declaration,seqx", (QFilter[])new QFilter[]{orgIdFilter, startFilter, endFilter, declarationFilter}, (String)"seqx");
    }

    private Map<Long, DynamicObject> queryOrgUnifiedsocialcodeAndTaxpayer(List<Long> orgIds) {
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        DynamicObjectCollection dynamicObject = QueryServiceHelper.query((String)"bastax_taxorg", (String)"org, unifiedsocialcode, taxpayer", (QFilter[])new QFilter[]{orgFilter});
        return dynamicObject.stream().collect(Collectors.toMap(o -> o.getLong("org"), o -> o));
    }

    private String getPolicyParams(String param, String startdate, String enddate, String orgId) {
        List paramList = AssistService.queryAssistParams((String)param, (String)orgId, (String)startdate, (String)enddate);
        if (paramList.size() > 0) {
            return (String)paramList.get(0);
        }
        return "0";
    }
}

