/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.dynamicrow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicListBasePlugin;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;
import kd.taxc.tcvat.business.service.dynamicrow.DynamicRowFetchService;

public class TcvatYzFb5FetchDataPlugin
extends AbstractDynamicListBasePlugin {
    private static final String DYNAMIC_TABLE = "tcvat_ybhz_fjsf_fpb";
    private static final String SPLIT = "#";
    private static Map<String, String> collectionMap = new HashMap<String, String>(4){
        {
            this.put("cityarea", ResManager.loadKDString((String)"\u5e02\u533a\uff08\u589e\u503c\u7a0e\u9644\u5f81\uff09", (String)"TcvatYzFb5FetchDataPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.put("nocityarea", ResManager.loadKDString((String)"\u53bf\u57ce\u3001\u9547\uff08\u589e\u503c\u7a0e\u9644\u5f81\uff09", (String)"TcvatYzFb5FetchDataPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.put("otherarea", ResManager.loadKDString((String)"\u5176\u4ed6\uff08\u589e\u503c\u7a0e\u9644\u5f81\uff09", (String)"TcvatYzFb5FetchDataPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
    };

    public List<Map<String, Object>> query(BussinessParamsVo bussinessParamsVo) {
        String endData;
        String startData;
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>(16);
        Map extendParams = bussinessParamsVo.getExtendParams();
        String orgId = (String)extendParams.get("orgId");
        DynamicObjectCollection jgfpbList = DynamicRowFetchService.queryZlbJgfpb(orgId, startData = (String)extendParams.get("startdate"), endData = (String)extendParams.get("enddate"));
        if (!jgfpbList.isEmpty()) {
            List<Long> suborgList = jgfpbList.stream().map(o -> o.getLong("suborg")).collect(Collectors.toList());
            Map<Long, DynamicObject> orgidMap = DynamicRowFetchService.queryFjsfEnableMap(suborgList);
            Map<Long, DynamicObject> nsrDataMap = DynamicRowFetchService.queryOrgUnifiedsocialcodeAndTaxpayer(suborgList);
            List<String> zsxmList = DynamicRowFetchService.getZsxmList();
            for (DynamicObject row : jgfpbList) {
                long suborg = row.getLong("suborg");
                DynamicObject nsrData = nsrDataMap.get(suborg);
                DynamicObject taxMain = orgidMap.get(suborg);
                if (nsrData == null || taxMain == null) continue;
                String cswhjssenable1 = "1".equals(taxMain.getString("cswhjssenable")) ? "1" : "0";
                String jyffjenable1 = "2".equals(taxMain.getString("jyffjenable")) ? "1" : "0";
                String dfjyffjenable1 = "3".equals(taxMain.getString("dfjyffjenable")) ? "1" : "0";
                for (String zsxm : zsxmList) {
                    HashMap<String, Object> result = new HashMap<String, Object>();
                    result.put("tcvat_ybhz_fjsf_fpb#nsrsbh", nsrData.getString("unifiedsocialcode"));
                    result.put("tcvat_ybhz_fjsf_fpb#nsrmc", nsrData.getString("taxpayer"));
                    result.put("tcvat_ybhz_fjsf_fpb#zsxm", zsxm);
                    result.put("tcvat_ybhz_fjsf_fpb#jsyj", row.getBigDecimal("fpse").add(row.getBigDecimal("jzjtfpse")).add(row.getBigDecimal("ysfwfpse")).add(row.getBigDecimal("ysfwjzjtfpse")));
                    String sl = "0";
                    String zspm = "";
                    if (ResManager.loadKDString((String)"\u57ce\u5e02\u7ef4\u62a4\u5efa\u8bbe\u7a0e", (String)"TcvatYzFb5FetchDataPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]).equals(zsxm)) {
                        sl = "1".equals(cswhjssenable1) ? DynamicRowFetchService.getPolicyParams("CSWHJSS", startData, endData, String.valueOf(suborg)) : "0";
                        zspm = collectionMap.getOrDefault(taxMain.getString("orgplace"), "cityarea");
                    } else if (ResManager.loadKDString((String)"\u6559\u80b2\u8d39\u9644\u52a0", (String)"TcvatYzFb5FetchDataPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]).equals(zsxm)) {
                        sl = "1".equals(jyffjenable1) ? DynamicRowFetchService.getPolicyParams("JYFFJ", startData, endData, String.valueOf(suborg)) : "0";
                        zspm = ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u6559\u80b2\u8d39\u9644\u52a0", (String)"TcvatYzFb5FetchDataPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]);
                    } else if (ResManager.loadKDString((String)"\u5730\u65b9\u6559\u80b2\u9644\u52a0", (String)"TcvatYzFb5FetchDataPlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]).equals(zsxm)) {
                        sl = "1".equals(dfjyffjenable1) ? DynamicRowFetchService.getPolicyParams("DFJYFJ", startData, endData, String.valueOf(suborg)) : "0";
                        zspm = ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u5730\u65b9\u6559\u80b2\u9644\u52a0", (String)"TcvatYzFb5FetchDataPlugin_7", (String)"taxc-tcvat", (Object[])new Object[0]);
                    }
                    result.put("tcvat_ybhz_fjsf_fpb#zspm", zspm);
                    result.put("tcvat_ybhz_fjsf_fpb#sl", sl);
                    maps.add(result);
                }
            }
        }
        return maps;
    }
}

