/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.dynamicrow.declare;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.business.constant.TcvatTemplateConstant;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicCustomFormulaPlugin;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.tcvat.business.dynamicrow.declare.TcvatJmxmCheckFormulaDynamicCustomFormulaPlugin;

public class TcvatJmxmDynamicCustomFormulaPlugin
extends AbstractDynamicCustomFormulaPlugin {
    private static final Log logger = LogFactory.getLog(TcvatJmxmCheckFormulaDynamicCustomFormulaPlugin.class);

    public Map<String, FormulaVo> query(List<DynamicRowModel> dynList) {
        HashMap<String, FormulaVo> formulaMap = new HashMap<String, FormulaVo>();
        if (!ObjectUtils.isEmpty(dynList)) {
            ArrayList<String> logs = new ArrayList<String>();
            for (DynamicRowModel dyn : dynList) {
                if (!"tcvat_ybnsr_jsxm#2".equals(dyn.getDynRowNo())) continue;
                this.buildStaticCellFormula(formulaMap, dyn.getRowList().size(), dyn.getTemplateId());
                String zbNumber = "tcvat_ybnsr_zb";
                if (dyn.getTemplateId().compareTo(1155767441758909440L) == 0) {
                    zbNumber = "tcvat_xgm_zb";
                }
                for (int k = 0; k < dyn.getRowList().size(); ++k) {
                    Map row = (Map)dyn.getRowList().get(k);
                    int seqno = k + 2;
                    for (Map.Entry entry : row.entrySet()) {
                        if (!"tcvat_ybnsr_jsxm#bqsjdjse".equals(entry.getKey())) continue;
                        StringBuilder bqsjdjseFormulaBuilder = new StringBuilder();
                        String[] split = ((String)entry.getKey()).split("#");
                        String prefixKey = split[0] + '#';
                        String suffixKey = '#' + split[1];
                        String formulaKey = prefixKey + seqno + suffixKey;
                        String formula = this.buildDynamicFormula(seqno);
                        bqsjdjseFormulaBuilder.append("if({Q[tcvat_ybnsr_jsxm#1#bqydjse]}<0 || ({Q[").append(zbNumber).append("#1#ynse]}+{Q[").append(zbNumber).append("#3#ynse]}+{Q[").append(zbNumber).append("#1#jybfynse]}+{Q[").append(zbNumber).append("#3#jybfynse]}) < 0, 0,if({Q[tcvat_ybnsr_jsxm#1#bqydjse]}<={Q[").append(zbNumber).append("#1#ynse]}+{Q[").append(zbNumber).append("#3#ynse]}+{Q[").append(zbNumber).append("#1#jybfynse]}+{Q[").append(zbNumber).append("#3#jybfynse]},{Q[tcvat_ybnsr_jsxm#").append(seqno).append("#bqydjse]},if({Q[tcvat_ybnsr_jsxm#").append(seqno).append("#bqydjse]}>={Q[").append(zbNumber).append("#1#ynse]}+{Q[").append(zbNumber).append("#3#ynse]}+{Q[").append(zbNumber).append("#1#jybfynse]}+{Q[").append(zbNumber).append("#3#jybfynse]}").append(formula).append(",if({Q[").append(zbNumber).append("#1#ynse]}+{Q[").append(zbNumber).append("#3#ynse]}+{Q[").append(zbNumber).append("#1#jybfynse]}+{Q[").append(zbNumber).append("#3#jybfynse]}").append(formula).append("<0,0,{Q[").append(zbNumber).append("#1#ynse]}+{Q[").append(zbNumber).append("#3#ynse]}+{Q[").append(zbNumber).append("#1#jybfynse]}+{Q[").append(zbNumber).append("#3#jybfynse]}").append(formula).append("),{Q[tcvat_ybnsr_jsxm#").append(seqno).append("#bqydjse]})))");
                        FormulaVo formulaVo = new FormulaVo();
                        formulaVo.setFormula(bqsjdjseFormulaBuilder.toString());
                        formulaVo.setFormulaKey(formulaKey);
                        formulaVo.setFormulaType("1");
                        formulaVo.setDatatype("number");
                        formulaMap.put(formulaKey, formulaVo);
                        logs.add("JsxmDynoRowCalcFormula===key:{" + formulaKey + "}\u3001formula:{" + formula + "}");
                    }
                }
            }
            logger.info(((Object)logs).toString());
        }
        return formulaMap;
    }

    public void buildStaticCellFormula(Map<String, FormulaVo> formulaMap, int dynRowListSize, Long templateId) {
        StringBuilder fb4_1_bqsjdjse_formula = new StringBuilder();
        StringBuilder fb4_1_bqfse_formula = new StringBuilder();
        StringBuilder fjsf_1_2_3_xejmje_formula = new StringBuilder();
        for (int i = 2; i < dynRowListSize + 2; ++i) {
            fb4_1_bqsjdjse_formula.append("if({Q[tcvat_ybnsr_jsxm#").append(i).append("#swsxdm]} == 637413735929075712 || {Q[tcvat_ybnsr_jsxm#").append(i).append("#swsxdm]} == 637413735937464320").append(",{Q[tcvat_ybnsr_jsxm#").append(i).append("#bqsjdjse]},0)");
            fb4_1_bqsjdjse_formula.append('+');
            fb4_1_bqfse_formula.append("if({Q[tcvat_ybnsr_jsxm#").append(i).append("#swsxdm]} == 637413735929075712 || {Q[tcvat_ybnsr_jsxm#").append(i).append("#swsxdm]} == 637413735937464320").append(",{Q[tcvat_ybnsr_jsxm#").append(i).append("#bqfse]},0)");
            fb4_1_bqfse_formula.append('+');
            fjsf_1_2_3_xejmje_formula.append("if({Q[tcvat_ybnsr_jsxm#").append(i).append("#swsxdm]} ").append("==789806480298652672 || {Q[tcvat_ybnsr_jsxm#").append(i).append("#swsxdm]}==789806480307039232 || {Q[tcvat_ybnsr_jsxm#").append(i).append("#swsxdm]}==789806484249687040 || {Q[tcvat_ybnsr_jsxm#").append(i).append("#swsxdm]}==789806484258073600 || {Q[tcvat_ybnsr_jsxm#").append(i).append("#swsxdm]}==789806484266464256 || {Q[tcvat_ybnsr_jsxm#").append(i).append("#swsxdm]}==789806484274850816, {Q[tcvat_ybnsr_jsxm#").append(i).append("#bqsjdjse]}, 0)");
            fjsf_1_2_3_xejmje_formula.append('+');
        }
        if (dynRowListSize == 0) {
            fb4_1_bqsjdjse_formula.append("0 +");
            fb4_1_bqfse_formula.append("0 +");
            fjsf_1_2_3_xejmje_formula.append("0 +");
        }
        fb4_1_bqsjdjse_formula = fb4_1_bqsjdjse_formula.replace(fb4_1_bqsjdjse_formula.length() - 1, fb4_1_bqsjdjse_formula.length(), "");
        FormulaVo fb4_1_bqsjdjse_formulaVo = new FormulaVo();
        fb4_1_bqsjdjse_formulaVo.setFormula(fb4_1_bqsjdjse_formula.toString());
        fb4_1_bqsjdjse_formulaVo.setFormulaKey("tcvat_ybnsr_fb4#1#bqsjdjse");
        fb4_1_bqsjdjse_formulaVo.setFormulaType("1");
        fb4_1_bqsjdjse_formulaVo.setDatatype("number");
        formulaMap.put("tcvat_ybnsr_fb4#1#bqsjdjse", fb4_1_bqsjdjse_formulaVo);
        fb4_1_bqfse_formula = fb4_1_bqfse_formula.replace(fb4_1_bqfse_formula.length() - 1, fb4_1_bqfse_formula.length(), "");
        FormulaVo fb4_1_bqfse_formulaVo = new FormulaVo();
        fb4_1_bqfse_formulaVo.setFormula(fb4_1_bqfse_formula.toString());
        fb4_1_bqfse_formulaVo.setFormulaKey("tcvat_ybnsr_fb4#1#bqfse");
        fb4_1_bqfse_formulaVo.setFormulaType("1");
        fb4_1_bqfse_formulaVo.setDatatype("number");
        formulaMap.put("tcvat_ybnsr_fb4#1#bqfse", fb4_1_bqfse_formulaVo);
        fjsf_1_2_3_xejmje_formula = fjsf_1_2_3_xejmje_formula.replace(fjsf_1_2_3_xejmje_formula.length() - 1, fjsf_1_2_3_xejmje_formula.length(), "");
        if (TcvatTemplateConstant.FB5_WITHOUT_ZZS_XEJMJE_TEMPLATEID.contains(templateId)) {
            String resultStr = "{Q[tcvat_ybnsr_zb#1#bqybtse]} + {Q[tcvat_ybnsr_zb#3#bqybtse]}";
            if (Long.valueOf("1421817293482273792").compareTo(templateId) == 0) {
                resultStr = "{Q[tcvat_ybqyhzsb_fpb#1#lwfpse]} + {Q[tcvat_ybqyhzsb_fpb#1#jzjtfpse]}+{Q[tcvat_ybqyhzsb_fpb#1#ysfwfpse]}+{Q[tcvat_ybqyhzsb_fpb#1#ysfwjzjtfpse]}";
            }
            FormulaVo fjsf_1_ybzzs_formulaVo = new FormulaVo();
            fjsf_1_ybzzs_formulaVo.setFormula("if({P[cswhjssenable]}==1," + resultStr + '+' + fjsf_1_2_3_xejmje_formula + ",0)");
            fjsf_1_ybzzs_formulaVo.setFormulaKey("tcvat_sb_fjsf#1#ybzzs");
            fjsf_1_ybzzs_formulaVo.setFormulaType("1");
            fjsf_1_ybzzs_formulaVo.setDatatype("number");
            formulaMap.put("tcvat_sb_fjsf#1#ybzzs", fjsf_1_ybzzs_formulaVo);
            FormulaVo fjsf_2_ybzzs_formulaVo = new FormulaVo();
            fjsf_2_ybzzs_formulaVo.setFormula("if({P[jyffjenable]}==1," + resultStr + '+' + fjsf_1_2_3_xejmje_formula + ",0)");
            fjsf_2_ybzzs_formulaVo.setFormulaKey("tcvat_sb_fjsf#2#ybzzs");
            fjsf_2_ybzzs_formulaVo.setFormulaType("1");
            fjsf_2_ybzzs_formulaVo.setDatatype("number");
            formulaMap.put("tcvat_sb_fjsf#2#ybzzs", fjsf_2_ybzzs_formulaVo);
            FormulaVo fjsf_3_ybzzs_formulaVo = new FormulaVo();
            fjsf_3_ybzzs_formulaVo.setFormula("if({P[dfjyffjenable]}==1," + resultStr + '+' + fjsf_1_2_3_xejmje_formula + ",0)");
            fjsf_3_ybzzs_formulaVo.setFormulaKey("tcvat_sb_fjsf#3#ybzzs");
            fjsf_3_ybzzs_formulaVo.setFormulaType("1");
            fjsf_3_ybzzs_formulaVo.setDatatype("number");
            formulaMap.put("tcvat_sb_fjsf#3#ybzzs", fjsf_3_ybzzs_formulaVo);
        } else {
            FormulaVo fjsf_1_ybzzs_formulaVo = new FormulaVo();
            fjsf_1_ybzzs_formulaVo.setFormula(fjsf_1_2_3_xejmje_formula.toString());
            fjsf_1_ybzzs_formulaVo.setFormulaKey("tcvat_sb_fjsf#1#xejmje");
            fjsf_1_ybzzs_formulaVo.setFormulaType("1");
            fjsf_1_ybzzs_formulaVo.setDatatype("number");
            formulaMap.put("tcvat_sb_fjsf#1#xejmje", fjsf_1_ybzzs_formulaVo);
            FormulaVo fjsf_2_ybzzs_formulaVo = new FormulaVo();
            fjsf_2_ybzzs_formulaVo.setFormula(fjsf_1_2_3_xejmje_formula.toString());
            fjsf_2_ybzzs_formulaVo.setFormulaKey("tcvat_sb_fjsf#2#xejmje");
            fjsf_2_ybzzs_formulaVo.setFormulaType("1");
            fjsf_2_ybzzs_formulaVo.setDatatype("number");
            formulaMap.put("tcvat_sb_fjsf#2#xejmje", fjsf_2_ybzzs_formulaVo);
            FormulaVo fjsf_3_ybzzs_formulaVo = new FormulaVo();
            fjsf_3_ybzzs_formulaVo.setFormula(fjsf_1_2_3_xejmje_formula.toString());
            fjsf_3_ybzzs_formulaVo.setFormulaKey("tcvat_sb_fjsf#3#xejmje");
            fjsf_3_ybzzs_formulaVo.setFormulaType("1");
            fjsf_3_ybzzs_formulaVo.setDatatype("number");
            formulaMap.put("tcvat_sb_fjsf#3#xejmje", fjsf_3_ybzzs_formulaVo);
        }
    }

    private String buildDynamicFormula(int seqno) {
        StringBuilder formula = new StringBuilder();
        for (int i = 2; i < seqno; ++i) {
            formula.append('-').append("{Q[tcvat_ybnsr_jsxm#").append(i).append("#bqsjdjse]}");
        }
        return formula.toString();
    }
}

