/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.dynamicrow.ncp.hyncpsl.hyncpsl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.rule.impl.AbstractRuleCalculateService;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchCellSummaryDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchMainDto;
import kd.taxc.bdtaxr.common.rule.dto.RuleEngineParamDto;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;
import kd.taxc.tcvat.business.dynamicrow.ncp.hyncpsl.hyncpsl.TcvatNcpDraftAccessConfigBusiness;
import kd.taxc.tcvat.business.dynamicrow.ncp.hyncpsl.hyncpsl.TcvatNcpDraftDynCalculateBusiness;
import kd.taxc.tcvat.business.dynamicrow.rulefetch.AbstractGeneralDynamicRowListFetchPlugin;

public class TcvatHyncpQuantityFetchDataPlugin
extends AbstractGeneralDynamicRowListFetchPlugin {
    private static final Log logger = LogFactory.getLog(TcvatHyncpQuantityFetchDataPlugin.class);
    private TcvatNcpDraftAccessConfigBusiness tcvatNcpDraftAccessConfigBusiness = new TcvatNcpDraftAccessConfigBusiness();

    @Override
    protected AbstractRuleCalculateService getDraftDynCalculateService() {
        return new TcvatNcpDraftDynCalculateBusiness();
    }

    @Override
    protected QFilter buildRuleFilter(Map<String, Object> extendParams, Object draftpurpose, Long orgId, Date startDate, Date endDate) {
        QFilter orgFilter = new QFilter("useorg", "=", (Object)orgId);
        QFilter hyncpmcFilter = new QFilter("hyncpmc", "=", (Object)Long.valueOf((String)extendParams.get("hyncpmcid")));
        QFilter dateFilter = new QFilter("startdate", "<=", (Object)startDate).and(new QFilter("enddate", ">=", (Object)endDate).or(new QFilter("enddate", "is null", null)));
        DynamicObjectCollection ncpkcStand = QueryServiceHelper.query((String)"tcvat_ncpkc_standard", (String)"cpmc", (QFilter[])new QFilter[]{orgFilter, hyncpmcFilter, dateFilter});
        List cpmcidList = ncpkcStand.stream().map(n -> n.getLong("cpmc")).collect(Collectors.toList());
        return new QFilter("rulepurpose", "like", (Object)("%" + draftpurpose + "%")).and(new QFilter("cpmc", "in", cpmcidList));
    }

    @Override
    protected Map<String, String> getDynRowBizTypeMap() {
        HashMap<String, String> dynRowBizTypeMap = new HashMap<String, String>(8);
        dynRowBizTypeMap.put("hyncpsldth#1", "");
        return dynRowBizTypeMap;
    }

    private List<DynamicObject> getPrivateRuleList(String tableName, String selectFields, Long orgId, QFilter accessWhereFilter) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(16);
        QFilter orgQ = new QFilter("org", "=", (Object)orgId);
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)accessWhereFilter)) {
            orgQ.and(accessWhereFilter);
        }
        QFilter privateFilter = new QFilter("ruletype", "=", (Object)"private");
        List<QFilter> enableQList = this.tcvatNcpDraftAccessConfigBusiness.buildEnableQfilter(tableName);
        enableQList.stream().forEach(o -> orgQ.and(o));
        Object[] privateAccessConfigList = BusinessDataServiceHelper.load((String)tableName, (String)selectFields, (QFilter[])new QFilter[]{orgQ, privateFilter});
        if (ArrayUtils.isNotEmpty((Object[])privateAccessConfigList)) {
            Collections.addAll(list, privateAccessConfigList);
        }
        return list;
    }

    @Override
    protected List<DynamicObject> getFetchItems(BussinessParamsVo bussinessParamsVo, Map<String, String> dynRowBizTypeMap) {
        RuleEngineParamDto paramDto = this.getRuleEngineParamDto(bussinessParamsVo, null);
        return this.getPrivateRuleList("tcvat_ncp_product_rule", "number,name,status,creator,modifier,enable,createtime,modifytime,ruletype,org,rulepurpose,issystem,cpmc,dhzsfs,slsjzb,entryentity.datadirection,entryentity.bizname,entryentity.datatype,entryentity.conditionjson,entryentity.filtercondition,entryentity.amountfield,entryentity.table,entryentity.absolute,entryentity1.bizname1,entryentity1.table1,entryentity1.amountfield1,entryentity1.absolute1,entryentity1.datatype1,entryentity1.datadirection1,entryentity1.filtercondition1,entryentity1.conditionjson1,entryentity2.bizname2,entryentity2.table2,entryentity2.amountfield2,entryentity2.absolute2,entryentity2.datatype2,entryentity2.datadirection2,entryentity2.filtercondition2,entryentity2.conditionjson2,id,entryentity.id,entryentity.seq,entryentity1.id,entryentity1.seq,entryentity2.id,entryentity2.seq", Long.valueOf(bussinessParamsVo.getOrgId()), paramDto.getAccessWhereFilter());
    }

    @Override
    public List<Map<String, Object>> getDynListMapByDynRowNo(BussinessParamsVo bussinessParamsVo, String dynRowNo, List<DynamicObject> fetchItemsByBizType, RuleFetchMainDto ruleFetchMainDto, Map<String, Map<String, Object>> extenResultMap) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>(16);
        List ruleFetchCellSummaryList = ruleFetchMainDto.getRuleFetchCellSummaryList();
        HashMap totalSalesResultMap = new HashMap(8);
        HashMap outBuyQuantityResultMap = new HashMap(8);
        HashMap incomeResultMap = new HashMap(8);
        ruleFetchCellSummaryList.stream().forEach(cell -> {
            if (!ObjectUtils.isEmpty((Object)cell.getFetchEntryentity()) && "entryentity".equalsIgnoreCase(cell.getFetchEntryentity()) && !ObjectUtils.isEmpty((Object)cell.getRuleFetchCardList())) {
                totalSalesResultMap.put(cell.getRuleItem(), cell.getAmount().toString());
            }
            if (!ObjectUtils.isEmpty((Object)cell.getFetchEntryentity()) && "entryentity1".equalsIgnoreCase(cell.getFetchEntryentity()) && !ObjectUtils.isEmpty((Object)cell.getRuleFetchCardList())) {
                outBuyQuantityResultMap.put(cell.getRuleItem(), cell.getAmount().toString());
            }
            if (!ObjectUtils.isEmpty((Object)cell.getFetchEntryentity()) && "entryentity2".equalsIgnoreCase(cell.getFetchEntryentity()) && !ObjectUtils.isEmpty((Object)cell.getRuleFetchCardList())) {
                incomeResultMap.put(cell.getRuleItem(), cell.getAmount().toString());
            }
        });
        int i = 1;
        for (DynamicObject fetchItem : fetchItemsByBizType) {
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            String prefix = dynRowNo.split("#")[0];
            map.put(prefix + "#seq", i++);
            map.put(prefix + "#hy_name", fetchItem.getString("name"));
            map.put(prefix + "#hy_productname", fetchItem.getDynamicObject("cpmc").getLong("id"));
            map.put(prefix + "#hy_hyncp_name", bussinessParamsVo.getExtendParams().get("hyncpmcid"));
            map.put(prefix + "#hy_actual_goods_sale_count", null == totalSalesResultMap.get(fetchItem.getString("id")) ? BigDecimal.ZERO : totalSalesResultMap.get(fetchItem.getString("id")));
            this.setReportItem(fetchItem.getLong("id"), mapList, prefix, "#hy_actual_goods_sale_count", "entryentity", ruleFetchMainDto);
            map.put(prefix + "#hy_purch_sale_goods_count", null == outBuyQuantityResultMap.get(fetchItem.getString("id")) ? BigDecimal.ZERO : outBuyQuantityResultMap.get(fetchItem.getString("id")));
            this.setReportItem(fetchItem.getLong("id"), mapList, prefix, "#hy_purch_sale_goods_count", "entryentity1", ruleFetchMainDto);
            map.put(prefix + "#hy_sales_revenue", null == incomeResultMap.get(fetchItem.getString("id")) ? BigDecimal.ZERO : incomeResultMap.get(fetchItem.getString("id")));
            this.setReportItem(fetchItem.getLong("id"), mapList, prefix, "#hy_sales_revenue", "entryentity2", ruleFetchMainDto);
            map.put(prefix + "#hy_slsjzb", fetchItem.getBigDecimal("slsjzb"));
            map.put(prefix + "#hy_dhzsfs", fetchItem.getString("dhzsfs"));
            mapList.add(map);
        }
        return mapList;
    }

    @Override
    protected Map<String, Map<String, Object>> getExtendResultMap(BussinessParamsVo bussinessParamsVo, DynamicObjectCollection fetchItems) {
        return null;
    }

    @Override
    protected void dealWithRuleFetchMainDtoExtend(RuleFetchMainDto ruleFetchMainDto, DynamicObjectCollection fetchItems) {
        List fetchItemIds = fetchItems.stream().map(o -> o.getString("id")).collect(Collectors.toList());
        HashMap taxResultMap = new HashMap(8);
        ruleFetchMainDto.getRuleFetchCellSummaryList().stream().forEach(cell -> {
            if (!ObjectUtils.isEmpty((Object)cell.getFetchEntryentity()) && "entryentity1".equalsIgnoreCase(cell.getFetchEntryentity())) {
                taxResultMap.put(cell.getRuleItem(), cell.getAmount().toString());
            }
        });
        List<String> entrytity1ExcludeItems = this.getEntrytity1ExcludeItems(fetchItems);
        fetchItemIds.stream().forEach(access -> {
            if (!taxResultMap.containsKey(access) && !entrytity1ExcludeItems.contains(access)) {
                RuleFetchCellSummaryDto cellSummaryDto = new RuleFetchCellSummaryDto("tcvat_ncp_product_rule", access, access, null, BigDecimal.ZERO, BigDecimal.ZERO, "entryentity1");
                ruleFetchMainDto.getRuleFetchCellSummaryList().add(cellSummaryDto);
            }
        });
    }

    protected List<String> getEntrytity1ExcludeItems(DynamicObjectCollection fetchItems) {
        return new ArrayList<String>(2);
    }

    private void setReportItem(Long xmId, List<Map<String, Object>> mapList, String prefix, String suffix, String entryentity, RuleFetchMainDto fetchMainDto) {
        if (fetchMainDto == null) {
            return;
        }
        List ruleFetchCellSummaryList = fetchMainDto.getRuleFetchCellSummaryList();
        if (ruleFetchCellSummaryList == null) {
            return;
        }
        for (RuleFetchCellSummaryDto summaryDto : ruleFetchCellSummaryList) {
            if (!summaryDto.getRuleItem().equalsIgnoreCase(xmId.toString()) || !summaryDto.getFetchEntryentity().equalsIgnoreCase(entryentity)) continue;
            summaryDto.setReportItem(prefix + "#" + (mapList.size() + 1) + suffix);
        }
    }
}

