/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.dynamicrow.ncp.hyncpsl.sjgdg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.taxc.bdtaxr.business.rule.impl.AbstractRuleAccessConfigService;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.lang3.ObjectUtils;

public class TcvatNcpSjgDraftAccessConfigBusiness
extends AbstractRuleAccessConfigService {
    public TcvatNcpSjgDraftAccessConfigBusiness() {
        this.accessConfigEntityName = "tcvat_ncp_rule";
        this.accessConfigSelectFields = MetadataUtil.getAllSubFieldString((String)this.accessConfigEntityName);
    }

    protected List<QFilter> buildEnableQfilter(String entityNumber) {
        ArrayList<QFilter> list = new ArrayList<QFilter>(2);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        IDataEntityProperty enableProperty = mainEntityType.findProperty("enable");
        IDataEntityProperty statusProperty = mainEntityType.findProperty("status");
        IDataEntityProperty billstatusProperty = mainEntityType.findProperty("billstatus");
        IDataEntityProperty ylflProperty = mainEntityType.findProperty("ylfl");
        if (ObjectUtils.isNotEmpty((Object)enableProperty) && StringUtil.isNotBlank((CharSequence)enableProperty.getAlias())) {
            list.add(new QFilter("enable", "=", (Object)Character.valueOf('1')));
        }
        if (ObjectUtils.isNotEmpty((Object)statusProperty) && StringUtil.isNotBlank((CharSequence)statusProperty.getAlias())) {
            list.add(new QFilter("status", "=", (Object)"A"));
        }
        if (ObjectUtils.isNotEmpty((Object)billstatusProperty) && StringUtil.isNotBlank((CharSequence)billstatusProperty.getAlias())) {
            list.add(new QFilter("billstatus", "=", (Object)"A"));
        }
        if (ObjectUtils.isNotEmpty((Object)ylflProperty) && StringUtil.isNotBlank((CharSequence)ylflProperty.getAlias())) {
            list.add(new QFilter("ylfl", "=", (Object)"sjg"));
        }
        return list;
    }

    protected List<DynamicObject> querySharingPlanAccessConfig(Long orgId, QFilter sharingPlanWhereFilter) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        if (StringUtil.isBlank((CharSequence)this.sharingplanEntityName)) {
            return list;
        }
        return super.querySharingPlanAccessConfig(orgId, sharingPlanWhereFilter);
    }

    public List<DynamicObject> queryMatchAccessConfig(Long orgId, QFilter accessWhereFilter, QFilter sharingPlanWhereFilter) {
        ArrayList<DynamicObject> allAccessConfigList = new ArrayList<DynamicObject>();
        List privateAccessConfigList = this.queryPrivateAccessConfig(orgId, accessWhereFilter);
        allAccessConfigList.addAll(privateAccessConfigList);
        List<DynamicObject> sharingPlanList = this.querySharingPlanAccessConfig(orgId, sharingPlanWhereFilter);
        List publicAccessProjectIds = sharingPlanList.stream().map(o -> o.getLong(this.sharingPlan_Rule)).collect(Collectors.toList());
        if (ObjectUtils.isNotEmpty(publicAccessProjectIds)) {
            ArrayList publicAccessConfigList = new ArrayList();
            QFilter accessIdQ = new QFilter("id", "in", publicAccessProjectIds);
            QFilter publicFilter = new QFilter(this.accessConfig_RuleType, "=", (Object)"public");
            List<QFilter> list = this.buildEnableQfilter(this.accessConfigEntityName);
            list.stream().forEach(o -> accessIdQ.and(o));
            DynamicObject[] collection = BusinessDataServiceHelper.load((String)this.accessConfigEntityName, (String)this.accessConfigSelectFields, (QFilter[])new QFilter[]{accessIdQ, publicFilter});
            if (ObjectUtils.isNotEmpty((Object)collection)) {
                Collections.addAll(publicAccessConfigList, collection);
                allAccessConfigList.addAll(publicAccessConfigList);
            }
        }
        return allAccessConfigList;
    }
}

