/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.dynamicrow.ncp.hyncpsl.sjgdg;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.business.rule.impl.AbstractRuleCalculateService;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchCellSummaryDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchMainDto;
import kd.taxc.bdtaxr.common.rule.dto.RuleEngineParamDto;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;
import kd.taxc.tcvat.business.dynamicrow.ncp.hyncpsl.sjgdg.TcvatNcpSjgDraftAccessConfigBusiness;
import kd.taxc.tcvat.business.dynamicrow.ncp.hyncpsl.sjgdg.TcvatNcpSjgDraftDynCalculateBusiness;
import kd.taxc.tcvat.business.dynamicrow.rulefetch.AbstractGeneralDynamicRowListFetchPlugin;

public class TcvatSjgdgFetchDataPlugin
extends AbstractGeneralDynamicRowListFetchPlugin {
    TcvatNcpSjgDraftAccessConfigBusiness tcvatNcpSjgDraftAccessConfigBusiness = new TcvatNcpSjgDraftAccessConfigBusiness();

    @Override
    protected AbstractRuleCalculateService getDraftDynCalculateService() {
        return new TcvatNcpSjgDraftDynCalculateBusiness();
    }

    @Override
    protected QFilter buildRuleFilter(Map<String, Object> extendParams, Object draftpurpose, Long orgId, Date startDate, Date endDate) {
        QFilter draftPurposeFilter = new QFilter("rulepurpose", "like", (Object)("%" + draftpurpose + "%"));
        QFilter lyflFilter = new QFilter("ylfl", "=", (Object)"sjg");
        QFilter hyncpFilter = new QFilter("hyncp", "=", (Object)Long.valueOf((String)extendParams.get("hyncpmcid")));
        return draftPurposeFilter.and(lyflFilter).and(hyncpFilter);
    }

    @Override
    protected Map<String, String> getDynRowBizTypeMap() {
        HashMap<String, String> dynRowBizTypeMap = new HashMap<String, String>(8);
        dynRowBizTypeMap.put("sjgdygdth#1", "");
        return dynRowBizTypeMap;
    }

    @Override
    protected List<DynamicObject> getFetchItems(BussinessParamsVo bussinessParamsVo, Map<String, String> dynRowBizTypeMap) {
        RuleEngineParamDto paramDto = this.getRuleEngineParamDto(bussinessParamsVo, null);
        return this.getPrivateRuleList("tcvat_ncp_rule", "number,name,status,creator,modifier,enable,createtime,modifytime,ruletype,org,rulepurpose,issystem,hyncp,ylfl,entryentity.datadirection,entryentity.bizname,entryentity.datatype,entryentity.conditionjson,entryentity.filtercondition,entryentity.amountfield,entryentity.table,entryentity.absolute,entryentity1.bizname1,entryentity1.table1,entryentity1.amountfield1,entryentity1.absolute1,entryentity1.datatype1,entryentity1.datadirection1,entryentity1.filtercondition1,entryentity1.conditionjson1,entryentity2.bizname2,entryentity2.table2,entryentity2.amountfield2,entryentity2.absolute2,entryentity2.datatype2,entryentity2.datadirection2,entryentity2.filtercondition2,entryentity2.conditionjson2,entryentity3.bizname3,entryentity3.table3,entryentity3.amountfield3,entryentity3.absolute3,entryentity3.datatype3,entryentity3.datadirection3,entryentity3.filtercondition3,entryentity3.conditionjson3,id,entryentity.id,entryentity.seq,entryentity1.id,entryentity1.seq,entryentity2.id,entryentity2.seq,entryentity3.id,entryentity3.seq", Long.valueOf(bussinessParamsVo.getOrgId()), paramDto.getAccessWhereFilter());
    }

    private List<DynamicObject> getPrivateRuleList(String tableName, String selectFields, Long orgId, QFilter accessWhereFilter) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(16);
        QFilter orgQ = new QFilter("org", "=", (Object)orgId);
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)accessWhereFilter)) {
            orgQ.and(accessWhereFilter);
        }
        QFilter privateFilter = new QFilter("ruletype", "=", (Object)"private");
        List<QFilter> enableQList = this.tcvatNcpSjgDraftAccessConfigBusiness.buildEnableQfilter("tcvat_ncp_rule");
        enableQList.stream().forEach(o -> orgQ.and(o));
        DynamicObject[] privateAccessConfigList = BusinessDataServiceHelper.load((String)tableName, (String)selectFields, (QFilter[])new QFilter[]{orgQ, privateFilter});
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)privateAccessConfigList)) {
            Collections.addAll(list, privateAccessConfigList);
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> getDynListMapByDynRowNo(BussinessParamsVo bussinessParamsVo, String dynRowNo, List<DynamicObject> fetchItemsByBizType, RuleFetchMainDto ruleFetchMainDto, Map<String, Map<String, Object>> extenResultMap) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>(16);
        List ruleFetchCellSummaryList = ruleFetchMainDto.getRuleFetchCellSummaryList();
        HashMap totalSalesResultMap = new HashMap(8);
        HashMap jehjResultMap = new HashMap(8);
        ruleFetchCellSummaryList.stream().forEach(cell -> {
            if (!ObjectUtils.isEmpty((Object)cell.getFetchEntryentity()) && "entryentity".equalsIgnoreCase(cell.getFetchEntryentity()) && !ObjectUtils.isEmpty((Object)cell.getRuleFetchCardList())) {
                totalSalesResultMap.put(cell.getRuleItem(), cell.getAmount().toString());
            }
            if (!ObjectUtils.isEmpty((Object)cell.getFetchEntryentity()) && "entryentity1".equalsIgnoreCase(cell.getFetchEntryentity()) && !ObjectUtils.isEmpty((Object)cell.getRuleFetchCardList())) {
                jehjResultMap.put(cell.getRuleItem(), cell.getAmount().toString());
            }
        });
        String prefix = dynRowNo.split("#")[0];
        String sxPrefix = ResManager.loadKDString((String)"\u672c\u671f\u91c7\u8d2d: ", (String)"TcvatSjgdgFetchDataPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]);
        for (DynamicObject fetchItem : fetchItemsByBizType) {
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            map.put(prefix + "#sjg_sx", sxPrefix + fetchItem.getString("name"));
            map.put(prefix + "#sjg_sl", null == totalSalesResultMap.get(fetchItem.getString("id")) ? BigDecimal.ZERO : totalSalesResultMap.get(fetchItem.getString("id")));
            this.setReportItem(fetchItem.getLong("id"), mapList, prefix, "#sjg_sl", "entryentity", ruleFetchMainDto);
            map.put(prefix + "#sjg_jehj", null == jehjResultMap.get(fetchItem.getString("id")) ? BigDecimal.ZERO : jehjResultMap.get(fetchItem.getString("id")));
            this.setReportItem(fetchItem.getLong("id"), mapList, prefix, "#sjg_jehj", "entryentity1", ruleFetchMainDto);
            map.put(prefix + "#sjg_dqm", null == totalSalesResultMap.get(fetchItem.getString("id")) ? BigDecimal.ZERO : totalSalesResultMap.get(fetchItem.getString("id")));
            map.put(prefix + "#sjg_pjgmdj", BigDecimal.ZERO);
            mapList.add(map);
        }
        return mapList;
    }

    @Override
    protected Map<String, Map<String, Object>> getExtendResultMap(BussinessParamsVo bussinessParamsVo, DynamicObjectCollection fetchItems) {
        return null;
    }

    @Override
    protected void dealWithRuleFetchMainDtoExtend(RuleFetchMainDto ruleFetchMainDto, DynamicObjectCollection fetchItems) {
        List fetchItemIds = fetchItems.stream().map(o -> o.getString("id")).collect(Collectors.toList());
        HashMap taxResultMap = new HashMap(8);
        ruleFetchMainDto.getRuleFetchCellSummaryList().stream().forEach(cell -> {
            if (!ObjectUtils.isEmpty((Object)cell.getFetchEntryentity()) && "entryentity1".equalsIgnoreCase(cell.getFetchEntryentity())) {
                taxResultMap.put(cell.getRuleItem(), cell.getAmount().toString());
            }
        });
        List<String> entrytity1ExcludeItems = this.getEntrytity1ExcludeItems(fetchItems);
        fetchItemIds.stream().forEach(access -> {
            if (!taxResultMap.containsKey(access) && !entrytity1ExcludeItems.contains(access)) {
                RuleFetchCellSummaryDto cellSummaryDto = new RuleFetchCellSummaryDto("tcvat_ncp_product_rule", access, access, null, BigDecimal.ZERO, BigDecimal.ZERO, "entryentity1");
                ruleFetchMainDto.getRuleFetchCellSummaryList().add(cellSummaryDto);
            }
        });
    }

    protected List<String> getEntrytity1ExcludeItems(DynamicObjectCollection fetchItems) {
        return new ArrayList<String>(2);
    }

    private void setReportItem(Long xmId, List<Map<String, Object>> mapList, String prefix, String suffix, String entryentity, RuleFetchMainDto fetchMainDto) {
        if (fetchMainDto == null) {
            return;
        }
        List ruleFetchCellSummaryList = fetchMainDto.getRuleFetchCellSummaryList();
        if (ruleFetchCellSummaryList == null) {
            return;
        }
        for (RuleFetchCellSummaryDto summaryDto : ruleFetchCellSummaryList) {
            if (!summaryDto.getRuleItem().equalsIgnoreCase(xmId.toString()) || !summaryDto.getFetchEntryentity().equalsIgnoreCase(entryentity)) continue;
            summaryDto.setReportItem(prefix + "#" + (mapList.size() + 1) + suffix);
        }
    }
}

