/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.dynamicrow.precision.handle;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.tcvat.business.dynamicrow.precision.PrecisionHandler;
import kd.taxc.tcvat.business.dynamicrow.precision.handle.CommonHandle;

public class TcvatZzsybnsrHNGXHandle
implements PrecisionHandler {
    private static final Set<String> HUNAN6 = Sets.newHashSet((Object[])new String[]{"tcvat_ybnsr_trccfhdncp#2#hddhsl", "tcvat_ybnsr_trccfhdncp#1#hddhsl", "tcvat_ybnsr_gjncpzjxshd#2#dqxsncpsl"});
    private static final Set<String> HNGX6 = Sets.newHashSet((Object[])new String[]{"tcvat_ybnsr_trccfhdncp#2#hddhsl", "tcvat_ybnsr_trccfhdncp#1#hddhsl"});

    @Override
    public Map<String, EntityField> handle(DeclareRequestModel requestModel) {
        HashMap<String, EntityField> result = new HashMap<String, EntityField>();
        String templateNumber = requestModel.getTemplateNumber();
        if ("VAT202206-HUNAN".equalsIgnoreCase(templateNumber)) {
            result.putAll(CommonHandle.generateCustomEntity(HUNAN6, "#0.000000", 6));
        } else if ("VAT202206-HNGX".equalsIgnoreCase(templateNumber)) {
            result.putAll(CommonHandle.generateCustomEntity(HNGX6, "#0.000000", 6));
        }
        return result;
    }
}

