/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.dynamicrow.rulefetch;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.ExceptionUtils;
import kd.taxc.bdtaxr.business.rule.impl.AbstractRuleCalculateService;
import kd.taxc.bdtaxr.business.rulefetch.RuleFetchServiceImpl;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchCellSummaryDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchMainDto;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicListBasePlugin;
import kd.taxc.bdtaxr.common.rule.dto.RuleEngineParamDto;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;
import org.apache.commons.collections.CollectionUtils;

public abstract class AbstractGeneralDynamicRowListFetchPlugin
extends AbstractDynamicListBasePlugin {
    private static final Log logger = LogFactory.getLog(AbstractGeneralDynamicRowListFetchPlugin.class);
    protected static final String TEMPLATE_ID = "templateId";

    public List<Map<String, Object>> query(BussinessParamsVo bussinessParamsVo) {
        logger.info("start AbstractGeneralDynamicRowListFetchPlugin query");
        Map<String, List<Map<String, Object>>> fetchItemListMap = this.batchFetchDynRowList(bussinessParamsVo);
        if (fetchItemListMap == null) {
            return new ArrayList<Map<String, Object>>();
        }
        String dynRowNo = bussinessParamsVo.getExtendParams().get("dynRowNo").toString();
        return fetchItemListMap.get(dynRowNo) == null ? new ArrayList() : fetchItemListMap.get(dynRowNo);
    }

    public List<DynamicRowModel> globalDynrowQuery(BussinessParamsVo bussinessParamsVo) {
        logger.info("start AbstractGeneralDynamicRowListFetchPlugin globalDynrowQuery");
        Map extendParams = bussinessParamsVo.getExtendParams();
        Long templateId = (Long)extendParams.get(TEMPLATE_ID);
        Map<String, List<Map<String, Object>>> fetchItemListMap = this.batchFetchDynRowList(bussinessParamsVo);
        return this.buildGlobalDynRow(templateId, fetchItemListMap);
    }

    private List<DynamicRowModel> buildGlobalDynRow(Long templateId, Map<String, List<Map<String, Object>>> fetchItemListMap) {
        ArrayList<DynamicRowModel> list = new ArrayList<DynamicRowModel>(8);
        if (null == fetchItemListMap) {
            return list;
        }
        for (Map.Entry<String, List<Map<String, Object>>> entry : fetchItemListMap.entrySet()) {
            DynamicRowModel dynamicRowModel = new DynamicRowModel();
            dynamicRowModel.setTemplateId(templateId);
            dynamicRowModel.setDynRowNo(entry.getKey());
            ArrayList rowList = new ArrayList(8);
            entry.getValue().stream().forEach(row -> rowList.add(new HashMap<String, String>(){
                {
                    for (Map.Entry rowEntry : row.entrySet()) {
                        this.put(rowEntry.getKey(), kd.taxc.bdtaxr.common.tctb.common.util.ObjectUtils.getStringByType(rowEntry.getValue()));
                    }
                }
            }));
            dynamicRowModel.setRowList(rowList);
            list.add(dynamicRowModel);
        }
        return list;
    }

    private Map<String, List<Map<String, Object>>> batchFetchDynRowList(BussinessParamsVo bussinessParamsVo) {
        HashMap<String, List<Map<String, Object>>> result = new HashMap<String, List<Map<String, Object>>>(8);
        Map extendParams = bussinessParamsVo.getExtendParams();
        logger.info("start AbstractGeneralDynamicRowListFetchPlugin batchFetchDynRowList");
        if (bussinessParamsVo.getStartDate() == null || bussinessParamsVo.getEndDate() == null || extendParams.get(TEMPLATE_ID) == null || bussinessParamsVo.getOrgId() == null) {
            return result;
        }
        logger.info("start AbstractGeneralDynamicRowListFetchPlugin bussinessParamsVo");
        Map<String, String> dynRowBizTypeMap = this.getDynRowBizTypeMapByCondition(bussinessParamsVo);
        if (null == dynRowBizTypeMap || ObjectUtils.isEmpty(dynRowBizTypeMap)) {
            return null;
        }
        List<DynamicObject> ruleList = this.getFetchItems(bussinessParamsVo, dynRowBizTypeMap);
        DynamicObjectCollection fetchItems = ruleList.stream().collect(Collectors.toCollection(DynamicObjectCollection::new));
        if (null == fetchItems || ObjectUtils.isEmpty((Object)fetchItems)) {
            return null;
        }
        logger.info("start AbstractGeneralDynamicRowListFetchPlugin fetchItems" + fetchItems.size());
        RuleFetchMainDto ruleFetchMainDto = this.calculateRuleAccess(bussinessParamsVo, fetchItems);
        logger.info("\u5f97\u5230\u53d6\u6570\u8ba1\u7b97\u7ed3\u679c\uff1a{}", (Object)(ruleFetchMainDto.getRuleFetchCellSummaryList() == null ? 0 : ruleFetchMainDto.getRuleFetchCellSummaryList().size()));
        this.dealWithRuleFetchMainDto(ruleFetchMainDto, fetchItems);
        this.buildFetchDynRowList(bussinessParamsVo, result, dynRowBizTypeMap, fetchItems, ruleFetchMainDto);
        if (!ObjectUtils.isEmpty((Object)ruleFetchMainDto) && !ObjectUtils.isEmpty((Object)ruleFetchMainDto.getRuleFetchCellSummaryList())) {
            RuleFetchServiceImpl ruleFetchService = new RuleFetchServiceImpl();
            ruleFetchService.addCellData(ruleFetchMainDto);
        }
        return result;
    }

    protected void buildFetchDynRowList(BussinessParamsVo bussinessParamsVo, Map<String, List<Map<String, Object>>> result, Map<String, String> dynRowBizTypeMap, DynamicObjectCollection fetchItems, RuleFetchMainDto ruleFetchMainDto) {
        ArrayList<String> infos = new ArrayList<String>(16);
        for (Map.Entry<String, String> entry : dynRowBizTypeMap.entrySet()) {
            String dynRowNo = entry.getKey();
            List<DynamicObject> fetchItemsByBizType = fetchItems.stream().collect(Collectors.toList());
            if (CollectionUtils.isEmpty(fetchItemsByBizType)) {
                result.put(dynRowNo, new ArrayList());
                infos.add("buildFetchDynRowList sign zero number is:" + dynRowNo);
                continue;
            }
            Map<String, Map<String, Object>> extendResultMap = this.getExtendResultMap(bussinessParamsVo, fetchItems);
            List<Map<String, Object>> mapList = this.getDynListMapByDynRowNo(bussinessParamsVo, dynRowNo, fetchItemsByBizType, ruleFetchMainDto, extendResultMap);
            result.put(dynRowNo, mapList);
        }
        logger.info(((Object)infos).toString());
    }

    protected void dealWithRuleFetchMainDto(RuleFetchMainDto ruleFetchMainDto, DynamicObjectCollection fetchItems) {
        List fetchItemIds = fetchItems.stream().map(o -> o.getString("id")).collect(Collectors.toList());
        HashMap amountResultMap = new HashMap(8);
        ruleFetchMainDto.getRuleFetchCellSummaryList().stream().forEach(cell -> {
            if (!ObjectUtils.isEmpty((Object)cell.getFetchEntryentity()) && "entryentity".equalsIgnoreCase(cell.getFetchEntryentity())) {
                amountResultMap.put(cell.getRuleItem(), cell.getAmount().toString());
            }
        });
        List<String> entrytityexcludeItems = this.getEntrytityExcludeItems(fetchItems);
        fetchItemIds.stream().forEach(access -> {
            if (!amountResultMap.containsKey(access) && !entrytityexcludeItems.contains(access)) {
                RuleFetchCellSummaryDto cellSummaryDto = new RuleFetchCellSummaryDto("tcvat_ncp_product_rule", access, access, null, BigDecimal.ZERO, BigDecimal.ZERO, "entryentity");
                ruleFetchMainDto.getRuleFetchCellSummaryList().add(cellSummaryDto);
            }
        });
        this.dealWithRuleFetchMainDtoExtend(ruleFetchMainDto, fetchItems);
    }

    protected void dealWithRuleFetchMainDtoExtend(RuleFetchMainDto ruleFetchMainDto, DynamicObjectCollection fetchItems) {
    }

    protected List<String> getEntrytityExcludeItems(DynamicObjectCollection fetchItems) {
        return new ArrayList<String>(2);
    }

    protected Map<String, String> getDynRowBizTypeMapByCondition(BussinessParamsVo bussinessParamsVo) {
        return this.getDynRowBizTypeMap();
    }

    protected Map<String, Map<String, Object>> getExtendResultMap(BussinessParamsVo bussinessParamsVo, DynamicObjectCollection fetchItems) {
        return null;
    }

    public abstract List<Map<String, Object>> getDynListMapByDynRowNo(BussinessParamsVo var1, String var2, List<DynamicObject> var3, RuleFetchMainDto var4, Map<String, Map<String, Object>> var5);

    protected abstract Map<String, String> getDynRowBizTypeMap();

    protected List<DynamicObject> getFetchItems(BussinessParamsVo bussinessParamsVo, Map<String, String> dynRowBizTypeMap) {
        return new ArrayList<DynamicObject>(10);
    }

    private RuleFetchMainDto calculateRuleAccess(BussinessParamsVo bussinessParamsVo, DynamicObjectCollection fetchItems) {
        RuleFetchMainDto ruleFetchMainDto = new RuleFetchMainDto();
        if (CollectionUtils.isEmpty((Collection)fetchItems)) {
            return ruleFetchMainDto;
        }
        Set<Long> ids = fetchItems.stream().map(m -> m.getLong("id")).collect(Collectors.toSet());
        RuleEngineParamDto paramDto = this.getRuleEngineParamDto(bussinessParamsVo, ids);
        try {
            if (!ObjectUtils.isEmpty((Object)paramDto)) {
                AbstractRuleCalculateService service = this.getDraftDynCalculateService();
                List ruleFetchMainDtoList = service.calculateRuleAccess(paramDto);
                return (RuleFetchMainDto)ruleFetchMainDtoList.get(0);
            }
        }
        catch (Exception e) {
            String exceptionStackTraceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            logger.error("\u52a8\u6001\u884c\u53d6\u6570\u62a5\u9519:{}", (Object)exceptionStackTraceMessage);
        }
        return ruleFetchMainDto;
    }

    protected abstract AbstractRuleCalculateService getDraftDynCalculateService();

    protected RuleEngineParamDto getRuleEngineParamDto(BussinessParamsVo bussinessParamsVo, Set<Long> ids) {
        Map extendParams = bussinessParamsVo.getExtendParams();
        Object draftpurpose = extendParams.get("draftpurpose");
        if (ObjectUtils.isEmpty(draftpurpose)) {
            return null;
        }
        Long templateId = (Long)extendParams.get(TEMPLATE_ID);
        Long orgId = Long.parseLong(bussinessParamsVo.getOrgId());
        Date startDate = bussinessParamsVo.getStartDate();
        Date endDate = bussinessParamsVo.getEndDate();
        QFilter accessWhereFilter = this.buildRuleFilter(extendParams, draftpurpose, orgId, startDate, endDate);
        extendParams.put("originalSkssqq", startDate);
        return new RuleEngineParamDto(orgId, startDate, endDate, templateId, accessWhereFilter, null, extendParams);
    }

    protected abstract QFilter buildRuleFilter(Map<String, Object> var1, Object var2, Long var3, Date var4, Date var5);

    protected void setReportItem(Long xmId, List<Map<String, Object>> mapList, String prefix, String suffix, RuleFetchMainDto fetchMainDto) {
        if (fetchMainDto == null) {
            return;
        }
        List ruleFetchCellSummaryList = fetchMainDto.getRuleFetchCellSummaryList();
        if (ruleFetchCellSummaryList == null) {
            return;
        }
        for (RuleFetchCellSummaryDto summaryDto : ruleFetchCellSummaryList) {
            if (!summaryDto.getRuleItem().equalsIgnoreCase(xmId.toString())) continue;
            summaryDto.setReportItem(prefix + "#" + (mapList.size() + 1) + "#" + suffix);
        }
    }
}

